/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.adminconsole.BoatRegistrationsPanel;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;

public class RegattaLogBoatRegistrationDialog
extends DataEntryDialog<Set<BoatDTO>> {
    protected final ErrorReporter errorReporter;
    protected final SailingServiceAsync sailingService;
    protected final StringMessages stringMessages;
    protected final String leaderboardName;
    protected final boolean canBoatsOfCompetitorsChangePerRace;
    protected final BoatRegistrationsPanel boatRegistrationsPanel;

    public RegattaLogBoatRegistrationDialog(String boatClass, SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<BoatDTO> boatsRefresher, Refresher<CompetitorDTO> competitorsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, boolean editable, String leaderboardName, boolean canBoatsOfCompetitorsChangePerRace, DataEntryDialog.DialogCallback<Set<BoatDTO>> callback) {
        super(stringMessages.registerBoats(), null, stringMessages.save(), stringMessages.cancel(), null, callback);
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.sailingService = sailingServiceWrite;
        this.leaderboardName = leaderboardName;
        this.canBoatsOfCompetitorsChangePerRace = canBoatsOfCompetitorsChangePerRace;
        this.boatRegistrationsPanel = new BoatRegistrationsPanel(sailingServiceWrite, userService, boatsRefresher, competitorsRefresher, stringMessages, errorReporter, editable, leaderboardName, canBoatsOfCompetitorsChangePerRace, boatClass, () -> this.validateAndUpdate(), this.getRegisteredBoatsRetriever(), false);
    }

    protected Consumer<AsyncCallback<Collection<BoatDTO>>> getRegisteredBoatsRetriever() {
        return callback -> this.getRegisteredBoats(callback);
    }

    private void getRegisteredBoats(AsyncCallback<Collection<BoatDTO>> callback) {
        if (this.boatRegistrationsPanel.showOnlyBoatsOfLog()) {
            this.sailingService.getBoatRegistrationsInRegattaLog(this.leaderboardName, callback);
        } else {
            this.sailingService.getBoatRegistrationsForLeaderboard(this.leaderboardName, callback);
        }
    }

    protected Widget getAdditionalWidget() {
        return this.boatRegistrationsPanel;
    }

    protected Set<BoatDTO> getResult() {
        return this.boatRegistrationsPanel.getResult();
    }
}

