/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.i18n.CommonStringMessages;
import com.sap.sailing.gwt.ui.adminconsole.RegattaDetailsComposite;
import com.sap.sailing.gwt.ui.adminconsole.SeriesConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.SeriesDescriptor;
import com.sap.sailing.gwt.ui.adminconsole.SeriesEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.RankingMetricTypeFormatter;
import com.sap.sailing.gwt.ui.leaderboard.ScoringSchemeTypeFormatter;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class RegattaDetailsComposite
extends Composite {
    private static final Logger logger = Logger.getLogger(RegattaDetailsComposite.class.getName());
    private RegattaDTO regatta;
    private final CaptionPanel mainPanel;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final AdminConsoleView.Presenter presenter;
    private final Label regattaId;
    private final Label regattaName;
    private final Label startDate;
    private final Label endDate;
    private final Label boatClassName;
    private final Label scoringSystem;
    private final Label rankingMetric;
    private final Label courseAreas;
    private final Label useStartTimeInference;
    private final Label controlTrackingFromStartAndFinishTimes;
    private final Label autoRestartTrackingUponCompetitorSetChange;
    private final Label canBoatsOfCompetitorsChangePerRace;
    private final Label competitorRegistrationType;
    private final Label configuration;
    private final Label buoyZoneRadiusInHullLengths;
    protected final Button registrationLinkWithQRCodeOpenButton;
    private final SelectionModel<SeriesDTO> seriesSelectionModel;
    private final CellTable<SeriesDTO> seriesTable;
    private ListDataProvider<SeriesDTO> seriesListDataProvider;
    private static AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);

    public RegattaDetailsComposite(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.presenter = presenter;
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        this.regatta = null;
        this.mainPanel = new CaptionPanel(stringMessages.regatta());
        VerticalPanel vPanel = new VerticalPanel();
        this.mainPanel.add((Widget)vPanel);
        int rows = 16;
        Grid grid = new Grid(rows, 2);
        vPanel.add((Widget)grid);
        int currentRow = 0;
        this.regattaId = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.id(), "RegattaIdLabel");
        this.regattaName = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.regattaName(), "NameLabel");
        this.startDate = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.startDate(), "StartDateLabel");
        this.endDate = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.endDate(), "EndDateLabel");
        this.boatClassName = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.boatClass(), "BoatClassLabel");
        this.courseAreas = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.courseArea(), "CourseAreaLabel");
        this.useStartTimeInference = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.useStartTimeInference(), "UseStartTimeInferenceLabel");
        this.controlTrackingFromStartAndFinishTimes = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.controlTrackingFromStartAndFinishTimes(), "ControlTrackingFromStartAndFinishTimesLabel");
        this.autoRestartTrackingUponCompetitorSetChange = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.autoRestartTrackingUponCompetitorSetChange(), "AutoRestartTrackingUponCompetitorSetChange");
        this.canBoatsOfCompetitorsChangePerRace = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.canBoatsOfCompetitorsChangePerRace(), "CanBoatsOfCompetitorsChangePerRaceLabel");
        this.competitorRegistrationType = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.competitorRegistrationType(), "CompetitorRegistrationTypeLabel");
        this.buoyZoneRadiusInHullLengths = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.buoyZoneRadiusInHullLengths(), "BuoyZoneRadiusInHullLengthsLabel");
        this.configuration = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.racingProcedureConfiguration(), "RacingProcedureLabel");
        this.scoringSystem = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.scoringSystem(), "ScoringSystemLabel");
        this.rankingMetric = this.createLabelAndValueWidget(grid, currentRow++, stringMessages.rankingMetric(), "RankingMetricLabel");
        this.registrationLinkWithQRCodeOpenButton = this.addRegistrationLinkOpenButton(grid, currentRow++, stringMessages.registrationLink(), "RegistrationLinkWithQRCodeDialog");
        this.seriesTable = this.createRegattaSeriesTable(presenter.getUserService());
        this.seriesTable.ensureDebugId("SeriesCellTable");
        this.seriesSelectionModel = new SingleSelectionModel();
        this.seriesSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.seriesTable.setSelectionModel(this.seriesSelectionModel);
        this.seriesListDataProvider = new ListDataProvider();
        this.seriesListDataProvider.addDataDisplay((HasData)this.seriesTable);
        vPanel.add((Widget)this.seriesTable);
        this.initWidget((Widget)this.mainPanel);
    }

    private Label createLabelAndValueWidget(Grid grid, int row, String label, String debugId) {
        Label valueLabel = new Label();
        valueLabel.ensureDebugId(debugId);
        grid.setWidget(row, 0, (Widget)new Label(String.valueOf(label) + ":"));
        grid.setWidget(row, 1, (Widget)valueLabel);
        return valueLabel;
    }

    private Button addRegistrationLinkOpenButton(Grid grid, int row, String label, String debugId) {
        grid.setWidget(row, 0, (Widget)new Label(String.valueOf(label) + ":"));
        Button button = new Button(this.stringMessages.registrationLinkShare(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        button.ensureDebugId("registrationLinkWithQRCodeOpenButton");
        grid.setWidget(row, 1, (Widget)button);
        return button;
    }

    private CellTable<SeriesDTO> createRegattaSeriesTable(UserService userService) {
        BaseCelltable table = new BaseCelltable(10000, (CellTable.Resources)tableRes);
        table.setWidth("100%");
        3 seriesNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        4 isMedalSeriesColumn = new /* Unavailable Anonymous Inner Class!! */;
        5 startsWithZeroScoreColumn = new /* Unavailable Anonymous Inner Class!! */;
        6 hasSplitFleetContiguousScoringColumn = new /* Unavailable Anonymous Inner Class!! */;
        7 hasCrossFleetMergedRankingColumn = new /* Unavailable Anonymous Inner Class!! */;
        8 isFirstColumnIsNonDiscardableCarryForwardColumn = new /* Unavailable Anonymous Inner Class!! */;
        9 isFleetsCanRunInParallelColumn = new /* Unavailable Anonymous Inner Class!! */;
        10 isOneAlwaysStaysOneColumn = new /* Unavailable Anonymous Inner Class!! */;
        11 maximumNumberOfDiscardsColumn = new /* Unavailable Anonymous Inner Class!! */;
        12 racesColumn = new /* Unavailable Anonymous Inner Class!! */;
        13 fleetsColumn = new /* Unavailable Anonymous Inner Class!! */;
        14 discardsColumn = new /* Unavailable Anonymous Inner Class!! */;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new SeriesConfigImagesBarCell(this.stringMessages), (UserService)userService, series -> this.regatta);
        actionsColumn.addAction("ACTION_EDIT", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, series -> this.editRacesOfRegattaSeries(this.regatta, series));
        actionsColumn.addAction("ACTION_REMOVE", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, series -> {
            RegattaName identifier = new RegattaName(this.regatta.getName());
            if (Window.confirm((String)this.stringMessages.reallyRemoveSeries(series.getName()))) {
                this.sailingServiceWrite.removeSeries((RegattaIdentifier)identifier, series.getName(), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
            }
        });
        table.addColumn((Column)seriesNameColumn, this.stringMessages.series());
        table.addColumn((Column)isMedalSeriesColumn, this.stringMessages.medalSeries());
        table.addColumn((Column)racesColumn, this.stringMessages.races());
        table.addColumn((Column)fleetsColumn, this.stringMessages.fleets());
        table.addColumn((Column)discardsColumn, this.stringMessages.discarding());
        table.addColumn((Column)isFirstColumnIsNonDiscardableCarryForwardColumn, this.stringMessages.firstRaceIsNonDiscardableCarryForward());
        table.addColumn((Column)startsWithZeroScoreColumn, this.stringMessages.startsWithZeroScore());
        table.addColumn((Column)hasSplitFleetContiguousScoringColumn, this.stringMessages.hasSplitFleetContiguousScoring());
        table.addColumn((Column)hasCrossFleetMergedRankingColumn, this.stringMessages.hasCrossFleetMergedRanking());
        table.addColumn((Column)isFleetsCanRunInParallelColumn, this.stringMessages.canFleetsRunInParallel());
        table.addColumn((Column)isOneAlwaysStaysOneColumn, this.stringMessages.oneAlwaysStaysOne());
        table.addColumn((Column)maximumNumberOfDiscardsColumn, this.stringMessages.maximumNumberOfDiscards());
        table.addColumn((Column)actionsColumn, this.stringMessages.actions());
        return table;
    }

    public RegattaDTO getRegatta() {
        return this.regatta;
    }

    public void setRegatta(RegattaDTO regatta) {
        this.regatta = regatta;
        this.updateRegattaDetails();
    }

    private void editRacesOfRegattaSeries(RegattaDTO regatta, SeriesDTO series) {
        SeriesEditDialog raceDialog = new SeriesEditDialog(regatta, series, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        raceDialog.ensureDebugId("SeriesEditDialog");
        raceDialog.show();
    }

    private void updateRacesOfRegattaSeries(RegattaDTO regatta, SeriesDescriptor seriesDescriptor) {
        SeriesDTO series = seriesDescriptor.getSeries();
        List newRaceColumns = seriesDescriptor.getRaces();
        boolean isMedalChanged = series.isMedal() ^ seriesDescriptor.isMedal();
        boolean isFleetsCanRunInParallelChanged = series.isFleetsCanRunInParallel() ^ seriesDescriptor.isFleetsCanRunInParallel();
        boolean isStartsWithZeroScoreChanged = series.isStartsWithZeroScore() ^ seriesDescriptor.isStartsWithZeroScore();
        boolean isFirstColumnIsNonDiscardableCarryForwardChanged = series.isFirstColumnIsNonDiscardableCarryForward() ^ seriesDescriptor.isFirstColumnIsNonDiscardableCarryForward();
        boolean hasSplitFleetContiguousScoringChanged = series.hasSplitFleetContiguousScoring() ^ seriesDescriptor.hasSplitFleetContiguousScoring();
        boolean hasCrossFleetMergedRankingChanged = series.hasCrossFleetMergedRanking() ^ seriesDescriptor.hasCrossFleetMergedRanking();
        boolean seriesResultDiscardingThresholdsChanged = !Arrays.equals(series.getDiscardThresholds(), seriesDescriptor.getResultDiscardingThresholds());
        boolean maximumNumberOfDiscardsChanged = series.getMaximumNumberOfDiscards() != seriesDescriptor.getMaximumNumberOfDiscards();
        boolean oneAlwaysStaysOneChanged = series.isOneAlwaysStaysOne() ^ seriesDescriptor.isOneAlwaysStaysOne();
        boolean seriesNameChanged = !series.getName().equals(seriesDescriptor.getSeriesName());
        RegattaName regattaIdentifier = new RegattaName(regatta.getName());
        List existingRaceColumns = series.getRaceColumns();
        ArrayList<Util.Pair> raceColumnNamesToAddWithInsertIndex = new ArrayList<Util.Pair>();
        ArrayList<String> raceColumnsToRemove = new ArrayList<String>();
        int insertIndex = 0;
        for (RaceColumnDTO newRaceColumn : newRaceColumns) {
            if (!existingRaceColumns.contains(newRaceColumn)) {
                raceColumnNamesToAddWithInsertIndex.add(new Util.Pair((Object)newRaceColumn.getName(), (Object)insertIndex));
            }
            ++insertIndex;
        }
        for (RaceColumnDTO existingRaceColumn : existingRaceColumns) {
            if (newRaceColumns.contains(existingRaceColumn)) continue;
            raceColumnsToRemove.add(existingRaceColumn.getName());
        }
        StringBuilder racesToRemove = new StringBuilder();
        boolean first = true;
        for (String raceColumnToRemove : raceColumnsToRemove) {
            if (first) {
                first = false;
            } else {
                racesToRemove.append(", ");
            }
            racesToRemove.append(raceColumnToRemove);
        }
        if (raceColumnsToRemove.isEmpty() || Window.confirm((String)this.stringMessages.reallyRemoveRace(racesToRemove.toString()))) {
            this.sailingServiceWrite.removeRaceColumnsFromSeries((RegattaIdentifier)regattaIdentifier, series.getName(), raceColumnsToRemove, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    private void updateRegattaDetails() {
        if (this.regatta != null) {
            this.mainPanel.setCaptionText(String.valueOf(this.stringMessages.regatta()) + " " + this.regatta.getName());
            this.regattaId.setText(this.regatta.getName());
            this.regattaName.setText(this.regatta.getName());
            this.startDate.setText(this.regatta.startDate != null ? this.regatta.startDate.toString() : "");
            this.endDate.setText(this.regatta.endDate != null ? this.regatta.endDate.toString() : "");
            this.boatClassName.setText(this.regatta.boatClass != null ? this.regatta.boatClass.getName() : "");
            this.courseAreas.setText(Util.joinStrings((String)", ", (Iterable)Util.map((Iterable)this.regatta.courseAreas, NamedDTO::getName)));
            this.useStartTimeInference.setText(this.regatta.useStartTimeInference ? this.stringMessages.yes() : this.stringMessages.no());
            this.controlTrackingFromStartAndFinishTimes.setText(this.regatta.controlTrackingFromStartAndFinishTimes ? this.stringMessages.yes() : this.stringMessages.no());
            this.autoRestartTrackingUponCompetitorSetChange.setText(this.regatta.autoRestartTrackingUponCompetitorSetChange ? this.stringMessages.yes() : this.stringMessages.no());
            this.canBoatsOfCompetitorsChangePerRace.setText(this.regatta.canBoatsOfCompetitorsChangePerRace ? this.stringMessages.yes() : this.stringMessages.no());
            this.competitorRegistrationType.setText(this.regatta.competitorRegistrationType.getLabel((CommonStringMessages)this.stringMessages));
            this.registrationLinkWithQRCodeOpenButton.setVisible(this.regatta.competitorRegistrationType.isOpen());
            this.buoyZoneRadiusInHullLengths.setText(String.valueOf(this.regatta.buoyZoneRadiusInHullLengths));
            if (this.regatta.configuration != null) {
                this.configuration.setText(this.stringMessages.configured());
            } else {
                this.configuration.setText(this.stringMessages.none());
            }
            ScoringSchemeType scoringScheme = this.regatta.scoringScheme;
            String scoringSystemText = scoringScheme == null ? "" : ScoringSchemeTypeFormatter.format((ScoringSchemeType)scoringScheme, (StringMessages)this.stringMessages);
            this.scoringSystem.setText(scoringSystemText);
            RankingMetrics rankingMetricType = this.regatta.rankingMetricType;
            String rankingMetricText = rankingMetricType == null ? "" : RankingMetricTypeFormatter.getDescription((RankingMetrics)rankingMetricType, (StringMessages)this.stringMessages);
            this.rankingMetric.setText(rankingMetricText);
            this.seriesListDataProvider.getList().clear();
            this.seriesListDataProvider.getList().addAll(this.regatta.series);
        }
    }

    static /* synthetic */ RegattaDTO access$0(RegattaDetailsComposite regattaDetailsComposite) {
        return regattaDetailsComposite.regatta;
    }

    static /* synthetic */ SailingServiceWriteAsync access$1(RegattaDetailsComposite regattaDetailsComposite) {
        return regattaDetailsComposite.sailingServiceWrite;
    }

    static /* synthetic */ Logger access$2() {
        return logger;
    }

    static /* synthetic */ StringMessages access$3(RegattaDetailsComposite regattaDetailsComposite) {
        return regattaDetailsComposite.stringMessages;
    }

    static /* synthetic */ ErrorReporter access$4(RegattaDetailsComposite regattaDetailsComposite) {
        return regattaDetailsComposite.errorReporter;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$5(RegattaDetailsComposite regattaDetailsComposite) {
        return regattaDetailsComposite.presenter;
    }

    static /* synthetic */ void access$6(RegattaDetailsComposite regattaDetailsComposite, RegattaDTO regattaDTO, SeriesDescriptor seriesDescriptor) {
        regattaDetailsComposite.updateRacesOfRegattaSeries(regattaDTO, seriesDescriptor);
    }
}

