/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.gwt.ui.adminconsole.AbstractBoatCertificatesPanel;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;
import java.util.Map;

public class RegattaBoatCertificatesPanel
extends AbstractBoatCertificatesPanel {
    private final RegattaIdentifier regattaIdentifier;

    public RegattaBoatCertificatesPanel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, RegattaDTO regatta, StringMessages stringMessages, ErrorReporter errorReporter) {
        super(sailingServiceWrite, userService, (SecuredDTO)regatta, stringMessages, errorReporter, () -> userService.hasPermission((SecuredDTO)regatta, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE), regatta.getName());
        this.regattaIdentifier = regatta.getRegattaIdentifier();
        this.refresh();
    }

    protected void assignCertificates(SailingServiceWriteAsync sailingServiceWrite, Map<String, ORCCertificate> certificatesByBoatIdAsString, AsyncCallback<Util.Triple<Integer, Integer, Integer>> callback) {
        sailingServiceWrite.assignORCPerformanceCurveCertificates(this.regattaIdentifier, certificatesByBoatIdAsString, callback);
    }

    protected void getORCCertificateAssignemtnsByBoatIdAsString(SailingServiceAsync sailingService, AsyncCallback<Map<String, ORCCertificate>> callbackForGetCertificates) {
        sailingService.getORCCertificateAssignmentsByBoatIdAsString(this.regattaIdentifier, callbackForGetCertificates);
    }

    protected void getBoats(SailingServiceAsync sailingService, AsyncCallback<Collection<BoatDTO>> callbackForGetBoats) {
        sailingService.getBoatRegistrationsForRegatta(this.regattaIdentifier, callbackForGetBoats);
    }
}

