/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.adminconsole.RaceColumnsInLeaderboardDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.List;

public class RaceColumnsInLeaderboardDialog
extends DataEntryDialog<List<RaceColumnDTO>> {
    private final ListBox addRacesListBox;
    private Button addRacesBtn;
    private final List<TextBox> raceNameEntryFields;
    private final List<CheckBox> isMedalRaceCheckboxes;
    private final StringMessages stringMessages;
    private final TextBox raceNamePrefixTextBox;
    private Grid raceColumnsGrid;
    private VerticalPanel additionalWidget;
    private List<RaceColumnDTO> existingRaces;

    public RaceColumnsInLeaderboardDialog(List<RaceColumnDTO> existingRaces, StringMessages stringMessages, DataEntryDialog.DialogCallback<List<RaceColumnDTO>> callback) {
        super(stringMessages.actionAddRaces(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new RaceDialogValidator(stringMessages), callback);
        this.existingRaces = existingRaces;
        this.stringMessages = stringMessages;
        this.addRacesListBox = this.createListBox(false);
        this.addRacesListBox.ensureDebugId("NumberOfRacesListBox");
        this.raceNamePrefixTextBox = this.createTextBox(null);
        this.raceNamePrefixTextBox.ensureDebugId("RaceNamePrefixTextBox");
        this.raceNameEntryFields = new ArrayList();
        this.isMedalRaceCheckboxes = new ArrayList();
        this.raceColumnsGrid = new Grid(0, 0);
    }

    private Widget createRaceNameWidget(String defaultName, boolean enabled) {
        TextBox textBox = this.createTextBox(defaultName);
        textBox.setVisibleLength(25);
        textBox.setEnabled(enabled);
        this.raceNameEntryFields.add(textBox);
        return textBox;
    }

    private Widget createMedalRaceWidget(boolean isMedalRace, boolean enabled) {
        CheckBox checkBox = this.createCheckbox(this.stringMessages.medalRace());
        checkBox.setEnabled(enabled);
        this.isMedalRaceCheckboxes.add(checkBox);
        return checkBox;
    }

    protected List<RaceColumnDTO> getResult() {
        ArrayList<RaceColumnDTO> racesWithFleet = new ArrayList<RaceColumnDTO>();
        int racesCount = this.raceNameEntryFields.size();
        int i = 0;
        while (i < racesCount) {
            String raceColumnName = ((TextBox)this.raceNameEntryFields.get(i)).getValue();
            RaceColumnDTO raceColumnDTO = new RaceColumnDTO(raceColumnName, false);
            raceColumnDTO.setMedalRace(((CheckBox)this.isMedalRaceCheckboxes.get(i)).getValue().booleanValue());
            racesWithFleet.add(raceColumnDTO);
            ++i;
        }
        return racesWithFleet;
    }

    protected Widget getAdditionalWidget() {
        this.additionalWidget = new VerticalPanel();
        this.raceNamePrefixTextBox.setText("R");
        HorizontalPanel addRacesPanel = new HorizontalPanel();
        addRacesPanel.setSpacing(5);
        addRacesPanel.add((Widget)new Label(this.stringMessages.add()));
        addRacesPanel.add((Widget)this.addRacesListBox);
        int i = 1;
        while (i <= 20) {
            this.addRacesListBox.addItem("" + i);
            ++i;
        }
        this.addRacesListBox.setSelectedIndex(0);
        addRacesPanel.add((Widget)new Label(String.valueOf(this.stringMessages.racesWithNamePrefix()) + " "));
        this.raceNamePrefixTextBox.setWidth("20px");
        addRacesPanel.add((Widget)this.raceNamePrefixTextBox);
        this.addRacesBtn = new Button(this.stringMessages.add());
        this.addRacesBtn.ensureDebugId("AddRacesButton");
        this.addRacesBtn.addStyleName("inlineButton");
        this.addRacesBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        addRacesPanel.add((Widget)this.addRacesBtn);
        this.additionalWidget.add((Widget)addRacesPanel);
        this.alignAllPanelWidgetsVertically(addRacesPanel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.additionalWidget.add((Widget)this.createHeadlineLabel(this.stringMessages.races()));
        this.additionalWidget.add((Widget)this.raceColumnsGrid);
        for (RaceColumnDTO raceColumn : this.existingRaces) {
            this.createRaceNameWidget(raceColumn.getRaceColumnName(), false);
            this.createMedalRaceWidget(raceColumn.isMedalRace(), false);
        }
        this.updateRaceColumnsGrid(this.additionalWidget);
        return this.additionalWidget;
    }

    private void updateRaceColumnsGrid(VerticalPanel parentPanel) {
        int widgetIndex = parentPanel.getWidgetIndex((Widget)this.raceColumnsGrid);
        parentPanel.remove((Widget)this.raceColumnsGrid);
        int raceNamesCount = this.raceNameEntryFields.size();
        if (raceNamesCount > 0) {
            this.raceColumnsGrid = new Grid(raceNamesCount, 3);
            this.raceColumnsGrid.setCellSpacing(4);
            int i = 0;
            while (i < raceNamesCount) {
                this.raceColumnsGrid.setWidget(i, 0, (Widget)this.raceNameEntryFields.get(i));
                this.raceColumnsGrid.setWidget(i, 1, (Widget)this.isMedalRaceCheckboxes.get(i));
                ++i;
            }
        } else {
            this.raceColumnsGrid = new Grid(0, 0);
        }
        parentPanel.insert((Widget)this.raceColumnsGrid, widgetIndex);
    }

    static /* synthetic */ TextBox access$1(RaceColumnsInLeaderboardDialog raceColumnsInLeaderboardDialog) {
        return raceColumnsInLeaderboardDialog.raceNamePrefixTextBox;
    }

    static /* synthetic */ ListBox access$2(RaceColumnsInLeaderboardDialog raceColumnsInLeaderboardDialog) {
        return raceColumnsInLeaderboardDialog.addRacesListBox;
    }

    static /* synthetic */ List access$3(RaceColumnsInLeaderboardDialog raceColumnsInLeaderboardDialog) {
        return raceColumnsInLeaderboardDialog.raceNameEntryFields;
    }

    static /* synthetic */ List access$4(RaceColumnsInLeaderboardDialog raceColumnsInLeaderboardDialog) {
        return raceColumnsInLeaderboardDialog.existingRaces;
    }

    static /* synthetic */ Widget access$5(RaceColumnsInLeaderboardDialog raceColumnsInLeaderboardDialog, String string, boolean bl) {
        return raceColumnsInLeaderboardDialog.createRaceNameWidget(string, bl);
    }

    static /* synthetic */ Widget access$6(RaceColumnsInLeaderboardDialog raceColumnsInLeaderboardDialog, boolean bl, boolean bl2) {
        return raceColumnsInLeaderboardDialog.createMedalRaceWidget(bl, bl2);
    }

    static /* synthetic */ VerticalPanel access$7(RaceColumnsInLeaderboardDialog raceColumnsInLeaderboardDialog) {
        return raceColumnsInLeaderboardDialog.additionalWidget;
    }

    static /* synthetic */ void access$8(RaceColumnsInLeaderboardDialog raceColumnsInLeaderboardDialog, VerticalPanel verticalPanel) {
        raceColumnsInLeaderboardDialog.updateRaceColumnsGrid(verticalPanel);
    }
}

