/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.PairingListTemplateDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractPairingListCreationSetupDialog;
import com.sap.sailing.gwt.ui.adminconsole.PairingListCreationSetupDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public class PairingListCreationSetupDialog
extends AbstractPairingListCreationSetupDialog<PairingListTemplateDTO> {
    private final IntegerBox competitorCountTextBox;
    private final IntegerBox flightMultiplierTextBox;
    private final CheckBox flightMultiplierCheckBox;
    private Iterable<CheckBox> selectedSeriesCheckboxes;
    private ListBox boatChangeFactorListBox;

    public PairingListCreationSetupDialog(StrippedLeaderboardDTO leaderboardDTO, StringMessages stringMessages, DataEntryDialog.DialogCallback<PairingListTemplateDTO> callback) {
        super(leaderboardDTO, stringMessages.pairingList(), stringMessages, (DataEntryDialog.Validator)new PairingListParameterValidator(stringMessages), callback);
        this.competitorCountTextBox = this.createIntegerBox(Integer.valueOf(leaderboardDTO.competitorsCount), 2);
        this.competitorCountTextBox.ensureDebugId("CompetitorCountBox");
        this.flightMultiplierTextBox = this.createIntegerBox(Integer.valueOf(1), 2);
        this.flightMultiplierTextBox.setEnabled(false);
        this.flightMultiplierTextBox.ensureDebugId("FlightMultiplierIntegerBox");
        this.flightMultiplierCheckBox = this.createCheckbox(this.stringMessages.amountOfFlightRepeats());
        this.flightMultiplierCheckBox.setTitle(this.stringMessages.multiplierInfo());
        this.flightMultiplierCheckBox.ensureDebugId("FlightMultiplierCheckBox");
        this.ensureDebugId("PairingListCreationSetupDialog");
        this.boatChangeFactorListBox = new ListBox();
        this.boatChangeFactorListBox.setVisibleItemCount(1);
        this.flightMultiplierCheckBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<CheckBox> checkboxes = new ArrayList<CheckBox>();
        for (String seriesName : this.getSeriesNamesFromAllRaces((Iterable)leaderboardDTO.getRaceList())) {
            CheckBox current = this.createCheckbox(seriesName);
            current.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            current.ensureDebugId("SelectedFlightsCheckbox: " + seriesName);
            checkboxes.add(current);
        }
        this.selectedSeriesCheckboxes = checkboxes;
        ((CheckBox)Util.get((Iterable)this.selectedSeriesCheckboxes, (int)0)).setValue(Boolean.valueOf(true));
        this.validateCheckboxes(true);
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        CaptionPanel infoPanel = new CaptionPanel();
        infoPanel.setCaptionText("Info");
        panel.add((Widget)infoPanel);
        ScrollPanel infoScrollPanel = new ScrollPanel();
        infoScrollPanel.setPixelSize(Window.getClientWidth() / 3, 150);
        infoScrollPanel.add((Widget)new Label(this.stringMessages.pairingListCreationInfo()));
        infoPanel.add((Widget)infoScrollPanel);
        Grid formGrid = new Grid(Util.size((Iterable)this.selectedSeriesCheckboxes) + 3, 2);
        panel.add((Widget)formGrid);
        formGrid.setWidget(0, 0, (Widget)new Label(this.stringMessages.setCompetitors()));
        formGrid.setWidget(0, 1, (Widget)this.competitorCountTextBox);
        formGrid.setWidget(1, 0, (Widget)this.flightMultiplierCheckBox);
        formGrid.setWidget(1, 1, (Widget)this.flightMultiplierTextBox);
        formGrid.setWidget(2, 0, (Widget)new Label(this.stringMessages.setBoatChangeFactor()));
        formGrid.setWidget(2, 1, (Widget)this.boatChangeFactorListBox);
        formGrid.setWidget(3, 0, (Widget)new Label(this.stringMessages.seriesHint()));
        int count = 0;
        for (CheckBox current : this.selectedSeriesCheckboxes) {
            formGrid.setWidget(3 + count, 1, (Widget)current);
            ++count;
        }
        return panel;
    }

    protected PairingListTemplateDTO getResult() {
        PairingListTemplateDTO dto = new PairingListTemplateDTO(((Integer)this.competitorCountTextBox.getValue()).intValue(), ((Integer)this.flightMultiplierTextBox.getValue()).intValue(), this.boatChangeFactorListBox.getSelectedIndex());
        if (Util.size((Iterable)this.getCheckedSelectedCheckBoxes()) > 0) {
            String seriesName = ((CheckBox)Util.get((Iterable)this.getCheckedSelectedCheckBoxes(), (int)0)).getText();
            dto.setGroupCount(this.getOneRaceFromSeriesName(seriesName, (Iterable)this.leaderboardDTO.getRaceList()).getFleets().size());
        } else {
            dto.setGroupCount(0);
        }
        if (this.flightMultiplierCheckBox.getValue().booleanValue()) {
            dto.setFlightMultiplier(((Integer)this.flightMultiplierTextBox.getValue()).intValue());
        } else {
            dto.setFlightMultiplier(1);
        }
        List selectedFlightNames = this.getSelectedFlightNames();
        dto.setSelectedFlightNames(selectedFlightNames);
        dto.setFlightCount(selectedFlightNames.size());
        dto.setTolerance(Integer.parseInt(this.boatChangeFactorListBox.getSelectedValue()));
        return dto;
    }

    private List<String> getSelectedFlightNames() {
        ArrayList<String> selectedFlightNames = new ArrayList<String>();
        for (CheckBox box : this.getCheckedSelectedCheckBoxes()) {
            selectedFlightNames.addAll(this.getRaceColumnNamesFromSeriesName(box.getText(), (Iterable)this.leaderboardDTO.getRaceList()));
        }
        return selectedFlightNames;
    }

    public void setDefaultCompetitorCount(int competitorCount) {
        if ((Integer)this.competitorCountTextBox.getValue() == 0) {
            this.competitorCountTextBox.setValue((Object)competitorCount);
            this.validateAndUpdate();
        }
    }

    private void validateCheckboxes(boolean enabled) {
        if (enabled) {
            this.disableSelectedSeriesCheckBoxes(this.leaderboardDTO);
            if (this.flightMultiplierCheckBox.getValue().booleanValue()) {
                if (Util.size((Iterable)this.getCheckedSelectedCheckBoxes()) > 0) {
                    this.enableOrDisableAllSelectedSeriesCheckBoxes(false, true);
                }
            } else if (Util.size((Iterable)this.getCheckedSelectedCheckBoxes()) > 1) {
                this.flightMultiplierCheckBox.setEnabled(false);
            } else {
                this.flightMultiplierCheckBox.setEnabled(true);
            }
        } else {
            if (Util.size((Iterable)this.getCheckedSelectedCheckBoxes()) <= 0) {
                this.enableOrDisableAllSelectedSeriesCheckBoxes(true, false);
            }
            if (Util.size((Iterable)this.getCheckedSelectedCheckBoxes()) < 2) {
                this.flightMultiplierCheckBox.setEnabled(true);
            }
        }
        this.updateBoatChangeFactorSelection(this.getSelectedFlightNames().size());
    }

    private Iterable<String> getSeriesNamesFromAllRaces(Iterable<RaceColumnDTO> raceColumns) {
        ArrayList<String> result = new ArrayList<String>();
        for (RaceColumnDTO raceColumn : raceColumns) {
            if (raceColumn.isMedalRace() || result.contains(raceColumn.getSeriesName())) continue;
            result.add(raceColumn.getSeriesName());
        }
        return result;
    }

    private RaceColumnDTO getOneRaceFromSeriesName(String seriesName, Iterable<RaceColumnDTO> raceColumns) {
        for (RaceColumnDTO raceColumn : raceColumns) {
            if (raceColumn.isMedalRace() || !seriesName.equals(raceColumn.getSeriesName())) continue;
            return raceColumn;
        }
        return null;
    }

    private List<String> getRaceColumnNamesFromSeriesName(String seriesName, Iterable<RaceColumnDTO> raceColumns) {
        ArrayList<String> result = new ArrayList<String>();
        for (RaceColumnDTO raceColumn : raceColumns) {
            if (raceColumn.isMedalRace() || !seriesName.equals(raceColumn.getSeriesName())) continue;
            result.add(raceColumn.getName());
        }
        return result;
    }

    public Iterable<CheckBox> getCheckedSelectedCheckBoxes() {
        ArrayList<CheckBox> result = new ArrayList<CheckBox>();
        for (CheckBox box : this.selectedSeriesCheckboxes) {
            if (!box.getValue().booleanValue()) continue;
            result.add(box);
        }
        return result;
    }

    private void disableSelectedSeriesCheckBoxes(StrippedLeaderboardDTO leaderboardDTO) {
        Iterable boxes = this.getCheckedSelectedCheckBoxes();
        if (Util.size((Iterable)boxes) <= 1) {
            RaceColumnDTO race = this.getOneRaceFromSeriesName(((CheckBox)Util.get((Iterable)boxes, (int)0)).getText(), (Iterable)leaderboardDTO.getRaceList());
            for (CheckBox box : this.selectedSeriesCheckboxes) {
                if (race.getFleets().size() == this.getOneRaceFromSeriesName(box.getText(), (Iterable)leaderboardDTO.getRaceList()).getFleets().size()) continue;
                box.setEnabled(false);
            }
        }
    }

    private void enableOrDisableAllSelectedSeriesCheckBoxes(boolean enabled, boolean exclusiveSelected) {
        if (exclusiveSelected) {
            for (CheckBox box : this.selectedSeriesCheckboxes) {
                if (box.getValue().booleanValue()) continue;
                box.setEnabled(enabled);
            }
        } else {
            if (Util.size((Iterable)this.getCheckedSelectedCheckBoxes()) > 0) {
                return;
            }
            for (CheckBox box : this.selectedSeriesCheckboxes) {
                box.setEnabled(enabled);
            }
        }
    }

    private void updateBoatChangeFactorSelection(int flightCount) {
        this.boatChangeFactorListBox.clear();
        if (flightCount == 0) {
            this.boatChangeFactorListBox.addItem("0");
        } else {
            IntStream.range(0, flightCount + 1).forEach(i -> this.boatChangeFactorListBox.addItem(String.valueOf(i)));
        }
    }

    static /* synthetic */ IntegerBox access$1(PairingListCreationSetupDialog pairingListCreationSetupDialog) {
        return pairingListCreationSetupDialog.flightMultiplierTextBox;
    }

    static /* synthetic */ void access$2(PairingListCreationSetupDialog pairingListCreationSetupDialog, boolean bl, boolean bl2) {
        pairingListCreationSetupDialog.enableOrDisableAllSelectedSeriesCheckBoxes(bl, bl2);
    }

    static /* synthetic */ void access$3(PairingListCreationSetupDialog pairingListCreationSetupDialog, boolean bl) {
        pairingListCreationSetupDialog.validateCheckboxes(bl);
    }
}

