/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.MigrateGroupOwnershipDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.MigrateGroupOwnerForHierarchyDTO;
import com.sap.sse.common.Named;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedUserGroupDTO;
import com.sap.sse.security.shared.dto.UserGroupDTO;
import com.sap.sse.security.ui.client.UserManagementServiceAsync;
import java.util.function.BiConsumer;

public class MigrateGroupOwnershipDialog
extends DataEntryDialog<MigrateGroupOwnerForHierarchyDialogDTO> {
    private final StringMessages stringMessages;
    private final UserManagementServiceAsync userManagementService;
    private final Label currentGroupLabel;
    private final TextBox groupnameBox;
    private boolean resolvingUserGroupName;
    private UserGroupDTO resolvedUserGroup;
    private final RadioButton toExistingGroup;
    private final RadioButton toNewGroup;
    private final CheckBox migrateCompetitors;
    private final CheckBox migrateBoats;
    private final CheckBox copyMembersAndRoles;
    private final Label lblCopyMembersAndRoles;
    private UserGroupDTO oldUserGroup;

    private MigrateGroupOwnershipDialog(UserManagementServiceAsync userManagementService, StrippedUserGroupDTO tenant, StringMessages stringMessages, DataEntryDialog.DialogCallback<MigrateGroupOwnerForHierarchyDialogDTO> callback) {
        super(stringMessages.ownership(), stringMessages.migrateHierarchyToGroupOwner(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new Validator(stringMessages), callback);
        this.userManagementService = userManagementService;
        this.currentGroupLabel = new Label(tenant == null ? "n/a" : tenant.getName());
        this.groupnameBox = this.createTextBox(tenant == null ? "" : tenant.getName(), 20);
        this.groupnameBox.addChangeHandler(e -> this.resolveUserGroup());
        String radioGroupName = "mode";
        this.toExistingGroup = this.createRadioButton("mode", stringMessages.useExistingUserGroup());
        this.toNewGroup = this.createRadioButton("mode", stringMessages.useNewUserGroup());
        this.toExistingGroup.setValue(Boolean.valueOf(true));
        this.copyMembersAndRoles = this.createCheckbox("");
        this.copyMembersAndRoles.setVisible(false);
        this.copyMembersAndRoles.setValue(Boolean.valueOf(true));
        this.toNewGroup.addValueChangeHandler(v -> this.onRadioChange());
        this.toExistingGroup.addValueChangeHandler(v -> this.onRadioChange());
        this.migrateCompetitors = this.createCheckbox("");
        this.migrateBoats = this.createCheckbox("");
        this.stringMessages = stringMessages;
        this.resolveUserGroup();
        this.lblCopyMembersAndRoles = new Label(stringMessages.copyMembersAndRoles());
        this.lblCopyMembersAndRoles.setVisible(false);
        if (tenant != null) {
            userManagementService.getUserGroupByName(tenant.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void onRadioChange() {
        this.copyMembersAndRoles.setVisible(this.toNewGroup.getValue().booleanValue());
        this.lblCopyMembersAndRoles.setVisible(this.toNewGroup.getValue().booleanValue());
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(6, 2);
        result.setWidget(0, 0, (Widget)new Label(this.stringMessages.currentGroupOwner()));
        result.setWidget(0, 1, (Widget)this.currentGroupLabel);
        result.setWidget(1, 0, (Widget)this.toExistingGroup);
        result.setWidget(1, 1, (Widget)this.toNewGroup);
        result.setWidget(2, 0, (Widget)new Label(this.stringMessages.group()));
        result.setWidget(2, 1, (Widget)this.groupnameBox);
        result.setWidget(3, 0, (Widget)new Label(this.stringMessages.migrateCompetitors()));
        result.setWidget(3, 1, (Widget)this.migrateCompetitors);
        result.setWidget(4, 0, (Widget)new Label(this.stringMessages.migrateBoats()));
        result.setWidget(4, 1, (Widget)this.migrateBoats);
        result.setWidget(5, 0, (Widget)this.lblCopyMembersAndRoles);
        result.setWidget(5, 1, (Widget)this.copyMembersAndRoles);
        return result;
    }

    private void resolveUserGroup() {
        this.resolvedUserGroup = null;
        this.resolvingUserGroupName = true;
        this.userManagementService.getUserGroupByName(this.groupnameBox.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected MigrateGroupOwnerForHierarchyDialogDTO getResult() {
        boolean newGroup = this.toNewGroup.getValue();
        return new MigrateGroupOwnerForHierarchyDialogDTO(newGroup ? this.oldUserGroup : this.resolvedUserGroup, newGroup ? false : this.resolvingUserGroupName, newGroup, this.groupnameBox.getValue().trim(), this.migrateCompetitors.getValue().booleanValue(), this.migrateBoats.getValue().booleanValue(), this.copyMembersAndRoles.getValue().booleanValue());
    }

    public static <T extends Named & SecuredDTO> DialogConfig<T> create(UserManagementServiceAsync userManagementService, BiConsumer<T, MigrateGroupOwnerForHierarchyDTO> updateCallback) {
        return new DialogConfig(userManagementService, updateCallback, null);
    }

    /* synthetic */ MigrateGroupOwnershipDialog(UserManagementServiceAsync userManagementServiceAsync, StrippedUserGroupDTO strippedUserGroupDTO, StringMessages stringMessages, DataEntryDialog.DialogCallback dialogCallback, MigrateGroupOwnershipDialog migrateGroupOwnershipDialog) {
        this(userManagementServiceAsync, strippedUserGroupDTO, stringMessages, dialogCallback);
    }

    static /* synthetic */ void access$2(MigrateGroupOwnershipDialog migrateGroupOwnershipDialog, UserGroupDTO userGroupDTO) {
        migrateGroupOwnershipDialog.oldUserGroup = userGroupDTO;
    }

    static /* synthetic */ void access$3(MigrateGroupOwnershipDialog migrateGroupOwnershipDialog, UserGroupDTO userGroupDTO) {
        migrateGroupOwnershipDialog.resolvedUserGroup = userGroupDTO;
    }

    static /* synthetic */ void access$4(MigrateGroupOwnershipDialog migrateGroupOwnershipDialog, boolean bl) {
        migrateGroupOwnershipDialog.resolvingUserGroupName = bl;
    }

    static /* synthetic */ void access$5(MigrateGroupOwnershipDialog migrateGroupOwnershipDialog) {
        migrateGroupOwnershipDialog.validateAndUpdate();
    }

    static /* synthetic */ StringMessages access$6(MigrateGroupOwnershipDialog migrateGroupOwnershipDialog) {
        return migrateGroupOwnershipDialog.stringMessages;
    }
}

