/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AssignRacesToMediaDialog;
import com.sap.sailing.gwt.ui.adminconsole.FileStorageServiceConnectionTestObservable;
import com.sap.sailing.gwt.ui.adminconsole.MediaPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.MediaServiceAsync;
import com.sap.sailing.gwt.ui.client.MediaServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.NewMediaWithRaceSelectionDialog;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class MediaPanel
extends FlowPanel
implements FilterablePanelProvider<MediaTrackWithSecurityDTO> {
    private static AdminConsoleTableResources tableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final LabeledAbstractFilterablePanel<MediaTrackWithSecurityDTO> filterableMediaTracks;
    private List<MediaTrackWithSecurityDTO> allMediaTracks;
    private final AdminConsoleView.Presenter presenter;
    private final MediaServiceWriteAsync mediaServiceWrite;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final UserService userService;
    private CellTable<MediaTrackWithSecurityDTO> mediaTracksTable;
    private ListDataProvider<MediaTrackWithSecurityDTO> mediaTrackListDataProvider = new ListDataProvider();
    private Date latestDate;
    private RefreshableMultiSelectionModel<MediaTrackWithSecurityDTO> refreshableSelectionModel;
    private final FileStorageServiceConnectionTestObservable storageServiceAvailable;
    private final Displayer<MediaTrackWithSecurityDTO> mediaTracksDisplayer = new /* Unavailable Anonymous Inner Class!! */;

    public MediaPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.userService = presenter.getUserService();
        this.presenter = presenter;
        this.mediaServiceWrite = presenter.getMediaServiceWrite();
        this.stringMessages = stringMessages;
        this.errorReporter = presenter.getErrorReporter();
        this.storageServiceAvailable = new FileStorageServiceConnectionTestObservable(presenter.getSailingService());
        AccessControlledButtonPanel buttonAndFilterPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.MEDIA_TRACK);
        this.add((Widget)buttonAndFilterPanel);
        this.allMediaTracks = new ArrayList();
        buttonAndFilterPanel.addUnsecuredAction(stringMessages.refresh(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        buttonAndFilterPanel.addCreateAction(stringMessages.addMediaTrack(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        buttonAndFilterPanel.addCreateAction(stringMessages.multiVideoLinking(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        Button multiURLChange = buttonAndFilterPanel.addUnsecuredAction(stringMessages.multiUrlChangeMediaTrack(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        multiURLChange.setEnabled(false);
        Label lblFilterRaces = new Label(String.valueOf(stringMessages.filterMediaByName()) + ":");
        lblFilterRaces.setWordWrap(false);
        buttonAndFilterPanel.addUnsecuredWidget((Widget)lblFilterRaces);
        this.filterableMediaTracks = new /* Unavailable Anonymous Inner Class!! */;
        this.createMediaTracksTable(this.userService);
        this.filterableMediaTracks.getTextBox().ensureDebugId("MediaTracksFilterTextBox");
        this.filterableMediaTracks.setUpdatePermissionFilterForCheckbox(mediaTrack -> this.userService.hasPermission((SecuredDTO)mediaTrack, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        buttonAndFilterPanel.addUnsecuredWidget((Widget)this.filterableMediaTracks);
        this.refreshableSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Displayer<MediaTrackWithSecurityDTO> getMediaTracksDisplayer() {
        return this.mediaTracksDisplayer;
    }

    public void fillMediaTracks(Iterable<MediaTrackWithSecurityDTO> allMediaTracks) {
        this.mediaTrackListDataProvider.getList().clear();
        Util.addAll(allMediaTracks, (Collection)this.mediaTrackListDataProvider.getList());
        this.filterableMediaTracks.updateAll((Iterable)this.mediaTrackListDataProvider.getList());
        this.mediaTrackListDataProvider.refresh();
    }

    private void createMediaTracksTable(UserService userService) {
        this.mediaTracksTable = new BaseCelltable(1000, (CellTable.Resources)tableResources);
        this.mediaTracksTable.setWidth("100%");
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.mediaTrackListDataProvider.getList());
        this.mediaTracksTable.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        this.refreshableSelectionModel = new RefreshableMultiSelectionModel((EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.filterableMediaTracks.getAllListDataProvider());
        this.mediaTracksTable.setSelectionModel((SelectionModel)this.refreshableSelectionModel, (CellPreviewEvent.Handler)DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new /* Unavailable Anonymous Inner Class!! */));
        this.initTableColumns(sortHandler, userService);
        this.mediaTrackListDataProvider.addDataDisplay((HasData)this.mediaTracksTable);
        this.add((Widget)this.mediaTracksTable);
        this.allMediaTracks.clear();
        this.allMediaTracks.addAll(this.mediaTrackListDataProvider.getList());
    }

    private void initTableColumns(ColumnSortEvent.ListHandler<MediaTrackWithSecurityDTO> sortHandler, UserService userService) {
        10 checkColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.mediaTracksTable.addColumn((Column)checkColumn, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        this.mediaTracksTable.setColumnWidth((Column)checkColumn, 40.0, Style.Unit.PX);
        11 dbIdColumn = new /* Unavailable Anonymous Inner Class!! */;
        dbIdColumn.setSortable(true);
        sortHandler.setComparator((Column)dbIdColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.addColumn((Column)dbIdColumn, this.stringMessages.id());
        this.mediaTracksTable.setColumnWidth((Column)dbIdColumn, 10.0, Style.Unit.PCT);
        13 titleColumn = new /* Unavailable Anonymous Inner Class!! */;
        titleColumn.setSortable(true);
        sortHandler.setComparator((Column)titleColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.addColumn((Column)titleColumn, this.stringMessages.title());
        titleColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.setColumnWidth((Column)titleColumn, 20.0, Style.Unit.PCT);
        16 urlColumn = new /* Unavailable Anonymous Inner Class!! */;
        urlColumn.setSortable(true);
        sortHandler.setComparator((Column)urlColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.addColumn((Column)urlColumn, this.stringMessages.url());
        urlColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.setColumnWidth((Column)urlColumn, 100.0, Style.Unit.PCT);
        20 assignedRacesColumn = new /* Unavailable Anonymous Inner Class!! */;
        assignedRacesColumn.setSortable(true);
        sortHandler.setComparator((Column)assignedRacesColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.addColumn((Column)assignedRacesColumn, this.stringMessages.linkedRaces());
        assignedRacesColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.setColumnWidth((Column)assignedRacesColumn, 100.0, Style.Unit.PCT);
        23 startTimeColumn = new /* Unavailable Anonymous Inner Class!! */;
        startTimeColumn.setSortable(true);
        sortHandler.setComparator((Column)startTimeColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        startTimeColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.addColumn((Column)startTimeColumn, this.stringMessages.startTime());
        this.mediaTracksTable.setColumnWidth((Column)startTimeColumn, 100.0, Style.Unit.PCT);
        26 durationColumn = new /* Unavailable Anonymous Inner Class!! */;
        durationColumn.setSortable(true);
        sortHandler.setComparator((Column)durationColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        durationColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.mediaTracksTable.addColumn((Column)durationColumn, this.stringMessages.duration());
        this.mediaTracksTable.setColumnWidth((Column)durationColumn, 100.0, Style.Unit.PCT);
        29 mimeTypeColumn = new /* Unavailable Anonymous Inner Class!! */;
        mimeTypeColumn.setSortable(true);
        this.mediaTracksTable.addColumn((Column)mimeTypeColumn, this.stringMessages.mimeType());
        this.mediaTracksTable.setColumnWidth((Column)mimeTypeColumn, 100.0, Style.Unit.PCT);
        sortHandler.setComparator((Column)mimeTypeColumn, (mt1, mt2) -> (mt1.mimeType == null ? "" : mt1.mimeType.toString()).compareTo(mt2.mimeType == null ? "" : mt2.mimeType.toString()));
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.mediaTracksTable, sortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        HasPermissions type = SecuredDomainType.MEDIA_TRACK;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell((com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages), (UserService)userService);
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, mediaTrack -> {
            if (Window.confirm((String)this.stringMessages.reallyRemoveMediaTrack(mediaTrack.title))) {
                this.removeMediaTrack((MediaTrack)mediaTrack);
            }
        });
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, mediaTrack -> this.mediaTrackListDataProvider.refresh(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, mediaTrack -> {
            AccessControlListDTO accessControlListDTO = mediaTrack.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, mediaTrack -> configACL.openDialog((SecuredDTO)mediaTrack));
        this.mediaTracksTable.addColumn((Column)actionsColumn, this.stringMessages.actions());
    }

    protected void removeMediaTrack(MediaTrack mediaTrack) {
        this.mediaServiceWrite.deleteMediaTrack(mediaTrack, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addUrlMediaTrack() {
        NewMediaWithRaceSelectionDialog dialog = new NewMediaWithRaceSelectionDialog((MediaServiceAsync)this.mediaServiceWrite, this.getDefaultStartTime(), this.stringMessages, this.presenter, this.storageServiceAvailable, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    private TimePoint getDefaultStartTime() {
        if (this.getLatestDate() != null) {
            return new MillisecondsTimePoint(this.latestDate);
        }
        return MillisecondsTimePoint.now();
    }

    private Date getLatestDate() {
        this.sailingServiceWrite.getRegattas((AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        return this.latestDate;
    }

    private String listAssignedRaces(MediaTrackWithSecurityDTO mediaTrack) {
        String result;
        if (mediaTrack.assignedRaces.size() > 1) {
            result = String.valueOf(mediaTrack.assignedRaces.size());
        } else {
            String value = "";
            for (RegattaAndRaceIdentifier assignedRace : mediaTrack.assignedRaces) {
                value = String.valueOf(value) + assignedRace.getRegattaName() + " " + assignedRace.getRaceName() + ", ";
            }
            result = value.length() > 1 ? value.substring(0, value.length() - 2) : value;
        }
        return result;
    }

    public void onShow() {
        this.presenter.getMediaTracksRefresher().callFillAndReloadInitially(this.getMediaTracksDisplayer());
    }

    public void openAssignedRacesDialog(Cell.Context context, Element parent, ValueUpdater<String> valueUpdater) {
        MediaTrackWithSecurityDTO mediaTrack = (MediaTrackWithSecurityDTO)context.getKey();
        AssignRacesToMediaDialog dialog = new AssignRacesToMediaDialog(this.presenter, (MediaTrack)mediaTrack, this.stringMessages, null, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.presenter.getRegattasRefresher().addDisplayerAndCallFillOnInit(dialog.getRegattasDisplayer());
        dialog.ensureDebugId("AssignedRacesDialog");
        dialog.show();
    }

    public AbstractFilterablePanel<MediaTrackWithSecurityDTO> getFilterablePanel() {
        return this.filterableMediaTracks;
    }

    static /* synthetic */ void access$0(MediaPanel mediaPanel) {
        mediaPanel.addUrlMediaTrack();
    }

    static /* synthetic */ SailingServiceWriteAsync access$1(MediaPanel mediaPanel) {
        return mediaPanel.sailingServiceWrite;
    }

    static /* synthetic */ MediaServiceWriteAsync access$2(MediaPanel mediaPanel) {
        return mediaPanel.mediaServiceWrite;
    }

    static /* synthetic */ ErrorReporter access$3(MediaPanel mediaPanel) {
        return mediaPanel.errorReporter;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$4(MediaPanel mediaPanel) {
        return mediaPanel.refreshableSelectionModel;
    }

    static /* synthetic */ CellTable access$5(MediaPanel mediaPanel) {
        return mediaPanel.mediaTracksTable;
    }

    static /* synthetic */ UserService access$6(MediaPanel mediaPanel) {
        return mediaPanel.userService;
    }

    static /* synthetic */ ListDataProvider access$7(MediaPanel mediaPanel) {
        return mediaPanel.mediaTrackListDataProvider;
    }

    static /* synthetic */ String access$8(MediaPanel mediaPanel, MediaTrackWithSecurityDTO mediaTrackWithSecurityDTO) {
        return mediaPanel.listAssignedRaces(mediaTrackWithSecurityDTO);
    }

    static /* synthetic */ StringMessages access$9(MediaPanel mediaPanel) {
        return mediaPanel.stringMessages;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$10(MediaPanel mediaPanel) {
        return mediaPanel.presenter;
    }

    static /* synthetic */ void access$11(MediaPanel mediaPanel, Date date) {
        mediaPanel.latestDate = date;
    }
}

