/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.racemap.Pattern;
import com.sap.sailing.gwt.ui.shared.racemap.Shape;
import com.sap.sse.common.impl.AbstractColor;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collections;

public class MarkEditDialog
extends DataEntryDialog<MarkDTO> {
    private final MarkDTO markToEdit;
    private final TextBox name;
    private final TextBox shortName;
    private final ListBox shape;
    private final ListBox pattern;
    private final ListBox type;
    private final TextBox color;
    private final TextBox colorSample;
    private final StringMessages stringMessages;

    public MarkEditDialog(StringMessages stringMessages, MarkDTO markToEdit, boolean isNewMark, DataEntryDialog.DialogCallback<MarkDTO> callback) {
        this(stringMessages, markToEdit, isNewMark, new TextBox[1], callback);
    }

    private MarkEditDialog(StringMessages stringMessages, MarkDTO markToEdit, boolean isNewMark, TextBox[] color, DataEntryDialog.DialogCallback<MarkDTO> callback) {
        super(isNewMark ? stringMessages.add(stringMessages.mark()) : stringMessages.edit(stringMessages.mark()), isNewMark ? stringMessages.add(stringMessages.mark()) : stringMessages.edit(stringMessages.mark()), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, callback);
        this.stringMessages = stringMessages;
        this.markToEdit = markToEdit;
        this.name = this.createTextBox(markToEdit.getName());
        this.shortName = this.createTextBox(markToEdit.getShortName());
        this.shape = this.createAndSelectListBox((Enum[])Shape.values(), markToEdit.shape, true);
        this.type = this.createAndSelectListBox((Enum[])MarkType.values(), markToEdit.type == null ? null : markToEdit.type.name(), false);
        color[0] = this.createTextBox(markToEdit.color == null ? null : markToEdit.color.getAsHtml());
        this.colorSample = new TextBox();
        this.colorSample.setVisibleLength(3);
        this.colorSample.setEnabled(false);
        this.color = color[0];
        this.pattern = this.createAndSelectListBox((Enum[])Pattern.values(), markToEdit.pattern, true);
    }

    private <T extends Enum<T>> ListBox createAndSelectListBox(T[] values, String toSelect, boolean emptySelectionPossible) {
        ListBox result = this.createListBox(false);
        int i = 0;
        ArrayList<String> list = new ArrayList<String>();
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            list.add(((Enum)t).name());
            ++n2;
        }
        if (emptySelectionPossible) {
            list.add("");
        }
        Collections.sort(list);
        for (String name : list) {
            result.addItem(name);
            if (name.equals(toSelect)) {
                result.setSelectedIndex(i);
            }
            ++i;
        }
        return result;
    }

    protected Focusable getInitialFocusWidget() {
        return this.name;
    }

    protected MarkDTO getResult() {
        MarkDTO result = new MarkDTO(this.markToEdit.getIdAsString(), this.name.getText(), this.shortName.getText());
        result.shape = this.shape.getItemText(this.shape.getSelectedIndex());
        result.type = MarkType.valueOf((String)this.type.getItemText(this.type.getSelectedIndex()));
        result.color = AbstractColor.getCssColor((String)this.color.getText());
        if (result.color == null) {
            this.colorSample.getElement().removeAttribute("style");
        } else {
            this.colorSample.getElement().setAttribute("style", "background-color:" + result.color.getAsHtml());
        }
        result.pattern = this.pattern.getItemText(this.pattern.getSelectedIndex());
        return result;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(7, 4);
        result.setWidget(0, 0, (Widget)new Label(this.stringMessages.name()));
        result.setWidget(0, 1, (Widget)this.name);
        result.setWidget(1, 0, (Widget)new Label(this.stringMessages.shortName()));
        result.setWidget(1, 1, (Widget)this.shortName);
        result.setWidget(2, 0, (Widget)new Label(this.stringMessages.shape()));
        result.setWidget(2, 1, (Widget)this.shape);
        result.setWidget(3, 0, (Widget)new Label(this.stringMessages.type()));
        result.setWidget(3, 1, (Widget)this.type);
        result.setWidget(4, 0, (Widget)new Label(this.stringMessages.color()));
        result.setWidget(4, 1, (Widget)this.color);
        result.setWidget(5, 2, (Widget)new Label(this.stringMessages.sampleColor()));
        result.setWidget(5, 3, (Widget)this.colorSample);
        result.setWidget(6, 0, (Widget)new Label(this.stringMessages.pattern()));
        result.setWidget(6, 1, (Widget)this.pattern);
        return result;
    }
}

