/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import java.util.NavigableMap;
import java.util.TreeMap;

public class FreestyleCommandDialog
extends DataEntryDialog<Void> {
    private final TextBox commandTextBox;
    private final TextArea logOutputArea;
    private final StringMessages stringMessages;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final String deviceSerialNumber;
    private final SimpleBusyIndicator sendBusyIndicator;
    private final SimpleBusyIndicator fetchLogBusyIndicator;
    private final NavigableMap<TimePoint, String> logEntries;

    public FreestyleCommandDialog(StringMessages stringMessages, SailingServiceWriteAsync sailingServiceWrite, String deviceSerialNumber) {
        super(stringMessages.sendCommandsTo(deviceSerialNumber), stringMessages.sendCommandsToDescription(deviceSerialNumber), StringMessages.INSTANCE.close(), null, null, true, null);
        this.stringMessages = stringMessages;
        this.sailingServiceWrite = sailingServiceWrite;
        this.deviceSerialNumber = deviceSerialNumber;
        this.logEntries = new TreeMap();
        this.commandTextBox = new TextBox();
        this.commandTextBox.setVisibleLength(80);
        this.logOutputArea = new TextArea();
        this.logOutputArea.setCharacterWidth(80);
        this.logOutputArea.setEnabled(false);
        this.sendBusyIndicator = new SimpleBusyIndicator();
        this.fetchLogBusyIndicator = new SimpleBusyIndicator();
        DialogUtils.linkEscapeToButton((Button)this.getOkButton(), (HasAllKeyHandlers[])new HasAllKeyHandlers[]{this.commandTextBox});
    }

    protected Focusable getInitialFocusWidget() {
        return this.commandTextBox;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.setSpacing(5);
        Button sendButton = new Button(this.stringMessages.send());
        sendButton.addClickHandler(e -> this.sendCommand(this.commandTextBox.getValue()));
        DialogUtils.linkEnterToButton((Button)sendButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{this.commandTextBox});
        DialogUtils.linkEscapeToButton((Button)this.getOkButton(), (HasAllKeyHandlers[])new HasAllKeyHandlers[]{sendButton});
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(5);
        horizontalPanel.add((Widget)this.commandTextBox);
        horizontalPanel.add((Widget)sendButton);
        horizontalPanel.add((Widget)this.sendBusyIndicator);
        verticalPanel.add((Widget)horizontalPanel);
        verticalPanel.add((Widget)new Label(this.stringMessages.commandLogOutput()));
        HorizontalPanel logPanel = new HorizontalPanel();
        logPanel.add((Widget)this.logOutputArea);
        VerticalPanel logButtonPanel = new VerticalPanel();
        Button refreshLogButton = new Button(this.stringMessages.refresh());
        refreshLogButton.addClickHandler(e -> this.updateLog());
        logPanel.add((Widget)logButtonPanel);
        logButtonPanel.add((Widget)refreshLogButton);
        Button enableOverTheAirLogButton = new Button(this.stringMessages.enableOverTheAirLog());
        enableOverTheAirLogButton.addClickHandler(e -> this.enableOverTheAirLog(true));
        logButtonPanel.add((Widget)enableOverTheAirLogButton);
        Button disableOverTheAirLogButton = new Button(this.stringMessages.disableOverTheAirLog());
        disableOverTheAirLogButton.addClickHandler(e -> this.enableOverTheAirLog(false));
        logButtonPanel.add((Widget)disableOverTheAirLogButton);
        logPanel.add((Widget)this.fetchLogBusyIndicator);
        verticalPanel.add((Widget)logPanel);
        return verticalPanel;
    }

    private void enableOverTheAirLog(boolean enabled) {
        this.sailingServiceWrite.enableIgtimiDeviceOverTheAirLog(this.deviceSerialNumber, enabled, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void sendCommand(String command) {
        this.sendBusyIndicator.setBusy(true);
        this.sailingServiceWrite.sendIgtimiCommand(this.deviceSerialNumber, command, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateLog() {
        Duration duration;
        this.fetchLogBusyIndicator.setBusy(true);
        if (this.logEntries.isEmpty()) {
            duration = Duration.ONE_MINUTE;
        } else {
            TimePoint lastLogEntryTime = (TimePoint)this.logEntries.lastKey();
            duration = lastLogEntryTime.until(TimePoint.now());
        }
        this.sailingServiceWrite.getIgtimiDeviceLogs(this.deviceSerialNumber, duration, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Void getResult() {
        return null;
    }

    static /* synthetic */ StringMessages access$1(FreestyleCommandDialog freestyleCommandDialog) {
        return freestyleCommandDialog.stringMessages;
    }

    static /* synthetic */ String access$2(FreestyleCommandDialog freestyleCommandDialog) {
        return freestyleCommandDialog.deviceSerialNumber;
    }

    static /* synthetic */ void access$3(FreestyleCommandDialog freestyleCommandDialog) {
        freestyleCommandDialog.updateLog();
    }

    static /* synthetic */ SimpleBusyIndicator access$4(FreestyleCommandDialog freestyleCommandDialog) {
        return freestyleCommandDialog.sendBusyIndicator;
    }

    static /* synthetic */ SimpleBusyIndicator access$5(FreestyleCommandDialog freestyleCommandDialog) {
        return freestyleCommandDialog.fetchLogBusyIndicator;
    }

    static /* synthetic */ NavigableMap access$6(FreestyleCommandDialog freestyleCommandDialog) {
        return freestyleCommandDialog.logEntries;
    }

    static /* synthetic */ TextArea access$7(FreestyleCommandDialog freestyleCommandDialog) {
        return freestyleCommandDialog.logOutputArea;
    }
}

