/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.trackfiles.TrackFilesDataSource;
import com.sap.sailing.domain.common.trackfiles.TrackFilesFormat;
import com.sap.sailing.gwt.ui.client.StringMessages;
import java.util.ArrayList;
import java.util.List;

public class ExportPopup
extends DialogBox {
    private List<RaceDTO> raceDTOs;
    private final FormPanel formPanel;
    private final VerticalPanel mainPanel;

    public ExportPopup(StringMessages stringMessages) {
        super(true);
        this.getCaption().setText(stringMessages.export());
        this.formPanel = new FormPanel("_blank");
        this.formPanel.setAction("/sailingserver/trackfiles/export");
        this.formPanel.setMethod("post");
        this.mainPanel = new VerticalPanel();
        this.formPanel.setWidget((Widget)this.mainPanel);
        this.add((Widget)this.formPanel);
        ListBox lbFormat = new ListBox();
        lbFormat.setMultipleSelect(false);
        lbFormat.setName("format");
        lbFormat.setVisibleItemCount(1);
        TrackFilesFormat[] trackFilesFormatArray = TrackFilesFormat.values();
        int n = trackFilesFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            TrackFilesFormat format = trackFilesFormatArray[n2];
            lbFormat.addItem(format.name());
            ++n2;
        }
        this.mainPanel.add((Widget)lbFormat);
        ListBox lbData = new ListBox();
        lbData.setMultipleSelect(true);
        lbData.setName("data");
        TrackFilesDataSource[] trackFilesDataSourceArray = TrackFilesDataSource.values();
        int n3 = trackFilesDataSourceArray.length;
        n = 0;
        while (n < n3) {
            TrackFilesDataSource dataSource = trackFilesDataSourceArray[n];
            lbData.addItem(dataSource.name());
            ++n;
        }
        lbData.setVisibleItemCount(lbData.getItemCount());
        lbData.setItemSelected(0, true);
        this.mainPanel.add((Widget)lbData);
        CheckBox cbBeforeAfter = new CheckBox(stringMessages.dataBeforeAfter());
        cbBeforeAfter.setValue(Boolean.valueOf(true));
        cbBeforeAfter.setName("before_after");
        this.mainPanel.add((Widget)cbBeforeAfter);
        CheckBox cbRawFixes = new CheckBox(stringMessages.rawFixes());
        cbRawFixes.setValue(Boolean.valueOf(true));
        cbRawFixes.setName("raw_fixes");
        this.mainPanel.add((Widget)cbRawFixes);
        FlowPanel btnPanel = new FlowPanel();
        this.mainPanel.add((Widget)btnPanel);
        Button btnExport = new Button(stringMessages.export());
        btnExport.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        btnPanel.add((Widget)btnExport);
        Button btnCancel = new Button(stringMessages.cancel());
        btnCancel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        btnPanel.add((Widget)btnCancel);
    }

    public void center(List<RaceDTO> raceDTOs) {
        this.raceDTOs = raceDTOs;
        this.center();
    }

    private void openExportUrl() {
        ArrayList<Hidden> races = new ArrayList<Hidden>();
        for (RaceDTO raceDTO : this.raceDTOs) {
            Hidden h = new Hidden("regattaraces", String.valueOf(raceDTO.getRegattaName()) + ":" + raceDTO.getRaceIdentifier().getRaceName());
            races.add(h);
            this.mainPanel.add((Widget)h);
        }
        this.formPanel.submit();
        for (Hidden hidden : races) {
            this.mainPanel.remove((Widget)hidden);
        }
    }

    static /* synthetic */ void access$0(ExportPopup exportPopup) {
        exportPopup.openExportUrl();
    }
}

