/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.common.client.help.HelpButton;
import com.sap.sailing.gwt.common.client.help.HelpButtonResources;
import com.sap.sailing.gwt.ui.adminconsole.DeviceConfigurationDetailComposite;
import com.sap.sailing.gwt.ui.adminconsole.DeviceConfigurationListComposite;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationWithSecurityDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.SelectedElementsCountingButton;
import java.util.UUID;

public class DeviceConfigurationPanel
extends SimplePanel
implements DeviceConfigurationDetailComposite.DeviceConfigurationFactory {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final UserService userService;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private Button addConfigurationButton;
    private Button removeConfigurationButton;
    private Button refreshConfigurationsButton;
    private DeviceConfigurationListComposite listComposite;
    private DeviceConfigurationDetailComposite detailComposite;
    private final RefreshableMultiSelectionModel<DeviceConfigurationWithSecurityDTO> refreshableMultiSelectionModel;

    public DeviceConfigurationPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.userService = presenter.getUserService();
        this.stringMessages = stringMessages;
        this.errorReporter = presenter.getErrorReporter();
        this.listComposite = new DeviceConfigurationListComposite(this.sailingServiceWrite, this.errorReporter, stringMessages, this.userService);
        this.refreshableMultiSelectionModel = this.listComposite.getSelectionModel();
        this.detailComposite = this.setupUi(presenter);
        this.refreshableMultiSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private DeviceConfigurationDetailComposite setupUi(AdminConsoleView.Presenter presenter) {
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        this.setupControlPanel(mainPanel);
        return this.setupConfigurationPanels(mainPanel, presenter);
    }

    private void setupControlPanel(VerticalPanel mainPanel) {
        HorizontalPanel deviceManagementControlPanel = new HorizontalPanel();
        deviceManagementControlPanel.setSpacing(5);
        this.addConfigurationButton = new Button(this.stringMessages.addConfiguration());
        this.addConfigurationButton.ensureDebugId("addDeviceConfigurationButton");
        this.addConfigurationButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (this.userService.hasCreatePermission(SecuredDomainType.RACE_MANAGER_APP_DEVICE_CONFIGURATION)) {
            deviceManagementControlPanel.add((Widget)this.addConfigurationButton);
        }
        this.removeConfigurationButton = new SelectedElementsCountingButton(this.stringMessages.remove(), (SetSelectionModel)this.refreshableMultiSelectionModel, arg_0 -> ((StringMessages)StringMessages.INSTANCE).doYouReallyWantToRemoveSelectedElements(arg_0), event -> this.removeConfiguration());
        deviceManagementControlPanel.add((Widget)this.removeConfigurationButton);
        this.refreshConfigurationsButton = new Button(this.stringMessages.refresh());
        this.refreshConfigurationsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        deviceManagementControlPanel.add((Widget)this.refreshConfigurationsButton);
        deviceManagementControlPanel.add((Widget)new HelpButton(HelpButtonResources.INSTANCE, this.stringMessages.videoGuide(), "https://wiki.sapsailing.com/wiki/howto/tutorials/sailingracemanager/sailing-race-guide.md"));
        mainPanel.add((Widget)deviceManagementControlPanel);
    }

    private DeviceConfigurationDetailComposite setupConfigurationPanels(VerticalPanel mainPanel, AdminConsoleView.Presenter presenter) {
        Grid grid = new Grid(1, 2);
        mainPanel.add((Widget)grid);
        grid.setWidget(0, 0, (Widget)this.listComposite);
        grid.getRowFormatter().setVerticalAlign(0, HasVerticalAlignment.ALIGN_TOP);
        grid.getColumnFormatter().getElement(1).getStyle().setPaddingTop(2.0, Style.Unit.EM);
        DeviceConfigurationDetailComposite myDetailComposite = new DeviceConfigurationDetailComposite(presenter, this.stringMessages, (DeviceConfigurationDetailComposite.DeviceConfigurationFactory)this);
        myDetailComposite.setVisible(false);
        grid.setWidget(0, 1, (Widget)myDetailComposite);
        return myDetailComposite;
    }

    private void createConfiguration() {
        DeviceConfigurationWithSecurityDTO newConfiguration = new DeviceConfigurationWithSecurityDTO(null);
        newConfiguration.id = UUID.randomUUID();
        this.obtainAndSetNameForConfigurationAndAdd(newConfiguration);
    }

    public void obtainAndSetNameForConfigurationAndAdd(DeviceConfigurationWithSecurityDTO configurationToObtainAndSetNameForAndAdd) {
        this.sailingServiceWrite.getDeviceConfigurations((AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void update(DeviceConfigurationWithSecurityDTO configurationToUpdate) {
        this.listComposite.update(configurationToUpdate);
    }

    private void removeConfiguration() {
        this.detailComposite.setConfiguration(null);
        for (DeviceConfigurationDTO config : this.refreshableMultiSelectionModel.getSelectedSet()) {
            this.sailingServiceWrite.removeDeviceConfiguration(config.id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$0(DeviceConfigurationPanel deviceConfigurationPanel) {
        return deviceConfigurationPanel.refreshableMultiSelectionModel;
    }

    static /* synthetic */ DeviceConfigurationDetailComposite access$1(DeviceConfigurationPanel deviceConfigurationPanel) {
        return deviceConfigurationPanel.detailComposite;
    }

    static /* synthetic */ Button access$2(DeviceConfigurationPanel deviceConfigurationPanel) {
        return deviceConfigurationPanel.removeConfigurationButton;
    }

    static /* synthetic */ void access$3(DeviceConfigurationPanel deviceConfigurationPanel) {
        deviceConfigurationPanel.createConfiguration();
    }

    static /* synthetic */ DeviceConfigurationListComposite access$4(DeviceConfigurationPanel deviceConfigurationPanel) {
        return deviceConfigurationPanel.listComposite;
    }

    static /* synthetic */ StringMessages access$5(DeviceConfigurationPanel deviceConfigurationPanel) {
        return deviceConfigurationPanel.stringMessages;
    }

    static /* synthetic */ SailingServiceWriteAsync access$6(DeviceConfigurationPanel deviceConfigurationPanel) {
        return deviceConfigurationPanel.sailingServiceWrite;
    }

    static /* synthetic */ ErrorReporter access$7(DeviceConfigurationPanel deviceConfigurationPanel) {
        return deviceConfigurationPanel.errorReporter;
    }
}

