/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.racelog.AuthorPriority;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AdminConsoleResources;
import com.sap.sailing.gwt.ui.adminconsole.AuthorPriorityFormatter;
import com.sap.sailing.gwt.ui.adminconsole.DeviceConfigurationDetailComposite;
import com.sap.sailing.gwt.ui.adminconsole.DeviceConfigurationQRIdentifierDialog;
import com.sap.sailing.gwt.ui.adminconsole.SuggestedCourseAreaNames;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.controls.listedit.StringListEditorComposite;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DeviceConfigurationDetailComposite
extends Composite {
    private final AdminConsoleResources resources = (AdminConsoleResources)GWT.create(AdminConsoleResources.class);
    protected final SailingServiceWriteAsync sailingServiceWrite;
    protected final ErrorReporter errorReporter;
    protected final StringMessages stringMessages;
    private final CaptionPanel captionPanel;
    private final VerticalPanel contentPanel;
    private final Button cloneButton;
    private final Button updateButton;
    protected DeviceConfigurationWithSecurityDTO originalConfiguration;
    protected TextBox uuidBox;
    protected TextBox identifierBox;
    private StringListEditorComposite allowedCourseAreasList;
    private TextBox mailRecipientBox;
    private StringListEditorComposite courseNamesList;
    private CheckBox overwriteRegattaConfigurationBox;
    private final ListBox eventListBox;
    private final Map<UUID, EventDTO> eventsById;
    private final ListBox courseAreaListBox;
    private final ListBox priorityListBox;
    private DeviceConfigurationDTO.RegattaConfigurationDTO currentRegattaConfiguration;
    private final UserService userService;
    private KeyUpHandler dirtyMarker = new /* Unavailable Anonymous Inner Class!! */;
    private ValueChangeHandler<Iterable<String>> dirtyValueMarker = new /* Unavailable Anonymous Inner Class!! */;

    public DeviceConfigurationDetailComposite(AdminConsoleView.Presenter presenter, StringMessages stringMessages, DeviceConfigurationFactory callbackInterface) {
        this.eventsById = new HashMap();
        this.sailingServiceWrite = presenter.getSailingService();
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        this.currentRegattaConfiguration = null;
        this.priorityListBox = this.createPriorityListBox();
        this.courseAreaListBox = new ListBox();
        this.courseAreaListBox.addChangeHandler(e -> this.markAsDirty(true));
        this.eventListBox = new ListBox();
        this.eventListBox.addChangeHandler(e -> {
            this.markAsDirty(true);
            String selectedValue = this.eventListBox.getSelectedValue();
            this.fillCourseAreaListBox((EventDTO)this.eventsById.get(selectedValue == null || selectedValue.isEmpty() ? null : UUID.fromString(selectedValue)));
        });
        this.captionPanel = new CaptionPanel(stringMessages.configuration());
        this.captionPanel.ensureDebugId("DeviceConfigurationDetailComposite");
        VerticalPanel verticalPanel = new VerticalPanel();
        this.contentPanel = new VerticalPanel();
        this.cloneButton = new Button(String.valueOf(stringMessages.save()) + " + " + stringMessages.clone());
        this.cloneButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.updateButton = new Button(stringMessages.save());
        this.updateButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        verticalPanel.add((Widget)this.contentPanel);
        verticalPanel.add((Widget)new HTML("<hr  style=\"width:100%;\" />"));
        HorizontalPanel actionPanel = new HorizontalPanel();
        actionPanel.add((Widget)this.cloneButton);
        actionPanel.add((Widget)this.updateButton);
        verticalPanel.add((Widget)actionPanel);
        this.captionPanel.add((Widget)verticalPanel);
        this.initWidget((Widget)this.captionPanel);
        this.setConfiguration(null);
        this.userService = presenter.getUserService();
        presenter.getEventsRefresher().addDisplayerAndCallFillOnInit(eventDTOs -> this.fillEvents(eventDTOs));
    }

    private ListBox createPriorityListBox() {
        ListBox result = new ListBox();
        result.addItem(this.stringMessages.selectARole(), "");
        AuthorPriority[] authorPriorityArray = AuthorPriority.values();
        int n = authorPriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            AuthorPriority priority = authorPriorityArray[n2];
            result.addItem(AuthorPriorityFormatter.getDescription((AuthorPriority)priority, (StringMessages)this.stringMessages), Integer.toString(priority.getPriority()));
            ++n2;
        }
        return result;
    }

    private void fillEvents(Iterable<EventDTO> events) {
        this.eventListBox.clear();
        this.eventsById.clear();
        this.eventListBox.addItem(this.stringMessages.selectSailingEvent(), "");
        ArrayList eventsSortedByName = new ArrayList();
        Util.addAll(events, eventsSortedByName);
        Collections.sort(eventsSortedByName, (e1, e2) -> {
            int result = e1.getName().compareTo(e2.getName());
            if (result == 0) {
                result = e1.getId().compareTo(e2.getId());
            }
            return result;
        });
        for (EventDTO event : eventsSortedByName) {
            this.eventsById.put(event.getId(), event);
            this.eventListBox.addItem(event.getName(), event.getId().toString());
        }
    }

    public void setConfiguration(DeviceConfigurationWithSecurityDTO config) {
        if (config == null) {
            this.clearUi();
            this.setVisible(false);
        } else {
            this.setupUi(config);
            this.setVisible(true);
        }
    }

    private void updateEventSelection(UUID eventId) {
        int i = 0;
        while (i < this.eventListBox.getItemCount()) {
            String value = this.eventListBox.getValue(i);
            if (eventId == null && value.isEmpty() || Util.equalsWithNull((Object)(eventId == null ? null : eventId.toString()), (Object)value)) {
                this.eventListBox.setSelectedIndex(i);
                this.fillCourseAreaListBox((EventDTO)this.eventsById.get(eventId));
            }
            ++i;
        }
    }

    private void fillCourseAreaListBox(EventDTO event) {
        this.courseAreaListBox.clear();
        this.courseAreaListBox.addItem(this.stringMessages.selectCourseArea(), "");
        if (event != null) {
            int i = 1;
            for (CourseAreaDTO courseArea : event.getVenue().getCourseAreas()) {
                this.courseAreaListBox.addItem(courseArea.getName(), courseArea.getId().toString());
                if (Util.equalsWithNull((Object)this.originalConfiguration.courseAreaId, (Object)courseArea.getId())) {
                    this.courseAreaListBox.setSelectedIndex(i);
                }
                ++i;
            }
        }
    }

    private void setupUi(DeviceConfigurationWithSecurityDTO config) {
        this.clearUi();
        this.originalConfiguration = config;
        this.currentRegattaConfiguration = config.regattaConfiguration;
        this.setupGeneral();
        this.setupRegattaConfiguration();
        boolean hasUpdatePermission = this.userService.hasPermission((SecuredDTO)config, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
        boolean hasUpdateAndCreatePermission = hasUpdatePermission && this.userService.hasCreatePermission(SecuredDomainType.RACE_MANAGER_APP_DEVICE_CONFIGURATION);
        this.cloneButton.setVisible(hasUpdateAndCreatePermission);
        this.updateButton.setVisible(hasUpdatePermission);
        this.allowedCourseAreasList.setEnabled(hasUpdatePermission);
        this.courseNamesList.setEnabled(hasUpdatePermission);
        this.overwriteRegattaConfigurationBox.setEnabled(hasUpdatePermission);
        this.updateEventSelection(config.eventId);
        this.updatePrioritySelection(config.priority);
    }

    private void updatePrioritySelection(Integer priority) {
        if (priority == null) {
            this.priorityListBox.setSelectedIndex(0);
        } else {
            int i = 1;
            while (i < this.priorityListBox.getItemCount()) {
                if (Integer.valueOf(this.priorityListBox.getValue(i)).equals(priority)) {
                    this.priorityListBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
    }

    private void setupRegattaConfiguration() {
        Grid grid = new Grid(1, 3);
        Button editButton = new Button(this.stringMessages.edit());
        this.overwriteRegattaConfigurationBox = new CheckBox(this.stringMessages.overwriteRacingProceduresConfiguration());
        this.overwriteRegattaConfigurationBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        grid.setWidget(0, 0, (Widget)this.overwriteRegattaConfigurationBox);
        editButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.overwriteRegattaConfigurationBox.setValue(Boolean.valueOf(this.currentRegattaConfiguration != null));
        editButton.setEnabled(this.currentRegattaConfiguration != null);
        Image helpImage = new Image(this.resources.help());
        helpImage.setAltText(this.stringMessages.overwriteRacingProceduresConfigurationHelpText());
        helpImage.setTitle(this.stringMessages.overwriteRacingProceduresConfigurationHelpText());
        grid.setWidget(0, 1, (Widget)editButton);
        grid.setWidget(0, 2, (Widget)helpImage);
        this.contentPanel.add((Widget)grid);
    }

    private void setupGeneral() {
        Grid grid = new Grid(8, 2);
        int row = 0;
        this.identifierBox = new TextBox();
        this.identifierBox.setWidth("80%");
        this.identifierBox.setText(this.originalConfiguration.name);
        this.identifierBox.setReadOnly(true);
        grid.setWidget(row, 0, (Widget)new Label(this.stringMessages.identifier()));
        HorizontalPanel panel = new HorizontalPanel();
        Button qrCodeButton = this.createQrCodeButton();
        panel.add((Widget)this.identifierBox);
        panel.add((Widget)qrCodeButton);
        grid.setWidget(row++, 1, (Widget)panel);
        this.uuidBox = new TextBox();
        this.uuidBox.setWidth("80%");
        this.uuidBox.setText(this.originalConfiguration.id.toString());
        this.uuidBox.setReadOnly(true);
        grid.setWidget(row, 0, (Widget)new Label(this.stringMessages.id()));
        grid.setWidget(row++, 1, (Widget)this.uuidBox);
        this.setupCourseAreasBox(grid, row++);
        this.setupRecipientBox(grid, row++);
        this.setupCourseNameBox(grid, row++);
        grid.setWidget(row, 0, (Widget)new Label(this.stringMessages.event()));
        grid.setWidget(row++, 1, (Widget)this.eventListBox);
        grid.setWidget(row, 0, (Widget)new Label(this.stringMessages.courseArea()));
        grid.setWidget(row++, 1, (Widget)this.courseAreaListBox);
        grid.setWidget(row, 0, (Widget)new Label(this.stringMessages.authorPriority()));
        grid.setWidget(row++, 1, (Widget)this.priorityListBox);
        this.contentPanel.add((Widget)grid);
    }

    private void setupCourseAreasBox(Grid grid, int gridRow) {
        List initialValues = this.originalConfiguration.allowedCourseAreaNames == null ? Collections.emptyList() : this.originalConfiguration.allowedCourseAreaNames;
        this.allowedCourseAreasList = new StringListEditorComposite((Iterable)initialValues, (com.sap.sse.gwt.client.StringMessages)this.stringMessages, this.stringMessages.courseAreas(), IconResources.INSTANCE.removeIcon(), SuggestedCourseAreaNames.suggestedCourseAreaNames, this.stringMessages.enterCourseAreaName());
        this.allowedCourseAreasList.setWidth("80%");
        this.allowedCourseAreasList.addValueChangeHandler(this.dirtyValueMarker);
        grid.setWidget(gridRow, 0, (Widget)new Label(this.stringMessages.allowedCourseAreas()));
        grid.setWidget(gridRow, 1, (Widget)this.allowedCourseAreasList);
    }

    private void setupCourseNameBox(Grid grid, int gridRow) {
        List initialValues = this.originalConfiguration.byNameDesignerCourseNames == null ? Collections.emptyList() : this.originalConfiguration.byNameDesignerCourseNames;
        List<String> suggestedCourseNames = Arrays.asList(this.stringMessages.upWind(), this.stringMessages.downWind());
        this.courseNamesList = new StringListEditorComposite((Iterable)initialValues, (com.sap.sse.gwt.client.StringMessages)this.stringMessages, this.stringMessages.courseNames(), IconResources.INSTANCE.removeIcon(), suggestedCourseNames, this.stringMessages.enterCourseName());
        this.courseNamesList.setWidth("80%");
        this.courseNamesList.addValueChangeHandler(this.dirtyValueMarker);
        grid.setWidget(gridRow, 0, (Widget)new Label(this.stringMessages.courseNames()));
        grid.setWidget(gridRow, 1, (Widget)this.courseNamesList);
    }

    private void setupRecipientBox(Grid grid, int gridRow) {
        this.mailRecipientBox = new TextBox();
        this.mailRecipientBox.setWidth("80%");
        this.mailRecipientBox.addKeyUpHandler(this.dirtyMarker);
        if (this.originalConfiguration.resultsMailRecipient != null) {
            this.mailRecipientBox.setText(this.originalConfiguration.resultsMailRecipient);
        }
        grid.setWidget(gridRow, 0, (Widget)new Label(this.stringMessages.resultsMailRecipient()));
        grid.setWidget(gridRow, 1, (Widget)this.mailRecipientBox);
    }

    private void clearUi() {
        this.originalConfiguration = null;
        this.contentPanel.clear();
    }

    private void markAsDirty(boolean dirty) {
        if (dirty) {
            if (this.captionPanel.getCaptionText().equals(this.stringMessages.configuration())) {
                this.captionPanel.setCaptionText(String.valueOf(this.stringMessages.configuration()) + "* (" + this.stringMessages.changed() + ")");
            }
        } else if (!this.captionPanel.getCaptionText().equals(this.stringMessages.configuration())) {
            this.captionPanel.setCaptionText(this.stringMessages.configuration());
        }
    }

    private DeviceConfigurationWithSecurityDTO getResult() {
        DeviceConfigurationWithSecurityDTO result = new DeviceConfigurationWithSecurityDTO(this.originalConfiguration.getIdentifier());
        result.setOwnership(this.originalConfiguration.getOwnership());
        result.setAccessControlList(this.originalConfiguration.getAccessControlList());
        result.name = this.identifierBox.getValue();
        result.id = UUID.fromString(this.uuidBox.getValue());
        if (!this.allowedCourseAreasList.getValue().isEmpty()) {
            result.allowedCourseAreaNames = this.allowedCourseAreasList.getValue();
        }
        if (!this.mailRecipientBox.getText().isEmpty()) {
            String string = result.resultsMailRecipient = this.mailRecipientBox.getText().isEmpty() ? null : this.mailRecipientBox.getText();
        }
        if (!this.courseNamesList.getValue().isEmpty()) {
            result.byNameDesignerCourseNames = this.courseNamesList.getValue();
        }
        if (this.overwriteRegattaConfigurationBox.getValue().booleanValue()) {
            result.regattaConfiguration = this.currentRegattaConfiguration;
        }
        if (!this.eventListBox.getSelectedValue().isEmpty()) {
            result.eventId = UUID.fromString(this.eventListBox.getSelectedValue());
        }
        if (!this.courseAreaListBox.getSelectedValue().isEmpty()) {
            result.courseAreaId = UUID.fromString(this.courseAreaListBox.getSelectedValue());
        }
        if (!this.priorityListBox.getSelectedValue().isEmpty()) {
            result.priority = Integer.decode(this.priorityListBox.getSelectedValue());
        }
        return result;
    }

    private void updateConfiguration(DeviceConfigurationFactory callbackInterface) {
        if (this.originalConfiguration == null) {
            this.errorReporter.reportError(this.stringMessages.invalidState());
            return;
        }
        DeviceConfigurationWithSecurityDTO dto = this.getResult();
        this.sailingServiceWrite.createOrUpdateDeviceConfiguration((DeviceConfigurationDTO)dto, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private Button createQrCodeButton() {
        Button qrCodeButton = new Button(this.stringMessages.qrSync());
        qrCodeButton.ensureDebugId("DeviceConfigurationDetailsQrCodeButton");
        qrCodeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return qrCodeButton;
    }

    private void createAndShowDialogForAccessToken(String accessToken) {
        DeviceConfigurationWithSecurityDTO config = this.getResult();
        DeviceConfigurationQRIdentifierDialog dialog = new DeviceConfigurationQRIdentifierDialog(this.uuidBox.getValue(), this.identifierBox.getValue(), config.eventId, config.courseAreaId, config.priority, accessToken, this.stringMessages);
        dialog.show();
        dialog.center();
    }

    static /* synthetic */ void access$0(DeviceConfigurationDetailComposite deviceConfigurationDetailComposite, boolean bl) {
        deviceConfigurationDetailComposite.markAsDirty(bl);
    }

    static /* synthetic */ void access$1(DeviceConfigurationDetailComposite deviceConfigurationDetailComposite, DeviceConfigurationFactory deviceConfigurationFactory) {
        deviceConfigurationDetailComposite.updateConfiguration(deviceConfigurationFactory);
    }

    static /* synthetic */ DeviceConfigurationWithSecurityDTO access$2(DeviceConfigurationDetailComposite deviceConfigurationDetailComposite) {
        return deviceConfigurationDetailComposite.getResult();
    }

    static /* synthetic */ DeviceConfigurationDTO.RegattaConfigurationDTO access$3(DeviceConfigurationDetailComposite deviceConfigurationDetailComposite) {
        return deviceConfigurationDetailComposite.currentRegattaConfiguration;
    }

    static /* synthetic */ void access$4(DeviceConfigurationDetailComposite deviceConfigurationDetailComposite, DeviceConfigurationDTO.RegattaConfigurationDTO regattaConfigurationDTO) {
        deviceConfigurationDetailComposite.currentRegattaConfiguration = regattaConfigurationDTO;
    }

    static /* synthetic */ UserService access$5(DeviceConfigurationDetailComposite deviceConfigurationDetailComposite) {
        return deviceConfigurationDetailComposite.userService;
    }

    static /* synthetic */ void access$6(DeviceConfigurationDetailComposite deviceConfigurationDetailComposite, String string) {
        deviceConfigurationDetailComposite.createAndShowDialogForAccessToken(string);
    }
}

