/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import java.util.HashSet;
import java.util.Set;

public class CourseAndCompetitorCopyOperation {
    final Set<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> raceLogsToCopyTo;
    final boolean copyCourse;
    final boolean copyCompetitors;
    private final boolean copyMarkDeviceMappings;
    private final Integer priority;
    private final ErrorReporter errorReporter;
    private final SailingServiceWriteAsync sailingServiceWrite;

    public CourseAndCompetitorCopyOperation(Set<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> racesToCopyTo, boolean copyCourse, boolean copyCompetitors, boolean copyMarkDeviceMappings, Integer priority, SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter) {
        this.raceLogsToCopyTo = racesToCopyTo;
        this.copyCourse = copyCourse;
        this.copyCompetitors = copyCompetitors;
        this.copyMarkDeviceMappings = copyMarkDeviceMappings;
        this.sailingServiceWrite = sailingServiceWrite;
        this.errorReporter = errorReporter;
        this.priority = priority;
    }

    public Set<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> getRaceLogsToCopyTo() {
        return this.raceLogsToCopyTo;
    }

    public Integer getPriority() {
        return this.priority;
    }

    private Set<Util.Triple<String, String, String>> convertToRacelogs(String leaderboardName) {
        HashSet<Util.Triple<String, String, String>> toRaceLogs = new HashSet<Util.Triple<String, String, String>>();
        for (AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race : this.raceLogsToCopyTo) {
            toRaceLogs.add((Util.Triple<String, String, String>)this.toTriple(((StrippedLeaderboardDTO)race.getC()).getName(), race));
        }
        return toRaceLogs;
    }

    private Util.Triple<String, String, String> toTriple(String leaderboardName, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality race) {
        return new Util.Triple((Object)leaderboardName, (Object)((RaceColumnDTO)race.getA()).getName(), (Object)((FleetDTO)race.getB()).getName());
    }

    public void perform(String leaderboardName, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnDTOAndFleetDTOFromWhichToCopy, Runnable onSuccessCallback) {
        Util.Triple fromTriple = this.toTriple(leaderboardName, raceColumnDTOAndFleetDTOFromWhichToCopy);
        Set toRacelogs = this.convertToRacelogs(leaderboardName);
        if (this.copyCourse) {
            this.sailingServiceWrite.copyCourseToOtherRaceLogs(fromTriple, toRacelogs, this.copyMarkDeviceMappings, this.getPriority().intValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.copyCompetitors) {
            this.sailingServiceWrite.copyCompetitorsToOtherRaceLogs(fromTriple, toRacelogs, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ ErrorReporter access$0(CourseAndCompetitorCopyOperation courseAndCompetitorCopyOperation) {
        return courseAndCompetitorCopyOperation.errorReporter;
    }
}

