/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.adminconsole.CourseAndCompetitorCopyOperation;
import com.sap.sailing.gwt.ui.adminconsole.RaceTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CopyCourseAndCompetitorsDialog
extends DataEntryDialog<CourseAndCompetitorCopyOperation> {
    private final ListBox leaderboardDropDown;
    private final RaceTableWrapper<RefreshableMultiSelectionModel<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality>> racesTable;
    private final CheckBox courseCheckBox;
    private final CheckBox competitorCheckBox;
    private final CheckBox copyMarkDeviceMappingsCheckBox;
    private final IntegerBox priorityBox;
    private final StringMessages stringMessages;
    private SailingServiceWriteAsync sailingServiceWrite;
    private ErrorReporter errorReporter;

    public CopyCourseAndCompetitorsDialog(SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter, StringMessages stringMessages, Collection<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> races, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceToExclude, List<StrippedLeaderboardDTO> availableLeaderboardList, String leaderboardName, Distance buoyZoneRadius, DataEntryDialog.DialogCallback<CourseAndCompetitorCopyOperation> dialogCallback) {
        super(stringMessages.selectRaces(), stringMessages.selectRaces(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, dialogCallback);
        this.stringMessages = stringMessages;
        this.leaderboardDropDown = this.createListBox(false);
        this.copyMarkDeviceMappingsCheckBox = this.createCheckbox(stringMessages.copyMarkDeviceMappings());
        List availableLeaderboardsSortedByName = availableLeaderboardList.stream().sorted((lb1, lb2) -> new NaturalComparator().compare(lb1.getName(), lb2.getName())).collect(Collectors.toList());
        this.fillLeaderboardDropDownAndSelect(availableLeaderboardsSortedByName, leaderboardName);
        this.racesTable = new RaceTableWrapper(sailingServiceWrite, stringMessages, errorReporter, true);
        this.racesTable.setSelectedLeaderboardName(leaderboardName);
        this.racesTable.getDataProvider().getList().addAll(races);
        ((RefreshableMultiSelectionModel)this.racesTable.getSelectionModel()).addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.leaderboardDropDown.addChangeHandler(e -> this.updateRacesTable(this.leaderboardDropDown.getSelectedValue(), availableLeaderboardList, raceToExclude, leaderboardName));
        this.courseCheckBox = this.createCheckbox(stringMessages.copyCourse());
        this.courseCheckBox.setValue(Boolean.valueOf(true));
        this.competitorCheckBox = this.createCheckbox(stringMessages.copyCompetitors());
        this.competitorCheckBox.setValue(Boolean.valueOf(false));
        this.priorityBox = this.createIntegerBox(Integer.valueOf(1), 1);
        this.sailingServiceWrite = sailingServiceWrite;
        this.errorReporter = errorReporter;
    }

    private void updateRacesTable(String nameOfSelectedLeaderboard, List<StrippedLeaderboardDTO> availableLeaderboardList, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceToExclude, String fromLeaderboardName) {
        this.racesTable.getDataProvider().getList().clear();
        ArrayList<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> newRaces = new ArrayList<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality>();
        for (StrippedLeaderboardDTO leaderboard : availableLeaderboardList) {
            if (!leaderboard.getName().equals(nameOfSelectedLeaderboard)) continue;
            for (RaceColumnDTO raceColumn : leaderboard.getRaceList()) {
                for (FleetDTO fleet : raceColumn.getFleets()) {
                    if (!(!fromLeaderboardName.equals(nameOfSelectedLeaderboard) | !raceColumn.getName().equals(((RaceColumnDTO)raceToExclude.getA()).getName())) && fleet.getName().equals(((FleetDTO)raceToExclude.getB()).getName())) continue;
                    newRaces.add(new AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality(raceColumn, fleet, leaderboard));
                }
            }
        }
        this.racesTable.refresh(newRaces);
        this.copyMarkDeviceMappingsCheckBox.setVisible(!nameOfSelectedLeaderboard.equals(fromLeaderboardName));
    }

    private void fillLeaderboardDropDownAndSelect(List<StrippedLeaderboardDTO> availableLeaderboardList, String leaderboardNameToSelect) {
        int i = 0;
        for (StrippedLeaderboardDTO leaderboard : availableLeaderboardList) {
            this.leaderboardDropDown.addItem(leaderboard.getName(), leaderboard.getName());
            if (leaderboard.getName().equals(leaderboardNameToSelect)) {
                this.leaderboardDropDown.setSelectedIndex(i);
            }
            ++i;
        }
    }

    protected Widget getAdditionalWidget() {
        FlowPanel mainPanel = new FlowPanel();
        HorizontalPanel checkBoxPanel = new HorizontalPanel();
        checkBoxPanel.add((Widget)this.courseCheckBox);
        checkBoxPanel.add((Widget)this.competitorCheckBox);
        checkBoxPanel.add((Widget)this.copyMarkDeviceMappingsCheckBox);
        this.copyMarkDeviceMappingsCheckBox.setVisible(false);
        mainPanel.add((Widget)checkBoxPanel);
        mainPanel.add((Widget)this.leaderboardDropDown);
        mainPanel.add((IsWidget)this.racesTable);
        HorizontalPanel hp = new HorizontalPanel();
        hp.setSpacing(3);
        mainPanel.add((Widget)hp);
        hp.add((Widget)new Label(this.stringMessages.authorPriority()));
        hp.add((Widget)this.priorityBox);
        return mainPanel;
    }

    protected CourseAndCompetitorCopyOperation getResult() {
        Set racesToCopyTo = ((RefreshableMultiSelectionModel)this.racesTable.getSelectionModel()).getSelectedSet();
        return new CourseAndCompetitorCopyOperation(racesToCopyTo, this.courseCheckBox.getValue().booleanValue(), this.competitorCheckBox.getValue().booleanValue(), this.copyMarkDeviceMappingsCheckBox.getValue().booleanValue(), (Integer)this.priorityBox.getValue(), this.sailingServiceWrite, this.errorReporter);
    }

    static /* synthetic */ void access$1(CopyCourseAndCompetitorsDialog copyCourseAndCompetitorsDialog) {
        copyCourseAndCompetitorsDialog.validateAndUpdate();
    }
}

