/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.adminconsole.CompactBoatTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CompactCompetitorTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.security.ui.client.UserService;

public class CompetitorToBoatMappingsViewPanel
extends SimplePanel {
    private final CompactCompetitorTableWrapper<RefreshableSingleSelectionModel<CompetitorDTO>> competitorTable;
    private final CompactBoatTableWrapper<RefreshableSingleSelectionModel<BoatDTO>> boatTable;
    private final String leaderboardName;
    private final String raceColumnName;
    private final String fleetName;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private final RefreshableSelectionModel<CompetitorDTO> refreshableCompetitorSelectionModel;

    public CompetitorToBoatMappingsViewPanel(SailingServiceWriteAsync sailingServiceWrite, StringMessages stringMessages, ErrorReporter errorReporter, String leaderboardName, String raceColumnName, String fleetName, UserService userService) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.stringMessages = stringMessages;
        this.leaderboardName = leaderboardName;
        this.raceColumnName = raceColumnName;
        this.fleetName = fleetName;
        this.errorReporter = errorReporter;
        this.competitorTable = new CompactCompetitorTableWrapper(sailingServiceWrite, stringMessages, errorReporter, false, true, userService);
        this.boatTable = new CompactBoatTableWrapper(sailingServiceWrite, stringMessages, errorReporter, false, true);
        this.refreshableCompetitorSelectionModel = this.competitorTable.getSelectionModel();
        this.refreshableCompetitorSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        CaptionPanel competitorsPanel = new CaptionPanel(stringMessages.competitors());
        competitorsPanel.ensureDebugId("CompetitorsSection");
        competitorsPanel.setContentWidget(this.competitorTable.asWidget());
        CaptionPanel boatsPanel = new CaptionPanel(stringMessages.boats());
        boatsPanel.ensureDebugId("BoatsSection");
        boatsPanel.setContentWidget(this.boatTable.asWidget());
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setSpacing(5);
        mainPanel.add((Widget)buttonPanel);
        Grid grid = new Grid(1, 2);
        grid.setWidget(0, 0, (Widget)competitorsPanel);
        grid.setWidget(0, 1, (Widget)boatsPanel);
        grid.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_TOP);
        grid.getCellFormatter().setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_TOP);
        mainPanel.add((Widget)grid);
        this.competitorTable.refreshCompetitorListFromRace(leaderboardName, raceColumnName, fleetName);
        this.boatTable.refreshBoatListFromRace(leaderboardName, raceColumnName, fleetName);
    }

    private void competitorSelectionChanged() {
        CompetitorDTO selectedCompetitor = this.getSelectedCompetitor();
        if (selectedCompetitor != null) {
            this.selectBoatForCompetitor(selectedCompetitor);
        } else {
            ((RefreshableSingleSelectionModel)this.boatTable.getSelectionModel()).clear();
        }
    }

    private void selectBoatInList(BoatDTO boat) {
        this.boatTable.selectBoat(boat);
    }

    private void selectBoatForCompetitor(CompetitorDTO selectedCompetitor) {
        this.sailingServiceWrite.getBoatLinkedToCompetitorForRace(this.leaderboardName, this.raceColumnName, this.fleetName, selectedCompetitor.getIdAsString(), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private CompetitorDTO getSelectedCompetitor() {
        if (((RefreshableSingleSelectionModel)this.competitorTable.getSelectionModel()).getSelectedSet().isEmpty()) {
            return null;
        }
        return (CompetitorDTO)((RefreshableSingleSelectionModel)this.competitorTable.getSelectionModel()).getSelectedSet().iterator().next();
    }

    static /* synthetic */ void access$0(CompetitorToBoatMappingsViewPanel competitorToBoatMappingsViewPanel) {
        competitorToBoatMappingsViewPanel.competitorSelectionChanged();
    }

    static /* synthetic */ ErrorReporter access$1(CompetitorToBoatMappingsViewPanel competitorToBoatMappingsViewPanel) {
        return competitorToBoatMappingsViewPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$2(CompetitorToBoatMappingsViewPanel competitorToBoatMappingsViewPanel) {
        return competitorToBoatMappingsViewPanel.stringMessages;
    }

    static /* synthetic */ String access$3(CompetitorToBoatMappingsViewPanel competitorToBoatMappingsViewPanel) {
        return competitorToBoatMappingsViewPanel.raceColumnName;
    }

    static /* synthetic */ String access$4(CompetitorToBoatMappingsViewPanel competitorToBoatMappingsViewPanel) {
        return competitorToBoatMappingsViewPanel.leaderboardName;
    }

    static /* synthetic */ void access$5(CompetitorToBoatMappingsViewPanel competitorToBoatMappingsViewPanel, BoatDTO boatDTO) {
        competitorToBoatMappingsViewPanel.selectBoatInList(boatDTO);
    }

    static /* synthetic */ CompactBoatTableWrapper access$6(CompetitorToBoatMappingsViewPanel competitorToBoatMappingsViewPanel) {
        return competitorToBoatMappingsViewPanel.boatTable;
    }
}

