/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithToolTipDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.ColorColumn;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorWithBoatEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorWithOptionalBoatAddDialog;
import com.sap.sailing.gwt.ui.adminconsole.TableWrapper;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CompetitorTableWrapper<S extends RefreshableSelectionModel<CompetitorDTO>>
extends TableWrapper<CompetitorDTO, S> {
    private final LabeledAbstractFilterablePanel<CompetitorDTO> filterField;
    private final boolean filterCompetitorsWithBoat;
    private final boolean filterCompetitorsWithoutBoat;
    private final Refresher<CompetitorDTO> competitorsRefresher;
    private final Refresher<BoatDTO> boatsRefresher;

    public CompetitorTableWrapper(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager, boolean filterCompetitorsWithBoat, boolean filterCompetitorsWithoutBoat) {
        super(sailingServiceWrite, stringMessages, errorReporter, multiSelection, enablePager, (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.competitorsRefresher = competitorsRefresher;
        this.boatsRefresher = boatsRefresher;
        this.filterCompetitorsWithBoat = filterCompetitorsWithBoat;
        this.filterCompetitorsWithoutBoat = filterCompetitorsWithoutBoat;
        ColumnSortEvent.ListHandler competitorColumnListHandler = this.getColumnSortHandler();
        2 competitorNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        competitorNameColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)competitorNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        4 competitorShortNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        competitorShortNameColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)competitorShortNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        6 boatClassColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatClassColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)boatClassColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        8 flagImageColumn = new /* Unavailable Anonymous Inner Class!! */;
        flagImageColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)flagImageColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        10 sailIdColumn = new /* Unavailable Anonymous Inner Class!! */;
        sailIdColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)sailIdColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        ColorColumn displayColorColumn = new ColorColumn((ColorColumn.ColorRetriever)new /* Unavailable Anonymous Inner Class!! */);
        13 imageColumn = new /* Unavailable Anonymous Inner Class!! */;
        imageColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)imageColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        15 competitorIdColumn = new /* Unavailable Anonymous Inner Class!! */;
        competitorIdColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)competitorIdColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        17 competitorEMailColumn = new /* Unavailable Anonymous Inner Class!! */;
        competitorEMailColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)competitorEMailColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        19 competitorSearchTagColumn = new /* Unavailable Anonymous Inner Class!! */;
        competitorSearchTagColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)competitorSearchTagColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        21 timeOnTimeFactorColumn = new /* Unavailable Anonymous Inner Class!! */;
        timeOnTimeFactorColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)timeOnTimeFactorColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        23 timeOnDistanceAllowancePerNauticalMileColumn = new /* Unavailable Anonymous Inner Class!! */;
        timeOnDistanceAllowancePerNauticalMileColumn.setSortable(true);
        competitorColumnListHandler.setComparator((Column)timeOnDistanceAllowancePerNauticalMileColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.filterField = new /* Unavailable Anonymous Inner Class!! */;
        this.filterField.setUpdatePermissionFilterForCheckbox(comp -> userService.hasPermission((SecuredDTO)comp, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        this.registerSelectionModelOnNewDataProvider(this.filterField.getAllListDataProvider());
        HasPermissions type = SecuredDomainType.COMPETITOR;
        AccessControlledActionsColumn competitorActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new CompetitorConfigImagesBarCell((StringMessages)this.getStringMessages()), (UserService)userService);
        competitorActionColumn.addAction(CompetitorConfigImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.editCompetitor(arg_0));
        competitorActionColumn.addAction("ACTION_REFRESH", arg_0 -> this.allowUpdate(arg_0));
        EditOwnershipDialog.DialogConfig editOwnerShipDialog = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)SecuredDomainType.COMPETITOR, competitorDTO -> this.getFilterField().filter(), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        competitorActionColumn.addAction(CompetitorConfigImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)editOwnerShipDialog).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, null, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        competitorActionColumn.addAction(CompetitorConfigImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        this.mainPanel.insert((Widget)this.filterField, 0);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)competitorColumnListHandler);
        this.table.addColumn((Column)competitorNameColumn, ((StringMessages)this.getStringMessages()).name());
        this.table.addColumn((Column)competitorShortNameColumn, stringMessages.shortName());
        this.table.addColumn((Column)flagImageColumn, stringMessages.flags());
        this.table.addColumn((Column)timeOnTimeFactorColumn, ((StringMessages)this.getStringMessages()).timeOnTimeFactor());
        this.table.addColumn((Column)timeOnDistanceAllowancePerNauticalMileColumn, ((StringMessages)this.getStringMessages()).timeOnDistanceAllowanceInSecondsPerNauticalMile());
        this.table.addColumn((Column)displayColorColumn, ((StringMessages)this.getStringMessages()).color());
        this.table.addColumn((Column)imageColumn, ((StringMessages)this.getStringMessages()).image());
        this.table.addColumn((Column)competitorEMailColumn, ((StringMessages)this.getStringMessages()).email());
        this.table.addColumn((Column)competitorSearchTagColumn, ((StringMessages)this.getStringMessages()).searchTag());
        this.table.addColumn((Column)competitorIdColumn, ((StringMessages)this.getStringMessages()).id());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.table, (ColumnSortEvent.ListHandler)this.getColumnSortHandler(), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        this.table.addColumn((Column)competitorActionColumn, ((StringMessages)this.getStringMessages()).actions());
        this.table.addColumn((Column)sailIdColumn, ((StringMessages)this.getStringMessages()).sailNumber());
        this.table.addColumn((Column)boatClassColumn, ((StringMessages)this.getStringMessages()).boatClass());
        this.table.ensureDebugId("CompetitorsTable");
    }

    public Iterable<CompetitorDTO> getAllCompetitors() {
        return this.filterField.getAll();
    }

    public LabeledAbstractFilterablePanel<CompetitorDTO> getFilterField() {
        return this.filterField;
    }

    public void refreshCompetitorList(Iterable<? extends CompetitorDTO> competitors) {
        this.getFilteredCompetitors(Util.filter(competitors, c -> !(c.hasBoat() && this.filterCompetitorsWithBoat || !c.hasBoat() && this.filterCompetitorsWithoutBoat)));
    }

    public void refreshCompetitorList(String leaderboardName) {
        this.refreshCompetitorList(leaderboardName, null);
    }

    public void refreshCompetitorList(String leaderboardName, Callback<Iterable<CompetitorDTO>, Throwable> callback) {
        26 myCallback = new /* Unavailable Anonymous Inner Class!! */;
        if (leaderboardName != null) {
            this.sailingServiceWrite.getCompetitorsOfLeaderboard(leaderboardName, (AsyncCallback)myCallback);
        } else if (this.competitorsRefresher != null) {
            this.competitorsRefresher.callFillAndReloadInitially(arg_0 -> CompetitorTableWrapper.lambda$7((AsyncCallback)myCallback, arg_0));
        } else {
            this.sailingServiceWrite.getCompetitors(this.filterCompetitorsWithBoat, this.filterCompetitorsWithoutBoat, (AsyncCallback)myCallback);
        }
    }

    private void getFilteredCompetitors(Iterable<? extends CompetitorDTO> result) {
        this.filterField.updateAll(result);
    }

    private void editCompetitor(CompetitorDTO competitor) {
        BoatClassDTO boatClass;
        String boatClassName = competitor.hasBoat() ? ((boatClass = ((CompetitorWithBoatDTO)competitor).getBoatClass()) != null ? boatClass.getName() : null) : null;
        if (boatClassName != null) {
            this.openEditCompetitorWithBoatDialog((CompetitorWithBoatDTO)competitor, boatClassName);
        } else {
            this.openEditCompetitorWithoutBoatDialog(competitor);
        }
    }

    void openEditCompetitorWithBoatDialog(CompetitorWithBoatDTO originalCompetitor, String boatClassName) {
        CompetitorWithBoatEditDialog dialog = new CompetitorWithBoatEditDialog((StringMessages)this.getStringMessages(), originalCompetitor, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, boatClassName);
        dialog.show();
    }

    void openCompetitorWithBoatAddDialog(CompetitorWithBoatDTO newCompetitor, boolean createWithBoatByDefault) {
        CompetitorWithOptionalBoatAddDialog dialog = new CompetitorWithOptionalBoatAddDialog((StringMessages)this.getStringMessages(), newCompetitor, createWithBoatByDefault, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    void openEditCompetitorWithoutBoatDialog(CompetitorDTO originalCompetitor) {
        CompetitorEditDialog dialog = CompetitorEditDialog.create((StringMessages)((StringMessages)this.getStringMessages()), (CompetitorDTO)originalCompetitor, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.show();
    }

    protected void allowUpdate(Iterable<CompetitorDTO> competitors) {
        ArrayList serializableSingletonList = new ArrayList();
        Util.addAll(competitors, serializableSingletonList);
        this.sailingServiceWrite.allowCompetitorResetToDefaults(serializableSingletonList, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void allowUpdate(CompetitorDTO competitor) {
        this.allowUpdate(Collections.singleton(competitor));
    }

    public void grayOutCompetitors(List<CompetitorWithToolTipDTO> competitors) {
        this.table.addCellPreviewHandler(event -> {
            for (CompetitorWithToolTipDTO competitor : competitors) {
                if (!competitor.getCompetitor().equals(event.getValue())) continue;
                this.table.getRowElement(event.getIndex()).setTitle(competitor.getToolTipMessage());
            }
        });
        this.table.setRowStyles((row, rowIndex) -> {
            for (CompetitorWithToolTipDTO competitor : competitors) {
                if (!competitor.getCompetitor().equals(row)) continue;
                return ((AdminConsoleTableResources)this.getTableRes()).cellTableStyle().cellTableDisabledRow();
            }
            return "";
        });
    }

    private <T extends CompetitorDTO> AsyncCallback<T> createAddCompetitorCallback() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ FlushableCellTable access$0(CompetitorTableWrapper competitorTableWrapper) {
        return competitorTableWrapper.table;
    }

    static /* synthetic */ ErrorReporter access$1(CompetitorTableWrapper competitorTableWrapper) {
        return competitorTableWrapper.errorReporter;
    }

    static /* synthetic */ void access$2(CompetitorTableWrapper competitorTableWrapper, Iterable iterable) {
        competitorTableWrapper.getFilteredCompetitors(iterable);
    }

    static /* synthetic */ Refresher access$3(CompetitorTableWrapper competitorTableWrapper) {
        return competitorTableWrapper.competitorsRefresher;
    }

    static /* synthetic */ Refresher access$4(CompetitorTableWrapper competitorTableWrapper) {
        return competitorTableWrapper.boatsRefresher;
    }

    static /* synthetic */ AsyncCallback access$5(CompetitorTableWrapper competitorTableWrapper) {
        return competitorTableWrapper.createAddCompetitorCallback();
    }

    static /* synthetic */ com.sap.sse.gwt.client.StringMessages access$6(CompetitorTableWrapper competitorTableWrapper) {
        return competitorTableWrapper.getStringMessages();
    }

    private static /* synthetic */ void lambda$7(AsyncCallback asyncCallback, Iterable competitors) {
        asyncCallback.onSuccess((Object)competitors);
    }
}

