/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.Callback;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithToolTipDTO;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorImportProviderSelectionDialog;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.ImportCompetitorCallback;
import com.sap.sailing.gwt.ui.adminconsole.RaceOrRegattaImportCompetitorCallback;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.controls.busyindicator.BusyDisplay;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class CompetitorRegistrationsPanel
extends FlowPanel
implements BusyDisplay {
    private final CompetitorTableWrapper<RefreshableMultiSelectionModel<CompetitorDTO>> allCompetitorsTable;
    private final CompetitorTableWrapper<RefreshableMultiSelectionModel<CompetitorDTO>> registeredCompetitorsTable;
    private final ErrorReporter errorReporter;
    private Button registerBtn;
    private Button unregisterBtn;
    private Button addCompetitorWithBoatButton;
    private Button addCompetitorButton;
    private CheckBox showOnlyCompetitorsOfLogCheckBox;
    private final String leaderboardName;
    private final BusyIndicator busyIndicator;
    private final ImportCompetitorCallback importCompetitorCallback;
    private final Runnable validator;
    private final Consumer<Util.Pair<CompetitorRegistrationsPanel, AsyncCallback<Collection<CompetitorDTO>>>> registeredCompetitorsRetriever;
    private final boolean restrictPoolToLeaderboard;

    protected CompetitorRegistrationsPanel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, boolean editable, String leaderboardName, boolean canBoatsOfCompetitorsChangePerRace, String boatClass, Runnable validator, Consumer<Util.Pair<CompetitorRegistrationsPanel, AsyncCallback<Collection<CompetitorDTO>>>> registeredCompetitorsRetriever, boolean restrictPoolToLeaderboard, Widget ... additionalWidgetsBeforeTables) {
        this.errorReporter = errorReporter;
        this.restrictPoolToLeaderboard = restrictPoolToLeaderboard;
        this.validator = validator;
        this.leaderboardName = leaderboardName;
        this.busyIndicator = new SimpleBusyIndicator();
        this.registeredCompetitorsRetriever = registeredCompetitorsRetriever;
        this.importCompetitorCallback = new RaceOrRegattaImportCompetitorCallback(this, sailingServiceWrite, errorReporter, stringMessages);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        this.addCompetitorButton = new Button(stringMessages.add(stringMessages.competitor()));
        this.addCompetitorButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addCompetitorWithBoatButton = new Button(stringMessages.add(stringMessages.competitorWithBoat()));
        this.addCompetitorWithBoatButton.ensureDebugId("addCompetitorWithBoatButton");
        this.addCompetitorWithBoatButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button inviteCompetitorsButton = new Button(stringMessages.inviteSelectedCompetitors());
        inviteCompetitorsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button competitorImportButton = new Button(stringMessages.importCompetitors());
        competitorImportButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel competitorRegistrationPanel = new HorizontalPanel();
        CaptionPanel allCompetitorsPanel = new CaptionPanel(stringMessages.competitorPool());
        CaptionPanel registeredCompetitorsPanel = new CaptionPanel(stringMessages.registeredCompetitors());
        this.allCompetitorsTable = new CompetitorTableWrapper(sailingServiceWrite, userService, competitorsRefresher, boatsRefresher, stringMessages, errorReporter, true, true, false, !canBoatsOfCompetitorsChangePerRace);
        this.registeredCompetitorsTable = new CompetitorTableWrapper(sailingServiceWrite, userService, competitorsRefresher, boatsRefresher, stringMessages, errorReporter, true, false, false, false);
        ((RefreshableMultiSelectionModel)this.registeredCompetitorsTable.getSelectionModel()).addSelectionChangeHandler(event -> this.validateAndUpdate());
        allCompetitorsPanel.add((IsWidget)this.allCompetitorsTable);
        registeredCompetitorsPanel.add((IsWidget)this.registeredCompetitorsTable);
        VerticalPanel movePanel = new VerticalPanel();
        this.registerBtn = new Button("<");
        this.unregisterBtn = new Button(">");
        this.registerBtn.setEnabled(editable);
        this.unregisterBtn.setEnabled(editable);
        movePanel.add((Widget)this.registerBtn);
        movePanel.add((Widget)this.unregisterBtn);
        this.registerBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.unregisterBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        competitorRegistrationPanel.add((Widget)registeredCompetitorsPanel);
        competitorRegistrationPanel.add((Widget)movePanel);
        competitorRegistrationPanel.setCellVerticalAlignment((Widget)movePanel, HasVerticalAlignment.ALIGN_MIDDLE);
        competitorRegistrationPanel.add((Widget)allCompetitorsPanel);
        if (canBoatsOfCompetitorsChangePerRace) {
            buttonPanel.add((Widget)this.addCompetitorButton);
        } else {
            buttonPanel.add((Widget)this.addCompetitorWithBoatButton);
        }
        buttonPanel.add((Widget)inviteCompetitorsButton);
        buttonPanel.add((Widget)competitorImportButton);
        buttonPanel.add((Widget)this.busyIndicator);
        this.add((Widget)buttonPanel);
        this.showOnlyCompetitorsOfLogCheckBox = new CheckBox(stringMessages.showOnlyCompetitorsOfLog());
        this.showOnlyCompetitorsOfLogCheckBox.setValue(Boolean.valueOf(false));
        this.showOnlyCompetitorsOfLogCheckBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)this.showOnlyCompetitorsOfLogCheckBox);
        if (additionalWidgetsBeforeTables != null) {
            Widget[] widgetArray = additionalWidgetsBeforeTables;
            int n = additionalWidgetsBeforeTables.length;
            int n2 = 0;
            while (n2 < n) {
                Widget additionalWidget = widgetArray[n2];
                this.add(additionalWidget);
                ++n2;
            }
        }
        this.add((Widget)competitorRegistrationPanel);
        this.refreshCompetitors();
    }

    private CompetitorImportProviderSelectionDialog.MatchImportedCompetitorsDialogFactory getMatchCompetitorsDialogFactory(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<CompetitorDTO> competitorsRefresher, Refresher<BoatDTO> boatsRefresher, StringMessages stringMessages, ErrorReporter errorReporter) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setBusy(boolean isBusy) {
        this.busyIndicator.setBusy(isBusy);
    }

    protected void move(CompetitorTableWrapper<?> from, CompetitorTableWrapper<?> to, Iterable<CompetitorDTO> toMove) {
        from.getFilterField().removeAll(toMove);
        to.getFilterField().addAll(toMove);
    }

    protected void addImportedCompetitorsToRegisteredCompetitorsTableAndRemoveFromAllCompetitorsTable(Iterable<CompetitorDTO> competitorsImported) {
        this.allCompetitorsTable.getFilterField().removeAll(competitorsImported);
        this.registeredCompetitorsTable.getFilterField().addAll(competitorsImported);
        this.validateAndUpdate();
    }

    private void moveSelected(CompetitorTableWrapper<RefreshableMultiSelectionModel<CompetitorDTO>> from, CompetitorTableWrapper<RefreshableMultiSelectionModel<CompetitorDTO>> to) {
        this.move(from, to, (Iterable)((RefreshableMultiSelectionModel)from.getSelectionModel()).getSelectedSet());
        this.validateAndUpdate();
    }

    protected boolean showOnlyCompetitorsOfLog() {
        return this.showOnlyCompetitorsOfLogCheckBox.getValue();
    }

    protected void refreshCompetitors() {
        this.registeredCompetitorsTable.getFilterField().removeAll();
        this.allCompetitorsTable.getFilterField().removeAll();
        this.setRegisterableCompetitorsAndRegisteredCompetitors();
    }

    private void setRegisterableCompetitorsAndRegisteredCompetitors() {
        this.allCompetitorsTable.refreshCompetitorList(this.restrictPoolToLeaderboard ? this.leaderboardName : null, (Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deactivateRegistrationButtons(String tooltip) {
        this.registerBtn.setEnabled(false);
        this.unregisterBtn.setEnabled(false);
        this.addCompetitorWithBoatButton.setEnabled(false);
        this.addCompetitorButton.setEnabled(false);
        this.registerBtn.setTitle(tooltip);
        this.unregisterBtn.setTitle(tooltip);
        this.addCompetitorWithBoatButton.setTitle(tooltip);
        this.addCompetitorButton.setTitle(tooltip);
        this.validateAndUpdate();
    }

    private void validateAndUpdate() {
        if (this.validator != null) {
            this.validator.run();
        }
    }

    public void activateRegistrationButtons() {
        this.registerBtn.setEnabled(true);
        this.unregisterBtn.setEnabled(true);
        this.addCompetitorWithBoatButton.setEnabled(true);
        this.addCompetitorButton.setEnabled(true);
        this.registerBtn.setTitle("");
        this.unregisterBtn.setTitle("");
        this.addCompetitorWithBoatButton.setTitle("");
        this.addCompetitorButton.setTitle("");
        this.validateAndUpdate();
    }

    public Set<CompetitorDTO> getResult() {
        HashSet<CompetitorDTO> registeredCompetitors = new HashSet<CompetitorDTO>();
        Util.addAll((Iterable)this.registeredCompetitorsTable.getAllCompetitors(), registeredCompetitors);
        return registeredCompetitors;
    }

    public void grayOutCompetitorsFromRegistered(List<CompetitorWithToolTipDTO> competitors) {
        this.registeredCompetitorsTable.grayOutCompetitors(competitors);
    }

    public void grayOutCompetitorsFromPool(List<CompetitorWithToolTipDTO> competitors) {
        this.allCompetitorsTable.grayOutCompetitors(competitors);
    }

    public void moveFromPoolToRegistered(Collection<CompetitorDTO> registeredCompetitors) {
        this.move(this.allCompetitorsTable, this.registeredCompetitorsTable, registeredCompetitors);
    }

    public Set<CompetitorDTO> getSelectedRegisteredCompetitors() {
        return ((RefreshableMultiSelectionModel)this.registeredCompetitorsTable.getSelectionModel()).getSelectedSet();
    }

    static /* synthetic */ CompetitorTableWrapper access$0(CompetitorRegistrationsPanel competitorRegistrationsPanel) {
        return competitorRegistrationsPanel.registeredCompetitorsTable;
    }

    static /* synthetic */ CompetitorImportProviderSelectionDialog.MatchImportedCompetitorsDialogFactory access$1(CompetitorRegistrationsPanel competitorRegistrationsPanel, SailingServiceWriteAsync sailingServiceWriteAsync, UserService userService, Refresher refresher, Refresher refresher2, StringMessages stringMessages, ErrorReporter errorReporter) {
        return competitorRegistrationsPanel.getMatchCompetitorsDialogFactory(sailingServiceWriteAsync, userService, refresher, refresher2, stringMessages, errorReporter);
    }

    static /* synthetic */ CompetitorTableWrapper access$2(CompetitorRegistrationsPanel competitorRegistrationsPanel) {
        return competitorRegistrationsPanel.allCompetitorsTable;
    }

    static /* synthetic */ void access$3(CompetitorRegistrationsPanel competitorRegistrationsPanel, CompetitorTableWrapper competitorTableWrapper, CompetitorTableWrapper competitorTableWrapper2) {
        competitorRegistrationsPanel.moveSelected(competitorTableWrapper, competitorTableWrapper2);
    }

    static /* synthetic */ CheckBox access$4(CompetitorRegistrationsPanel competitorRegistrationsPanel) {
        return competitorRegistrationsPanel.showOnlyCompetitorsOfLogCheckBox;
    }

    static /* synthetic */ ImportCompetitorCallback access$5(CompetitorRegistrationsPanel competitorRegistrationsPanel) {
        return competitorRegistrationsPanel.importCompetitorCallback;
    }

    static /* synthetic */ Consumer access$6(CompetitorRegistrationsPanel competitorRegistrationsPanel) {
        return competitorRegistrationsPanel.registeredCompetitorsRetriever;
    }

    static /* synthetic */ void access$7(CompetitorRegistrationsPanel competitorRegistrationsPanel) {
        competitorRegistrationsPanel.validateAndUpdate();
    }

    static /* synthetic */ ErrorReporter access$8(CompetitorRegistrationsPanel competitorRegistrationsPanel) {
        return competitorRegistrationsPanel.errorReporter;
    }
}

