/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.Callback;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.adminconsole.BoatTableWrapper;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.controls.busyindicator.BusyDisplay;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class BoatRegistrationsPanel
extends FlowPanel
implements BusyDisplay {
    private final BoatTableWrapper<RefreshableMultiSelectionModel<BoatDTO>> allBoatsTable;
    private final BoatTableWrapper<RefreshableMultiSelectionModel<BoatDTO>> registeredBoatsTable;
    private final ErrorReporter errorReporter;
    private Button registerBtn;
    private Button unregisterBtn;
    private Button addBoatButton;
    private CheckBox showOnlyBoatsOfLogCheckBox;
    private final BusyIndicator busyIndicator;
    private final Runnable validator;
    private final Consumer<AsyncCallback<Collection<BoatDTO>>> registeredBoatsRetriever;

    protected BoatRegistrationsPanel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, Refresher<BoatDTO> boatsRefresher, Refresher<CompetitorDTO> competitorsRefresher, StringMessages stringMessages, ErrorReporter errorReporter, boolean editable, String leaderboardName, boolean canBoatsOfCompetitorsChangePerRace, String boatClass, Runnable validator, Consumer<AsyncCallback<Collection<BoatDTO>>> registeredBoatsRetriever, boolean restrictPoolToLeaderboard) {
        this.errorReporter = errorReporter;
        this.validator = validator;
        this.busyIndicator = new SimpleBusyIndicator();
        this.registeredBoatsRetriever = registeredBoatsRetriever;
        HorizontalPanel buttonPanel = new HorizontalPanel();
        this.addBoatButton = new Button(stringMessages.add(stringMessages.boat()));
        this.addBoatButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel boatRegistrationPanel = new HorizontalPanel();
        CaptionPanel allBoatsPanel = new CaptionPanel(stringMessages.boatPool());
        CaptionPanel registeredBoatsPanel = new CaptionPanel(stringMessages.registeredBoats());
        this.allBoatsTable = new BoatTableWrapper(sailingServiceWrite, userService, boatsRefresher, competitorsRefresher, stringMessages, errorReporter, true, true, 20, false);
        this.registeredBoatsTable = new BoatTableWrapper(sailingServiceWrite, userService, null, null, stringMessages, errorReporter, true, false, 20, false);
        allBoatsPanel.add((IsWidget)this.allBoatsTable);
        registeredBoatsPanel.add((IsWidget)this.registeredBoatsTable);
        VerticalPanel movePanel = new VerticalPanel();
        this.registerBtn = new Button("<");
        this.unregisterBtn = new Button(">");
        this.registerBtn.setEnabled(editable);
        this.unregisterBtn.setEnabled(editable);
        movePanel.add((Widget)this.registerBtn);
        movePanel.add((Widget)this.unregisterBtn);
        this.registerBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.unregisterBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        boatRegistrationPanel.add((Widget)registeredBoatsPanel);
        boatRegistrationPanel.add((Widget)movePanel);
        boatRegistrationPanel.setCellVerticalAlignment((Widget)movePanel, HasVerticalAlignment.ALIGN_MIDDLE);
        boatRegistrationPanel.add((Widget)allBoatsPanel);
        buttonPanel.add((Widget)this.addBoatButton);
        buttonPanel.add((Widget)this.busyIndicator);
        this.add((Widget)buttonPanel);
        this.showOnlyBoatsOfLogCheckBox = new CheckBox(stringMessages.showOnlyBoatsOfLog());
        this.showOnlyBoatsOfLogCheckBox.setValue(Boolean.valueOf(false));
        this.showOnlyBoatsOfLogCheckBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Widget)this.showOnlyBoatsOfLogCheckBox);
        this.add((Widget)boatRegistrationPanel);
        this.refreshBoats();
    }

    public void setBusy(boolean isBusy) {
        this.busyIndicator.setBusy(isBusy);
    }

    protected void move(BoatTableWrapper<?> from, BoatTableWrapper<?> to, Iterable<BoatDTO> toMove) {
        from.getFilterField().removeAll(toMove);
        to.getFilterField().addAll(toMove);
    }

    private void moveSelected(BoatTableWrapper<RefreshableMultiSelectionModel<BoatDTO>> from, BoatTableWrapper<RefreshableMultiSelectionModel<BoatDTO>> to) {
        this.move(from, to, (Iterable)((RefreshableMultiSelectionModel)from.getSelectionModel()).getSelectedSet());
        this.validateAndUpdate();
    }

    protected boolean showOnlyBoatsOfLog() {
        return this.showOnlyBoatsOfLogCheckBox.getValue();
    }

    protected void refreshBoats() {
        this.registeredBoatsTable.getFilterField().removeAll();
        this.allBoatsTable.getFilterField().removeAll();
        this.setRegisterableBoatsAndRegisteredBoats();
    }

    private void setRegisterableBoatsAndRegisteredBoats() {
        this.allBoatsTable.refreshBoatList(true, (Callback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deactivateRegistrationButtons(String tooltip) {
        this.registerBtn.setEnabled(false);
        this.unregisterBtn.setEnabled(false);
        this.addBoatButton.setEnabled(false);
        this.registerBtn.setTitle(tooltip);
        this.unregisterBtn.setTitle(tooltip);
        this.addBoatButton.setTitle(tooltip);
        this.validateAndUpdate();
    }

    private void validateAndUpdate() {
        if (this.validator != null) {
            this.validator.run();
        }
    }

    public void activateRegistrationButtons() {
        this.registerBtn.setEnabled(true);
        this.unregisterBtn.setEnabled(true);
        this.addBoatButton.setEnabled(true);
        this.registerBtn.setTitle("");
        this.unregisterBtn.setTitle("");
        this.addBoatButton.setTitle("");
        this.validateAndUpdate();
    }

    public Set<BoatDTO> getResult() {
        HashSet<BoatDTO> registeredBoats = new HashSet<BoatDTO>();
        Util.addAll((Iterable)this.registeredBoatsTable.getAllBoats(), registeredBoats);
        return registeredBoats;
    }

    public void grayOutCompetitorsFromRegistered(List<BoatDTO> boats) {
    }

    public void grayOutCompetitorsFromPool(List<BoatDTO> competitors) {
    }

    public void moveFromPoolToRegistered(Collection<BoatDTO> registeredBoats) {
        this.move(this.allBoatsTable, this.registeredBoatsTable, registeredBoats);
    }

    static /* synthetic */ BoatTableWrapper access$0(BoatRegistrationsPanel boatRegistrationsPanel) {
        return boatRegistrationsPanel.registeredBoatsTable;
    }

    static /* synthetic */ BoatTableWrapper access$1(BoatRegistrationsPanel boatRegistrationsPanel) {
        return boatRegistrationsPanel.allBoatsTable;
    }

    static /* synthetic */ void access$2(BoatRegistrationsPanel boatRegistrationsPanel, BoatTableWrapper boatTableWrapper, BoatTableWrapper boatTableWrapper2) {
        boatRegistrationsPanel.moveSelected(boatTableWrapper, boatTableWrapper2);
    }

    static /* synthetic */ CheckBox access$3(BoatRegistrationsPanel boatRegistrationsPanel) {
        return boatRegistrationsPanel.showOnlyBoatsOfLogCheckBox;
    }

    static /* synthetic */ Consumer access$4(BoatRegistrationsPanel boatRegistrationsPanel) {
        return boatRegistrationsPanel.registeredBoatsRetriever;
    }

    static /* synthetic */ void access$5(BoatRegistrationsPanel boatRegistrationsPanel) {
        boatRegistrationsPanel.validateAndUpdate();
    }

    static /* synthetic */ ErrorReporter access$6(BoatRegistrationsPanel boatRegistrationsPanel) {
        return boatRegistrationsPanel.errorReporter;
    }
}

