/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractTrackedRacesListComposite;
import com.sap.sailing.gwt.ui.adminconsole.EventConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.RegattaConfigImagesBarCell;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRaceChangedListener;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRacesSettings;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRacesSettingsDialogComponent;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRacesTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.Refresher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.panels.CustomizableFilterablePanel;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractTrackedRacesListComposite
extends AbstractCompositeComponent<TrackedRacesSettings> {
    protected final long DEFAULT_LIVE_DELAY_IN_MILLISECONDS = 5000L;
    private final boolean multiSelection;
    protected RefreshableSelectionModel<RaceDTO> refreshableSelectionModel;
    protected final Set<TrackedRaceChangedListener> raceIsTrackedRaceChangeListener;
    protected CellTable<RaceDTO> raceTable;
    private ListDataProvider<RaceDTO> raceList;
    private Iterable<RaceDTO> allRaces;
    private Label noTrackedRacesLabel;
    protected final SailingServiceWriteAsync sailingService;
    protected final ErrorReporter errorReporter;
    protected final Refresher<RegattaDTO> regattaRefresher;
    protected final StringMessages stringMessages;
    private Button btnRefresh;
    protected CustomizableFilterablePanel<RaceDTO> filterablePanelRaces;
    protected TrackedRacesSettings settings;
    private ListBox listBoxRegattas;
    protected final UserService userService;
    private final Displayer<RegattaDTO> regattasDisplayer = result -> this.fillRegattas(result);

    public AbstractTrackedRacesListComposite(Component<?> parent, ComponentContext<?> context, AdminConsoleView.Presenter presenter, StringMessages stringMessages, boolean hasMultiSelection) {
        super(parent, context);
        this.raceIsTrackedRaceChangeListener = new HashSet();
        this.sailingService = presenter.getSailingService();
        this.errorReporter = presenter.getErrorReporter();
        this.regattaRefresher = presenter.getRegattasRefresher();
        this.multiSelection = hasMultiSelection;
        this.stringMessages = stringMessages;
        this.userService = presenter.getUserService();
    }

    public void setRegattaFilterValue(String regattaName) {
        int i = 0;
        while (i < this.listBoxRegattas.getItemCount()) {
            if (this.listBoxRegattas.getValue(i).equals(regattaName)) {
                this.listBoxRegattas.setSelectedIndex(i);
                DomEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)this.listBoxRegattas);
                return;
            }
            ++i;
        }
        if (this.listBoxRegattas.getItemCount() > 0) {
            this.listBoxRegattas.setSelectedIndex(0);
            DomEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)this.listBoxRegattas);
        }
    }

    protected void createUI() {
        this.settings = new TrackedRacesSettings();
        this.settings.setDelayToLiveInSeconds(5L);
        VerticalPanel panel = new VerticalPanel();
        this.initWidget((Widget)panel);
        HorizontalPanel filterPanel = new HorizontalPanel();
        panel.add((Widget)filterPanel);
        this.noTrackedRacesLabel = new Label(this.stringMessages.noRacesYet());
        this.noTrackedRacesLabel.setWordWrap(false);
        panel.add((Widget)this.noTrackedRacesLabel);
        TrackedRacesTableWrapper raceTableWrapper = new TrackedRacesTableWrapper(this.sailingService, this.stringMessages, this.errorReporter, this.multiSelection, true);
        this.raceTable = raceTableWrapper.getTable();
        this.raceTable.setPageSize(1000);
        this.raceTable.ensureDebugId("TrackedRacesCellTable");
        Label lblFilterRaces = new Label(String.valueOf(this.stringMessages.filterRaces()) + ":");
        lblFilterRaces.setWordWrap(false);
        lblFilterRaces.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        lblFilterRaces.getElement().getStyle().setMarginRight(10.0, Style.Unit.PX);
        filterPanel.add((Widget)lblFilterRaces);
        filterPanel.setCellVerticalAlignment((Widget)lblFilterRaces, HasVerticalAlignment.ALIGN_MIDDLE);
        this.raceList = raceTableWrapper.getDataProvider();
        this.filterablePanelRaces = new /* Unavailable Anonymous Inner Class!! */;
        raceTableWrapper.registerSelectionModelOnNewDataProvider(this.filterablePanelRaces.getAllListDataProvider());
        Label lblFilterByRegatta = new Label(this.stringMessages.filterByRegatta());
        lblFilterByRegatta.setWordWrap(false);
        this.listBoxRegattas = new ListBox();
        this.listBoxRegattas.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.filterablePanelRaces.add(lblFilterByRegatta, (Widget)this.listBoxRegattas, (Filter)new /* Unavailable Anonymous Inner Class!! */);
        Label lblFilterRacesByName = new Label(String.valueOf(this.stringMessages.filterByNameOrBoatClass()) + ":");
        lblFilterRacesByName.setWordWrap(false);
        this.filterablePanelRaces.add((Widget)lblFilterRacesByName);
        this.filterablePanelRaces.addDefaultTextBox();
        this.filterablePanelRaces.getTextBox().ensureDebugId("TrackedRacesFilterTextBox");
        filterPanel.add((Widget)this.filterablePanelRaces);
        filterPanel.setCellVerticalAlignment((Widget)this.filterablePanelRaces, HasVerticalAlignment.ALIGN_MIDDLE);
        this.filterablePanelRaces.setUpdatePermissionFilterForCheckbox(race -> this.userService.hasPermission((SecuredDTO)race, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        this.refreshableSelectionModel = raceTableWrapper.getSelectionModel();
        this.setupTableColumns(this.stringMessages, raceTableWrapper.getColumnSortHandler());
        this.raceTable.setWidth("100%");
        this.raceTable.setVisible(false);
        panel.add((IsWidget)raceTableWrapper);
        this.refreshableSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel trackedRacesButtonPanel = new HorizontalPanel();
        trackedRacesButtonPanel.setSpacing(10);
        panel.add((Widget)trackedRacesButtonPanel);
        this.btnRefresh = new Button(this.stringMessages.refresh());
        this.btnRefresh.ensureDebugId("RefreshButton");
        this.btnRefresh.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        trackedRacesButtonPanel.add((Widget)this.btnRefresh);
        this.addControlButtons(trackedRacesButtonPanel);
    }

    protected abstract void makeControlsReactToSelectionChange(Set<RaceDTO> var1);

    protected abstract void makeControlsReactToFillRegattas(Iterable<RegattaDTO> var1);

    protected abstract void addControlButtons(HorizontalPanel var1);

    private void setupTableColumns(StringMessages stringMessages, ColumnSortEvent.ListHandler<RaceDTO> columnSortHandler) {
        6 regattaNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        regattaNameColumn.setSortable(true);
        columnSortHandler.setComparator((Column)regattaNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        8 boatClassNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatClassNameColumn.setSortable(true);
        columnSortHandler.setComparator((Column)boatClassNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        AnchorCell anchorCell = new AnchorCell();
        10 raceNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceNameColumn.setSortable(true);
        columnSortHandler.setComparator((Column)raceNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        12 raceStartColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceStartColumn.setSortable(true);
        columnSortHandler.setComparator((Column)raceStartColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        14 hasWindDataColumn = new /* Unavailable Anonymous Inner Class!! */;
        hasWindDataColumn.setSortable(true);
        columnSortHandler.setComparator((Column)hasWindDataColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        16 hasGPSDataColumn = new /* Unavailable Anonymous Inner Class!! */;
        hasGPSDataColumn.setSortable(true);
        columnSortHandler.setComparator((Column)hasGPSDataColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        18 raceStatusColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceStatusColumn.setSortable(true);
        columnSortHandler.setComparator((Column)raceStatusColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        20 raceLiveDelayColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceLiveDelayColumn.setSortable(true);
        columnSortHandler.setComparator((Column)raceLiveDelayColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.raceTable.addColumn((Column)regattaNameColumn, stringMessages.regatta());
        this.raceTable.addColumn((Column)boatClassNameColumn, stringMessages.boatClass());
        this.raceTable.addColumn((Column)raceNameColumn, stringMessages.race());
        this.raceTable.addColumn((Column)raceStartColumn, stringMessages.startTime());
        this.raceTable.addColumn((Column)hasWindDataColumn, stringMessages.windData());
        this.raceTable.addColumn((Column)hasGPSDataColumn, stringMessages.gpsData());
        this.raceTable.addColumn((Column)raceStatusColumn, stringMessages.status());
        this.raceTable.addColumn((Column)raceLiveDelayColumn, stringMessages.delayInSeconds());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.raceTable, columnSortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        HasPermissions type = SecuredDomainType.TRACKED_RACE;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new RegattaConfigImagesBarCell(stringMessages), (UserService)this.userService);
        EditOwnershipDialog.DialogConfig config = EditOwnershipDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)type, race -> {}, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        actionsColumn.addAction(EventConfigImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)config).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)this.userService.getUserManagementWriteService(), (HasPermissions)type, regatta -> {}, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        actionsColumn.addAction(RegattaConfigImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        actionsColumn.addAction(RegattaConfigImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, arg_0 -> this.removeAndUntrackRace(arg_0));
        actionsColumn.addAction("ACTION_STOP_TRACKING", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.stopTrackingRace(arg_0));
        this.raceTable.addColumn((Column)actionsColumn, stringMessages.actions());
    }

    private void removeAndUntrackRace(RaceDTO race) {
        RegattaNameAndRaceName name = (RegattaNameAndRaceName)race.getRaceIdentifier();
        this.sailingService.removeAndUntrackRaces(Arrays.asList(name), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    void stopTrackingRace(RaceDTO race) {
        RegattaAndRaceIdentifier raceIdentifier = race.getRaceIdentifier();
        this.sailingService.stopTrackingRaces(Arrays.asList(raceIdentifier), (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public boolean hasSettings() {
        return true;
    }

    public SettingsDialogComponent<TrackedRacesSettings> getSettingsDialogComponent(TrackedRacesSettings settings) {
        return new TrackedRacesSettingsDialogComponent(settings, this.stringMessages);
    }

    public void updateSettings(TrackedRacesSettings newSettings) {
        this.settings.setDelayToLiveInSeconds(newSettings.getDelayToLiveInSeconds());
        ArrayList<RegattaAndRaceIdentifier> raceIdentifiersToUpdate = new ArrayList<RegattaAndRaceIdentifier>();
        for (RaceDTO raceDTO : this.refreshableSelectionModel.getSelectedSet()) {
            raceIdentifiersToUpdate.add(raceDTO.getRaceIdentifier());
        }
        if (raceIdentifiersToUpdate != null && !raceIdentifiersToUpdate.isEmpty()) {
            this.sailingService.updateRacesDelayToLive(raceIdentifiersToUpdate, this.settings.getDelayToLiveInSeconds() * 1000L, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    public String getLocalizedShortName() {
        return this.stringMessages.trackedRaces();
    }

    public Widget getEntryWidget() {
        return this;
    }

    public void addRaceSelectionChangeHandler(SelectionChangeEvent.Handler handler) {
        this.refreshableSelectionModel.addSelectionChangeHandler(handler);
    }

    public RaceDTO getRaceByIdentifier(RaceIdentifier raceIdentifier) {
        RaceDTO result = null;
        if (this.raceList != null) {
            for (RaceDTO race : this.raceList.getList()) {
                if (!race.getRaceIdentifier().equals(raceIdentifier)) continue;
                result = race;
                break;
            }
        }
        return result;
    }

    public void selectRaceByIdentifier(RegattaAndRaceIdentifier raceIdentifier) {
        if (this.allRaces != null) {
            for (RaceDTO race : this.allRaces) {
                String regattaName = race.getRegattaName();
                if (!regattaName.equals(raceIdentifier.getRegattaName()) || !race.getName().equals(raceIdentifier.getRaceName())) continue;
                this.refreshableSelectionModel.setSelected((Object)race, true);
                break;
            }
        }
    }

    public void clearSelection() {
        this.refreshableSelectionModel.clear();
    }

    public Displayer<RegattaDTO> getRegattasDisplayer() {
        return this.regattasDisplayer;
    }

    public void fillRegattas(Iterable<RegattaDTO> regattas) {
        this.makeControlsReactToFillRegattas(regattas);
        this.displayRaceTableUI(regattas);
        ArrayList<RaceDTO> newAllRaces = new ArrayList<RaceDTO>();
        ArrayList<String> regattaNames = new ArrayList<String>();
        for (RegattaDTO regatta : regattas) {
            for (RaceDTO race : regatta.races) {
                if (race == null || !this.raceIsToBeAddedToList(race)) continue;
                if (!regattaNames.contains(regatta.getName())) {
                    regattaNames.add(regatta.getName());
                }
                newAllRaces.add(race);
            }
        }
        this.refreshListBoxRegattas(regattaNames);
        this.allRaces = newAllRaces;
        this.filterablePanelRaces.updateAll(this.allRaces);
    }

    private void refreshListBoxRegattas(List<String> regattaNames) {
        String lastSelectedRegattaName = this.listBoxRegattas.getSelectedValue();
        this.listBoxRegattas.clear();
        this.listBoxRegattas.addItem(this.stringMessages.all(), "");
        regattaNames.stream().sorted().forEach(regatta -> this.listBoxRegattas.addItem(regatta, regatta));
        this.restoreListBoxRegattasSelection(lastSelectedRegattaName);
    }

    private void restoreListBoxRegattasSelection(String lastSelectedRegattaName) {
        int i = 0;
        while (i < this.listBoxRegattas.getItemCount()) {
            if (this.listBoxRegattas.getValue(i).equals(lastSelectedRegattaName)) {
                this.listBoxRegattas.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    private void displayRaceTableUI(Iterable<RegattaDTO> regattas) {
        if (Util.isEmpty(regattas)) {
            this.hideRaceTable();
        } else {
            this.showRaceTable();
        }
    }

    private void showRaceTable() {
        this.raceTable.setVisible(true);
        this.noTrackedRacesLabel.setVisible(false);
    }

    private void hideRaceTable() {
        this.raceTable.setVisible(false);
        this.noTrackedRacesLabel.setVisible(true);
    }

    protected boolean raceIsToBeAddedToList(RaceDTO race) {
        return true;
    }

    public RefreshableSelectionModel<RaceDTO> getSelectionModel() {
        return this.refreshableSelectionModel;
    }

    static /* synthetic */ ListBox access$2(AbstractTrackedRacesListComposite abstractTrackedRacesListComposite) {
        return abstractTrackedRacesListComposite.listBoxRegattas;
    }
}

