/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.server;

import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.gwt.home.communication.start.StageEventType;
import com.sap.sailing.gwt.server.EventHolder;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class FeaturedEventsComparator
implements Comparator<Util.Pair<StageEventType, EventHolder>> {
    private static final Duration LONG_RUNNING_EVENT_DURATION_THRESHOLD = Duration.ONE_WEEK.times(2L);
    private final TimePoint now = MillisecondsTimePoint.now();
    private final Random randomizer = new Random();
    private final Map<EventBase, Integer> randomizedEvents = new HashMap();

    @Override
    public int compare(Util.Pair<StageEventType, EventHolder> eventAndStageType1, Util.Pair<StageEventType, EventHolder> eventAndStageType2) {
        EventBase event1 = ((EventHolder)eventAndStageType1.getB()).event;
        EventBase event2 = ((EventHolder)eventAndStageType2.getB()).event;
        TimeRangeImpl event1Range = new TimeRangeImpl(event1.getStartDate(), event1.getEndDate());
        TimeRangeImpl event2Range = new TimeRangeImpl(event2.getStartDate(), event2.getEndDate());
        boolean event1IsLongRunning = event1Range.getDuration().compareTo((Object)LONG_RUNNING_EVENT_DURATION_THRESHOLD) > 0;
        boolean event2IsLongRunning = event2Range.getDuration().compareTo((Object)LONG_RUNNING_EVENT_DURATION_THRESHOLD) > 0;
        int timeDiffComp = event1IsLongRunning || event2IsLongRunning ? 0 : event1Range.timeDifference(this.now).compareTo((Object)event2Range.timeDifference(this.now));
        return timeDiffComp == 0 ? this.getRandomValue(event1) - this.getRandomValue(event2) : timeDiffComp;
    }

    private int getRandomValue(EventBase event) {
        Integer randomValue = (Integer)this.randomizedEvents.get(event);
        if (randomValue == null) {
            randomValue = this.randomizer.nextInt();
            this.randomizedEvents.put(event, randomValue);
        }
        return randomValue;
    }
}

