/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.regattaoverview.client;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.gwt.settings.client.regattaoverview.RegattaRaceStatesSettings;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RaceGroupDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class RegattaRaceStatesSettingsDialogComponent
implements SettingsDialogComponent<RegattaRaceStatesSettings> {
    private final StringMessages stringMessages;
    private final RegattaRaceStatesSettings initialSettings;
    private final List<CourseAreaDTO> courseAreas;
    private final List<RaceGroupDTO> raceGroups;
    private CheckBox showOnlyRacesOfSameDayCheckBox;
    private CheckBox showOnlyCurrentlyRunningRacesCheckBox;
    private final Map<UUID, CheckBox> courseAreaCheckBoxMap;
    private final Map<String, CheckBox> regattaCheckBoxMap;
    private Button courseAreaDeselectButton;
    private Button regattaDeselectButton;
    private static final String SETTINGS_DIALOG_COMPONENT = "SettingsDialogComponent";

    public RegattaRaceStatesSettingsDialogComponent(RegattaRaceStatesSettings settings, StringMessages stringMessages, List<CourseAreaDTO> courseAreas, List<RaceGroupDTO> raceGroups) {
        this.stringMessages = stringMessages;
        this.initialSettings = settings;
        this.courseAreas = courseAreas;
        this.raceGroups = raceGroups;
        this.courseAreaCheckBoxMap = new HashMap();
        this.regattaCheckBoxMap = new HashMap();
    }

    private FlowPanel fillCourseAreaWidget(DataEntryDialog<?> dialog) {
        FlowPanel flowPanel = new FlowPanel();
        flowPanel.ensureDebugId("CourseAreaPanel");
        flowPanel.addStyleName(SETTINGS_DIALOG_COMPONENT);
        flowPanel.add((Widget)dialog.createHeadline(this.stringMessages.showFollowingCourseAreas(), true));
        FlowPanel courseAreaPanel = new FlowPanel();
        flowPanel.add((Widget)courseAreaPanel);
        int maxCourseAreasPerRow = 4;
        int numberOfCourseAreas = this.courseAreas.size();
        int numberOfRequiredRows = numberOfCourseAreas / maxCourseAreasPerRow;
        if (numberOfCourseAreas % maxCourseAreasPerRow != 0) {
            ++numberOfRequiredRows;
        }
        int rowIndex = 0;
        int columnIndex = 0;
        Grid courseAreaGrid = new Grid(numberOfRequiredRows, maxCourseAreasPerRow);
        courseAreaPanel.add((Widget)courseAreaGrid);
        boolean allCheckboxesSelected = true;
        for (CourseAreaDTO courseAreaDTO : this.courseAreas) {
            CheckBox checkBox = dialog.createCheckbox(courseAreaDTO.getName());
            boolean isCourseAreaVisible = Util.contains((Iterable)this.initialSettings.getVisibleCourseAreas(), (Object)courseAreaDTO.getId());
            allCheckboxesSelected &= isCourseAreaVisible;
            checkBox.setValue(Boolean.valueOf(isCourseAreaVisible));
            this.courseAreaCheckBoxMap.put(courseAreaDTO.getId(), checkBox);
            courseAreaGrid.setWidget(rowIndex, columnIndex++, (Widget)checkBox);
            if (columnIndex != maxCourseAreasPerRow) continue;
            ++rowIndex;
            columnIndex = 0;
        }
        this.courseAreaDeselectButton = new Button();
        this.courseAreaDeselectButton.addStyleName("btn-secondary");
        this.setTextOfDeselectButton(this.courseAreaDeselectButton, allCheckboxesSelected);
        this.courseAreaDeselectButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        flowPanel.add((Widget)this.courseAreaDeselectButton);
        return flowPanel;
    }

    private FlowPanel fillRegattaNamesWidget(DataEntryDialog<?> dialog) {
        FlowPanel flowPanel = new FlowPanel();
        flowPanel.ensureDebugId("RegattaNamesPanel");
        flowPanel.addStyleName(SETTINGS_DIALOG_COMPONENT);
        flowPanel.add((Widget)dialog.createHeadline(this.stringMessages.showFollowingRegattas(), true));
        FlowPanel regattaNamesPanel = new FlowPanel();
        flowPanel.add((Widget)regattaNamesPanel);
        int maxRegattasPerRow = 4;
        int numberOfRegattas = this.raceGroups.size();
        int numberOfRequiredRows = numberOfRegattas / maxRegattasPerRow;
        if (numberOfRegattas % maxRegattasPerRow != 0) {
            ++numberOfRequiredRows;
        }
        int rowIndex = 0;
        int columnIndex = 0;
        Grid regattaGrid = new Grid(numberOfRequiredRows, maxRegattasPerRow);
        regattaNamesPanel.add((Widget)regattaGrid);
        boolean allCheckboxesSelected = true;
        for (RaceGroupDTO raceGroup : this.raceGroups) {
            CheckBox checkBox = dialog.createCheckbox(raceGroup.displayName);
            boolean isRaceGroupVisible = Util.contains((Iterable)this.initialSettings.getVisibleRegattas(), (Object)raceGroup.getName());
            allCheckboxesSelected &= isRaceGroupVisible;
            checkBox.setValue(Boolean.valueOf(isRaceGroupVisible));
            this.regattaCheckBoxMap.put(raceGroup.getName(), checkBox);
            regattaGrid.setWidget(rowIndex, columnIndex++, (Widget)checkBox);
            if (columnIndex != maxRegattasPerRow) continue;
            ++rowIndex;
            columnIndex = 0;
        }
        this.regattaDeselectButton = new Button();
        this.regattaDeselectButton.addStyleName("btn-secondary");
        this.setTextOfDeselectButton(this.regattaDeselectButton, allCheckboxesSelected);
        this.regattaDeselectButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        flowPanel.add((Widget)this.regattaDeselectButton);
        return flowPanel;
    }

    private void setTextOfDeselectButton(Button deselectButton, boolean allCheckboxesSelected) {
        if (allCheckboxesSelected) {
            deselectButton.setText(this.stringMessages.deselectAll());
        } else {
            deselectButton.setText(this.stringMessages.selectAll());
        }
    }

    private CheckBox getShowOnlyRacesOfSameDayWidget(DataEntryDialog<?> dialog) {
        this.showOnlyRacesOfSameDayCheckBox = dialog.createCheckbox(this.stringMessages.showOnlyRacesOfSameDay());
        this.showOnlyRacesOfSameDayCheckBox.ensureDebugId("ShowOnlyRacesOfSameDayCheckBox");
        this.showOnlyRacesOfSameDayCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowOnlyRacesOfSameDay()));
        return this.showOnlyRacesOfSameDayCheckBox;
    }

    private CheckBox getShowOnlyCurrentlyRunningRacesWidget(DataEntryDialog<?> dialog) {
        this.showOnlyCurrentlyRunningRacesCheckBox = dialog.createCheckbox(this.stringMessages.showOnlyCurrentlyRunningRaces());
        this.showOnlyCurrentlyRunningRacesCheckBox.ensureDebugId("ShowOnlyCurrentlyRunningRacesCheckBox");
        this.showOnlyCurrentlyRunningRacesCheckBox.setValue(Boolean.valueOf(this.initialSettings.isShowOnlyCurrentlyRunningRaces()));
        return this.showOnlyCurrentlyRunningRacesCheckBox;
    }

    private Widget getAdditionalSettingsWidget(DataEntryDialog<?> dialog) {
        FlowPanel flowPanel = new FlowPanel();
        flowPanel.addStyleName(SETTINGS_DIALOG_COMPONENT);
        flowPanel.add((Widget)dialog.createHeadline(this.stringMessages.additionalSettings(), true));
        FlowPanel additionalSettingsPanel = new FlowPanel();
        flowPanel.add((Widget)additionalSettingsPanel);
        additionalSettingsPanel.add((Widget)this.getShowOnlyRacesOfSameDayWidget(dialog));
        additionalSettingsPanel.add((Widget)this.getShowOnlyCurrentlyRunningRacesWidget(dialog));
        return flowPanel;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel verticalPanel = new VerticalPanel();
        dialog.ensureDebugId("RegattaRacesStatesSettingsDialog");
        verticalPanel.add((Widget)this.fillCourseAreaWidget(dialog));
        verticalPanel.add((Widget)this.fillRegattaNamesWidget(dialog));
        verticalPanel.add(this.getAdditionalSettingsWidget(dialog));
        return verticalPanel;
    }

    public RegattaRaceStatesSettings getResult() {
        ArrayList<UUID> selectedCourseAreas = new ArrayList<UUID>();
        for (Map.Entry entry : this.courseAreaCheckBoxMap.entrySet()) {
            if (!((CheckBox)entry.getValue()).getValue().booleanValue()) continue;
            selectedCourseAreas.add((UUID)entry.getKey());
        }
        boolean allCourseAreasSelected = selectedCourseAreas.size() == this.courseAreas.size();
        this.setTextOfDeselectButton(this.courseAreaDeselectButton, allCourseAreasSelected);
        ArrayList<String> selectedRegattas = new ArrayList<String>();
        for (Map.Entry entry : this.regattaCheckBoxMap.entrySet()) {
            if (!((CheckBox)entry.getValue()).getValue().booleanValue()) continue;
            selectedRegattas.add((String)entry.getKey());
        }
        boolean allRegattasSelected = selectedRegattas.size() == this.raceGroups.size();
        this.setTextOfDeselectButton(this.regattaDeselectButton, allRegattasSelected);
        boolean isShowOnlyRacesOfSameDay = this.showOnlyRacesOfSameDayCheckBox.getValue();
        boolean isShowOnlyCurrentlyRunningRaces = this.showOnlyCurrentlyRunningRacesCheckBox.getValue();
        return new RegattaRaceStatesSettings((Iterable)this.courseAreas, selectedCourseAreas, (Iterable)this.raceGroups, selectedRegattas, isShowOnlyRacesOfSameDay, isShowOnlyCurrentlyRunningRaces);
    }

    public DataEntryDialog.Validator<RegattaRaceStatesSettings> getValidator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public FocusWidget getFocusWidget() {
        return null;
    }

    static /* synthetic */ Button access$1(RegattaRaceStatesSettingsDialogComponent regattaRaceStatesSettingsDialogComponent) {
        return regattaRaceStatesSettingsDialogComponent.courseAreaDeselectButton;
    }

    static /* synthetic */ StringMessages access$2(RegattaRaceStatesSettingsDialogComponent regattaRaceStatesSettingsDialogComponent) {
        return regattaRaceStatesSettingsDialogComponent.stringMessages;
    }

    static /* synthetic */ Map access$3(RegattaRaceStatesSettingsDialogComponent regattaRaceStatesSettingsDialogComponent) {
        return regattaRaceStatesSettingsDialogComponent.courseAreaCheckBoxMap;
    }

    static /* synthetic */ Button access$4(RegattaRaceStatesSettingsDialogComponent regattaRaceStatesSettingsDialogComponent) {
        return regattaRaceStatesSettingsDialogComponent.regattaDeselectButton;
    }

    static /* synthetic */ Map access$5(RegattaRaceStatesSettingsDialogComponent regattaRaceStatesSettingsDialogComponent) {
        return regattaRaceStatesSettingsDialogComponent.regattaCheckBoxMap;
    }
}

