/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.places.user.subscriptions;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.home.communication.event.LabelType;
import com.sap.sailing.gwt.home.shared.SharedHomeResources;
import com.sap.sailing.gwt.home.shared.utils.LabelTypeUtil;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.TimePoint;
import com.sap.sse.security.ui.client.i18n.subscription.SubscriptionStringConstants;
import com.sap.sse.security.ui.shared.subscription.SubscriptionDTO;
import java.util.function.BiConsumer;

public class SubscriptionsValueProvider {
    private final StringMessages i18n;

    public SubscriptionsValueProvider(StringMessages i18n) {
        this.i18n = i18n;
    }

    public String getSubscriptionName(SubscriptionDTO subscription) {
        return subscription == null ? "---" : SubscriptionStringConstants.INSTANCE.getString(subscription.getSubscriptionPlanNameMessageKey());
    }

    public LabelType getSubscriptionStatusLabelType(SubscriptionDTO subscription) {
        if (subscription.isCancelled()) {
            return LabelType.CANCELLED;
        }
        if (subscription.isInTrial()) {
            return LabelType.IN_TRIAL;
        }
        if (subscription.isActive()) {
            return LabelType.ACTIVE;
        }
        return LabelType.UNKNOWN;
    }

    public SafeHtml getSubscriptionStatusLabel(SubscriptionDTO subscription) {
        DivElement labelElement = Document.get().createDivElement();
        labelElement.addClassName(SharedResources.INSTANCE.mainCss().label());
        LabelTypeUtil.renderLabelType((Element)labelElement, (LabelType)this.getSubscriptionStatusLabelType(subscription));
        return () -> SubscriptionsValueProvider.lambda$0((Element)labelElement);
    }

    public void configurePaymentStatusElement(SubscriptionDTO subscription, BiConsumer<String, String> textValueHandler, BiConsumer<String, DataResource> imageValueHandler) {
        if (subscription.isActive()) {
            if (subscription.isPaymentSuccess()) {
                if (subscription.isRefunded()) {
                    textValueHandler.accept(this.i18n.paymentStatus(), this.i18n.refunded());
                } else {
                    imageValueHandler.accept(this.i18n.paymentStatus(), SharedHomeResources.INSTANCE.greenCheck());
                }
            } else if (subscription.isPaymentNoSuccess()) {
                imageValueHandler.accept(this.i18n.paymentStatus(), SharedHomeResources.INSTANCE.redDash());
            }
        } else {
            textValueHandler.accept(this.i18n.paymentStatus(), "---");
        }
    }

    public TimePoint getTermEnd(SubscriptionDTO subscription) {
        return subscription.isInTrial() ? subscription.getTrialEnd() : subscription.getCurrentTermEnd();
    }

    public String getRecurringPayment(SubscriptionDTO subscription) {
        return this.i18n.currencyValue((double)(subscription.getReoccuringPaymentValue() / 100), subscription.getCurrencyCode());
    }

    private static /* synthetic */ String lambda$0(Element element) {
        return element.getString();
    }
}

