/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.places.user.profile.settings;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.gwt.home.shared.app.ClientFactoryWithDispatch;
import com.sap.sailing.gwt.home.shared.places.user.profile.settings.UserSettingsEntry;
import com.sap.sailing.gwt.home.shared.places.user.profile.settings.UserSettingsView;
import com.sap.sailing.gwt.ui.client.refresh.ErrorAndBusyClientFactory;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import com.sap.sse.security.ui.authentication.WithAuthenticationManager;
import com.sap.sse.security.ui.authentication.WithUserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class UserSettingsPresenter<C extends ClientFactoryWithDispatch & ErrorAndBusyClientFactory & WithUserService>
implements UserSettingsView.Presenter {
    private final C clientFactory;
    private UserSettingsView view;
    private final List<UserSettingsEntry> currentlyShownEntries = new ArrayList();

    public UserSettingsPresenter(C clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void loadData() {
        if (((WithAuthenticationManager)this.clientFactory).getAuthenticationManager().getAuthenticationContext().isLoggedIn()) {
            ((WithUserService)this.clientFactory).getUserService().getAllPreferences((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.loadSettingsFromLocalStorage(Collections.emptyMap(), ((WithUserService)this.clientFactory).getUserService().getStorage());
        }
    }

    public void updateData() {
        this.view.setEntries(this.currentlyShownEntries.stream().filter(arg_0 -> ((Filter)this.view.getFilter()).matches(arg_0)).collect(Collectors.toList()));
    }

    private void loadSettingsFromLocalStorage(Map<String, String> userSettings, CrossDomainStorage storage) {
        this.loadSettingsFromLocalStorage(storage, localSettings -> this.updateCurrentEntries(userSettings, localSettings));
        this.updateCurrentEntries(userSettings, Collections.emptyMap());
    }

    private void updateCurrentEntries(Map<String, String> userSettings, Map<String, String> localSettings) {
        TreeSet allKeys = new TreeSet(Comparator.naturalOrder());
        allKeys.addAll(userSettings.keySet());
        allKeys.addAll(localSettings.keySet());
        this.currentlyShownEntries.clear();
        allKeys.stream().map(key -> new UserSettingsEntry(key, (String)userSettings.get(key), (String)localSettings.get(key))).forEach(this.currentlyShownEntries::add);
        this.updateData();
    }

    private void loadSettingsFromLocalStorage(CrossDomainStorage storage, Consumer<Map<String, String>> resultCallback) {
        HashMap localSettings = new HashMap();
        storage.getLength(length -> {
            int[] numberOfRequestsSent = new int[1];
            int[] numberOfResponsesReceived = new int[1];
            int i = 0;
            while (i < length) {
                storage.key(i, key -> {
                    if (key.startsWith("sailing.ui.usersettings.")) {
                        nArray[0] = numberOfRequestsSent[0] + 1;
                        storage.getItem(key, value -> {
                            localSettings.put(key, value);
                            nArray[0] = numberOfResponsesReceived[0] + 1;
                            if (numberOfResponsesReceived[0] == numberOfRequestsSent[0]) {
                                resultCallback.accept(localSettings);
                            }
                        });
                    }
                });
                ++i;
            }
        });
    }

    public void remove(UserSettingsEntry entry) {
        String storageKey = entry.getKey();
        ((WithUserService)this.clientFactory).getUserService().unsetPreference(storageKey);
        ((WithUserService)this.clientFactory).getUserService().getStorage().removeItem(storageKey, null);
        this.currentlyShownEntries.remove(entry);
        this.updateData();
    }

    public void setView(UserSettingsView view) {
        this.view = view;
    }

    static /* synthetic */ ClientFactoryWithDispatch access$0(UserSettingsPresenter userSettingsPresenter) {
        return userSettingsPresenter.clientFactory;
    }

    static /* synthetic */ void access$1(UserSettingsPresenter userSettingsPresenter, Map map, CrossDomainStorage crossDomainStorage) {
        userSettingsPresenter.loadSettingsFromLocalStorage(map, crossDomainStorage);
    }
}

