/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.windfinder;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.windfinder.SpotDTO;
import com.sap.sailing.gwt.home.shared.partials.windfinder.WindfinderLaunchPadItem;
import com.sap.sailing.gwt.home.shared.partials.windfinder.WindfinderResources;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.function.BiFunction;

class WindfinderLaunchPad
extends Widget {
    private final DivElement container = Document.get().createDivElement();
    private final BiFunction<SpotDTO, TimePoint, String> windfinderUrlFactory;
    private final PopupPanel parent;

    WindfinderLaunchPad(Iterable<SpotDTO> windfinderSpots, BiFunction<SpotDTO, TimePoint, String> windfinderUrlFactory, PopupPanel parent) {
        this.container.addClassName(WindfinderResources.INSTANCE.css().windfinderlaunchpad_content());
        this.windfinderUrlFactory = windfinderUrlFactory;
        this.parent = parent;
        windfinderSpots.forEach(arg_0 -> this.addItem(arg_0));
        this.setElement((Element)this.container);
        this.sinkEvents(1);
    }

    public void onBrowserEvent(Event event) {
        if (event.getTypeInt() == 1) {
            this.parent.hide();
        }
        super.onBrowserEvent(event);
    }

    private void addItem(SpotDTO windfinderSpot) {
        String url = (String)this.windfinderUrlFactory.apply(windfinderSpot, MillisecondsTimePoint.now());
        this.container.appendChild((Node)new WindfinderLaunchPadItem(windfinderSpot.getName(), url).getElement());
    }
}

