/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.anniversary;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.domain.common.dto.EventType;
import com.sap.sailing.gwt.home.communication.anniversary.AnniversariesDTO;
import com.sap.sailing.gwt.home.communication.anniversary.AnniversaryDTO;
import com.sap.sailing.gwt.home.shared.partials.anniversary.AnniversariesView;
import com.sap.sailing.gwt.home.shared.partials.anniversary.AnniversaryLegalNoticeBubbleContent;
import com.sap.sailing.gwt.home.shared.partials.anniversary.AnniversaryResources;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import java.util.Collections;

public class AnniversariesPresenter
implements RefreshableWidget<AnniversariesDTO> {
    private static final String ANNOUNCEMENT_ICON = AnniversaryResources.INSTANCE.bottle().getSafeUri().asString();
    private static final StringMessages I18N = StringMessages.INSTANCE;
    private static final NumberFormat COUNT_FORMAT = NumberFormat.getFormat((String)"#,###");
    private AnniversariesView view;

    public AnniversariesPresenter(AnniversariesView view) {
        this.view = view;
    }

    public void setData(AnniversariesDTO data) {
        this.view.clearAnniversaries();
        this.view.asWidget().setVisible(!data.isEmpty());
        data.getValues().forEach(arg_0 -> this.addAnniversary(arg_0));
    }

    private void addAnniversary(AnniversaryDTO anniversary) {
        int target = anniversary.getTarget();
        if (anniversary.isAnnouncement()) {
            AnniversariesView.AnniversaryAnnouncement item = this.view.addAnnouncement();
            item.setIconUrl(ANNOUNCEMENT_ICON);
            item.setCount(COUNT_FORMAT.format((double)target));
            item.setUnit(I18N.anniversaryUnitText(target));
            item.setTeaser(I18N.anniversaryAnnouncementTeaser(target));
            item.setDescription(I18N.anniversaryAnnouncementDescription(this.getRaceDisplayName(anniversary)));
            item.setLinkUrl(this.getRaceBoardLink(anniversary));
        } else {
            int countdown = anniversary.getCountdown();
            int currentRaceCount = anniversary.getCurrentRaceCount();
            AnniversariesView.AnniversaryCountdown item = this.view.addCountdown();
            item.setCount(COUNT_FORMAT.format((double)currentRaceCount));
            item.setUnit(I18N.anniversaryUnitText(currentRaceCount));
            if (anniversary.getType() == AnniversaryType.QUARTER) {
                item.setTeaser(I18N.anniversaryMajorCountdownTeaser(countdown, target));
                item.setDescription(I18N.anniversaryMajorCountdownDescription(target));
            } else if (anniversary.getType() == AnniversaryType.REPEATED_DIGIT) {
                item.setTeaser(I18N.anniversaryRepdigitCountdownTeaser(countdown, target));
                item.setDescription(I18N.anniversaryRepdigitCountdownDescription(target));
            }
            item.setLegalNotice((IsWidget)new AnniversaryLegalNoticeBubbleContent(target));
        }
    }

    private String getRaceDisplayName(AnniversaryDTO anniversary) {
        String eventName = anniversary.getEventName();
        String leaderboardDisplayName = anniversary.getLeaderboardDisplayName() != null ? anniversary.getLeaderboardDisplayName() : anniversary.getLeaderboardName();
        String leaderboardAndRaceName = String.valueOf(leaderboardDisplayName) + " - " + anniversary.getRaceName();
        if (anniversary.getEventType() == EventType.MULTI_REGATTA) {
            return eventName == null ? leaderboardAndRaceName : String.valueOf(eventName) + " - " + leaderboardAndRaceName;
        }
        return eventName == null ? leaderboardAndRaceName : String.valueOf(eventName) + " - " + anniversary.getRaceName();
    }

    private String getRaceBoardLink(AnniversaryDTO anniversary) {
        return EntryPointWithSettingsLinkFactory.createRaceBoardLink((String)anniversary.getRemoteUrl(), (RaceboardContextDefinition)new RaceboardContextDefinition(anniversary.getRegattaName(), anniversary.getRaceName(), anniversary.getLeaderboardName(), null, null, anniversary.getEventID(), null), (PerspectiveCompositeSettings)new PerspectiveCompositeSettings((Settings)new RaceBoardPerspectiveOwnSettings(), Collections.singletonMap("rm", RaceMapSettings.getDefaultWithShowMapControls((boolean)true))));
    }
}

