/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.server;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.windfinder.WindFinderTrackerFactory;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.news.EventNewsService;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.statistics.TrackedRaceStatisticsCache;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import com.sap.sse.gwt.dispatch.shared.exceptions.ServerDispatchException;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.impl.User;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.AuthorizationException;

@GwtIncompatible
public class SailingDispatchContextImpl
implements SailingDispatchContext {
    private final RacingEventService racingEventService;
    private final EventNewsService eventNewsService;
    private final Date currentClientTime;
    private String clientLocaleName;
    private final HttpServletRequest request;
    private final SecurityService securityService;
    private final TrackedRaceStatisticsCache trackedRaceStatisticsCache;
    private final WindFinderTrackerFactory windFinderTrackerFactory;

    public SailingDispatchContextImpl(Date currentClientTime, RacingEventService racingEventService, WindFinderTrackerFactory windFinderTrackerFactory, EventNewsService eventNewsService, SecurityService securityService, TrackedRaceStatisticsCache trackedRaceStatisticsCache, String clientLocaleName, HttpServletRequest request) {
        this.currentClientTime = currentClientTime;
        this.racingEventService = racingEventService;
        this.windFinderTrackerFactory = windFinderTrackerFactory;
        this.eventNewsService = eventNewsService;
        this.securityService = securityService;
        this.trackedRaceStatisticsCache = trackedRaceStatisticsCache;
        this.clientLocaleName = clientLocaleName;
        this.request = request;
    }

    public RacingEventService getRacingEventService() {
        return this.racingEventService;
    }

    public WindFinderTrackerFactory getWindFinderTrackerFactory() {
        return this.windFinderTrackerFactory;
    }

    public EventNewsService getEventNewsService() {
        return this.eventNewsService;
    }

    public Date getCurrentClientTime() {
        return this.currentClientTime;
    }

    public String getClientLocaleName() {
        return this.clientLocaleName;
    }

    public Locale getClientLocale() {
        return Locale.forLanguageTag(this.clientLocaleName);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public URL getRequestBaseURL() throws DispatchException {
        return HomeServiceUtil.getRequestBaseURL((HttpServletRequest)this.request);
    }

    public <T> T getPreferenceForCurrentUser(String preferenceKey) {
        User currentUser = this.securityService.getCurrentUser();
        if (currentUser != null) {
            return (T)this.securityService.getPreferenceObject(currentUser.getName(), preferenceKey);
        }
        return null;
    }

    public void setPreferenceForCurrentUser(String preferenceKey, Object preference) {
        User currentUser = this.securityService.getCurrentUser();
        if (currentUser != null) {
            try {
                this.securityService.setPreferenceObject(currentUser.getName(), preferenceKey, preference);
            }
            catch (AuthorizationException e) {
                throw new ServerDispatchException((Throwable)e);
            }
        }
    }

    public TrackedRaceStatisticsCache getTrackedRaceStatisticsCache() {
        return this.trackedRaceStatisticsCache;
    }
}

