/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.server;

import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.EventSeriesReferenceDTO;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.GetMiniLeaderboardDTO;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.MiniLeaderboardItemDTO;
import com.sap.sailing.gwt.home.communication.eventview.HasRegattaMetadata;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaWithProgressDTO;
import com.sap.sailing.gwt.home.server.EventActionUtil;
import com.sap.sailing.gwt.home.server.OverallRacesStateCalculator;
import com.sap.sailing.gwt.home.server.RaceContext;
import com.sap.sailing.gwt.home.server.RegattaProgressCalculator;
import com.sap.sailing.gwt.home.server.RegattaRaceDataInfoCalculator;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.util.RegattaUtil;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.dispatch.shared.commands.ResultWithTTL;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import com.sap.sse.gwt.shared.DTO;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class LeaderboardContext {
    private static final Logger logger = Logger.getLogger(LeaderboardContext.class.getName());
    private final TimePoint now = MillisecondsTimePoint.now();
    private final Event event;
    private final Iterable<LeaderboardGroup> leaderboardGroups;
    private final Leaderboard leaderboard;
    private final RacingEventService service;
    private SecurityService securityService;
    private Boolean hasMultipleFleets = null;

    public LeaderboardContext(SailingDispatchContext dispatchContext, Event event, Iterable<LeaderboardGroup> leaderboardGroup, Leaderboard leaderboard) {
        this.service = dispatchContext.getRacingEventService();
        this.securityService = dispatchContext.getSecurityService();
        this.event = event;
        this.leaderboardGroups = leaderboardGroup;
        this.leaderboard = leaderboard;
    }

    public void forRacesWithReadPermissions(EventActionUtil.RaceCallback callback) {
        for (RaceColumn raceColumn : this.leaderboard.getRaceColumns()) {
            if (raceColumn.isCarryForward()) continue;
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace tRaceOrNull = raceColumn.getTrackedRace(fleet);
                if (tRaceOrNull != null && !this.securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)tRaceOrNull)) continue;
                callback.doForRace(new RaceContext(this.service, this.event, this, raceColumn, fleet, (RaceLogResolver)this.service));
            }
        }
    }

    public RegattaWithProgressDTO getRegattaWithProgress() {
        RegattaProgressCalculator regattaProgressCalculator = new RegattaProgressCalculator();
        this.forRacesWithReadPermissions((EventActionUtil.RaceCallback)regattaProgressCalculator);
        RegattaWithProgressDTO regattaDTO = new RegattaWithProgressDTO(regattaProgressCalculator.getResult());
        this.fillRegattaFields((RegattaMetadataDTO)regattaDTO);
        return regattaDTO;
    }

    public ResultWithTTL<GetMiniLeaderboardDTO> calculateMiniLeaderboard(RacingEventService service, int limit) {
        GetMiniLeaderboardDTO result = new GetMiniLeaderboardDTO();
        try {
            LeaderboardDTO leaderboardDTO = this.leaderboard.getLeaderboardDTO(null, Collections.emptyList(), true, (TrackedRegattaRegistry)service, service.getBaseDomainFactory(), false);
            result.setScoreCorrectionText(leaderboardDTO.getComment());
            result.setLastScoreUpdate(leaderboardDTO.getTimePointOfLastCorrectionsValidity());
            boolean isLive = this.hasLiveRace();
            result.setLive(isLive);
            int rank = 0;
            for (CompetitorDTO competitor : leaderboardDTO.competitors) {
                ++rank;
                LeaderboardRowDTO row = (LeaderboardRowDTO)leaderboardDTO.rows.get(competitor);
                int raceCount = 0;
                if (row.fieldsByRaceColumnName != null) {
                    for (LeaderboardEntryDTO lbEntry : row.fieldsByRaceColumnName.values()) {
                        if (lbEntry.netPoints == null) continue;
                        ++raceCount;
                    }
                }
                result.addItem(new MiniLeaderboardItemDTO(new SimpleCompetitorDTO(competitor), rank, row.netPoints, raceCount));
                if (limit > 0 && rank >= limit) break;
            }
            result.setTotalCompetitorCount(leaderboardDTO.competitors.size());
            return new ResultWithTTL(Duration.ONE_MINUTE.times((long)(isLive ? 1 : 2)), (DTO)result);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading leaderboard", e);
            throw new DispatchException("Error loading leaderboard");
        }
    }

    private boolean hasLiveRace() {
        OverallRacesStateCalculator racesStateCalculator = new OverallRacesStateCalculator();
        this.forRacesWithReadPermissions((EventActionUtil.RaceCallback)racesStateCalculator);
        return racesStateCalculator.hasLiveRace();
    }

    public HasRegattaMetadata.RegattaState calculateRegattaState() {
        EventState eventState = HomeServiceUtil.calculateEventState((EventBase)this.event);
        if (eventState == EventState.FINISHED) {
            return HasRegattaMetadata.RegattaState.FINISHED;
        }
        if (eventState == EventState.UPCOMING || eventState == EventState.PLANNED) {
            return HasRegattaMetadata.RegattaState.UPCOMING;
        }
        TimePoint startDate = this.getStartTimePoint();
        if (startDate != null && this.now.before(startDate)) {
            return HasRegattaMetadata.RegattaState.UPCOMING;
        }
        TimePoint endDate = this.getEndTimePoint();
        if (endDate != null && this.now.after(endDate)) {
            return HasRegattaMetadata.RegattaState.FINISHED;
        }
        OverallRacesStateCalculator racesStateCalculator = new OverallRacesStateCalculator();
        this.forRacesWithReadPermissions((EventActionUtil.RaceCallback)racesStateCalculator);
        if (racesStateCalculator.hasLiveRace()) {
            return HasRegattaMetadata.RegattaState.RUNNING;
        }
        if (!racesStateCalculator.hasUnfinishedRace()) {
            return HasRegattaMetadata.RegattaState.FINISHED;
        }
        if (racesStateCalculator.hasAbandonedOrPostponedRace() || racesStateCalculator.hasFinishedRace()) {
            return HasRegattaMetadata.RegattaState.PROGRESS;
        }
        return HasRegattaMetadata.RegattaState.UPCOMING;
    }

    private Date getStartDateWithEventFallback() {
        Date result = this.getStartDate();
        if (result != null) {
            return result;
        }
        return this.event.getStartDate().asDate();
    }

    private Date getStartDate() {
        TimePoint timePoint = this.getStartTimePoint();
        if (timePoint != null) {
            return timePoint.asDate();
        }
        return null;
    }

    private TimePoint getStartTimePoint() {
        if (this.leaderboard instanceof RegattaLeaderboard) {
            Regatta regatta = ((RegattaLeaderboard)this.leaderboard).getRegatta();
            return regatta.getStartDate();
        }
        return null;
    }

    private Date getEndDateWithEventFallback() {
        Date result = this.getEndDate();
        if (result != null) {
            return result;
        }
        return this.event.getEndDate().asDate();
    }

    private Date getEndDate() {
        TimePoint timePoint = this.getEndTimePoint();
        if (timePoint != null) {
            return timePoint.asDate();
        }
        return null;
    }

    private TimePoint getEndTimePoint() {
        if (this.leaderboard instanceof RegattaLeaderboard) {
            Regatta regatta = ((RegattaLeaderboard)this.leaderboard).getRegatta();
            return regatta.getEndDate();
        }
        return null;
    }

    public String getLeaderboardName() {
        return this.leaderboard.getName();
    }

    public Iterable<String> getLeaderboardGroupNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (LeaderboardGroup lg : this.leaderboardGroups) {
            result.add(lg.getName());
        }
        return result;
    }

    public Iterable<UUID> getLeaderboardGroupIds() {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (LeaderboardGroup lg : this.leaderboardGroups) {
            result.add(lg.getId());
        }
        return result;
    }

    public RegattaMetadataDTO asRegattaMetadataDTO() {
        RegattaMetadataDTO regattaDTO = new RegattaMetadataDTO();
        this.fillRegattaFields(regattaDTO);
        return regattaDTO;
    }

    private int calculateRaceCount(Leaderboard sl) {
        int result = 0;
        for (RaceColumn column : sl.getRaceColumns()) {
            if (column.isCarryForward()) continue;
            result += Util.size((Iterable)column.getFleets());
        }
        return result;
    }

    public void fillRegattaFields(RegattaMetadataDTO regattaDTO) {
        LeaderboardGroup singleLeaderboardGroup;
        regattaDTO.setId(this.getLeaderboardName());
        regattaDTO.setDisplayName(this.leaderboard.getDisplayName() != null ? this.leaderboard.getDisplayName() : this.leaderboard.getName());
        if (LeaderboardContext.hasMultipleLeaderboardGroups((EventBase)this.event)) {
            for (LeaderboardGroup lg : this.leaderboardGroups) {
                regattaDTO.addLeaderboardGroupName(lg.getDisplayName() != null ? lg.getDisplayName() : lg.getName());
            }
        }
        if (Util.size((Iterable)this.leaderboardGroups) == 1 && (singleLeaderboardGroup = (LeaderboardGroup)this.leaderboardGroups.iterator().next()).hasOverallLeaderboard()) {
            regattaDTO.setSeriesReference(new EventSeriesReferenceDTO(HomeServiceUtil.getLeaderboardDisplayName((LeaderboardGroupBase)singleLeaderboardGroup), singleLeaderboardGroup.getId()));
        }
        regattaDTO.setCompetitorsCount(HomeServiceUtil.calculateCompetitorsCount((Leaderboard)this.leaderboard));
        regattaDTO.setRaceCount(this.calculateRaceCount(this.leaderboard));
        regattaDTO.setBoatClass(HomeServiceUtil.getBoatClassName((Leaderboard)this.leaderboard));
        if (this.leaderboard instanceof RegattaLeaderboard) {
            regattaDTO.setStartDate(this.getStartDateWithEventFallback());
            regattaDTO.setEndDate(this.getEndDateWithEventFallback());
        }
        regattaDTO.setState(this.calculateRegattaState());
        regattaDTO.setDefaultCourseAreaName(HomeServiceUtil.getCourseAreaNameForRegattaIfThereIsMoreThanOne((EventBase)this.event, (Leaderboard)this.leaderboard));
        regattaDTO.setCourseAreaIdsAsStrings(HomeServiceUtil.getCourseAreaIdsAsStringsForRegatta((EventBase)this.event, (Leaderboard)this.leaderboard));
        regattaDTO.setFlexibleLeaderboard(this.leaderboard instanceof FlexibleLeaderboard);
        RegattaRaceDataInfoCalculator regattaRaceDataInfoCalculator = new RegattaRaceDataInfoCalculator();
        this.forRacesWithReadPermissions((EventActionUtil.RaceCallback)regattaRaceDataInfoCalculator);
        regattaDTO.setRaceDataInfo(regattaRaceDataInfoCalculator.getRaceDataInfo());
        regattaDTO.setBuoyZoneRadius(this.getRegattaBuoyZoneRadius());
    }

    private Distance getRegattaBuoyZoneRadius() {
        Regatta regatta = this.service.getRegattaByName(this.getLeaderboardName());
        BoatClass boatClass = HomeServiceUtil.getBoatClass((Leaderboard)this.leaderboard);
        return RegattaUtil.getCalculatedRegattaBuoyZoneRadius((Regatta)regatta, (BoatClass)boatClass);
    }

    private static boolean hasMultipleLeaderboardGroups(EventBase event) {
        return Util.size((Iterable)event.getLeaderboardGroups()) > 1;
    }

    public boolean isPartOfEvent() {
        return this.leaderboard.isPartOfEvent((EventBase)this.event);
    }

    public Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    private boolean calculateHasMultipleFleets() {
        HashSet fleets = new HashSet();
        for (RaceColumn raceColumn : this.leaderboard.getRaceColumns()) {
            Util.addAll((Iterable)raceColumn.getFleets(), fleets);
            if (fleets.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean hasMultipleFleets() {
        if (this.hasMultipleFleets == null) {
            this.hasMultipleFleets = this.calculateHasMultipleFleets();
        }
        return this.hasMultipleFleets;
    }

    public Iterable<LeaderboardGroup> getLeaderboardGroups() {
        return this.leaderboardGroups;
    }
}

