/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.user.profile.subscriptions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.home.mobile.partials.section.MobileSection;
import com.sap.sailing.gwt.home.mobile.partials.sectionHeader.SectionHeaderContent;
import com.sap.sailing.gwt.home.mobile.places.user.profile.subscriptions.UserSubscriptionItem;
import com.sap.sailing.gwt.home.mobile.places.user.profile.subscriptions.UserSubscriptionItemInfo;
import com.sap.sailing.gwt.home.shared.places.user.profile.subscriptions.UserSubscriptionsView;
import com.sap.sailing.gwt.home.shared.places.user.subscriptions.SubscriptionsValueProvider;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.TimePoint;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.security.ui.shared.subscription.SubscriptionDTO;
import java.util.Date;

class UserSubscriptionItem
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    SharedResources res;
    @UiField
    StringMessages i18n;
    @UiField
    SectionHeaderContent sectionHeaderUi;
    @UiField
    HTMLPanel contentContainerUi;
    @UiField
    Element subscriptionInfoUi;
    @UiField
    Button cancelControlUi;
    private final SubscriptionsValueProvider valueProvider;
    private final Runnable nonRenewingCallback;

    UserSubscriptionItem(SubscriptionDTO subscription, UserSubscriptionsView.Presenter presenter) {
        MobileSection mobileSection = (MobileSection)uiBinder.createAndBindUi((Object)this);
        mobileSection.setEdgeToEdgeContent(true);
        this.initWidget((Widget)mobileSection);
        this.valueProvider = new SubscriptionsValueProvider(this.i18n);
        if (subscription.isCancelled() || !subscription.isRenewing()) {
            this.nonRenewingCallback = () -> {};
            this.cancelControlUi.setEnabled(false);
        } else {
            this.nonRenewingCallback = () -> presenter.nonRenewingSubscription(subscription.getSubscriptionPlanId(), subscription.getProvider());
        }
        this.sectionHeaderUi.setSectionTitle(this.valueProvider.getSubscriptionName(subscription));
        this.sectionHeaderUi.setLabelType(this.valueProvider.getSubscriptionStatusLabelType(subscription));
        this.addInfo(this.i18n.createdAt(), subscription.getCreatedAt());
        this.addInfo(this.i18n.currentTermEnd(), this.valueProvider.getTermEnd(subscription));
        this.valueProvider.configurePaymentStatusElement(subscription, (arg_0, arg_1) -> this.addInfo(arg_0, arg_1), (arg_0, arg_1) -> this.addInfo(arg_0, arg_1));
        if (!(subscription.isInTrial() || !subscription.isCancelled() && subscription.isRenewing())) {
            this.addInfo(this.i18n.cancelledAt(), subscription.getCancelledAt());
        } else if (subscription.isRenewing()) {
            this.addInfo(this.i18n.nextBillingAt(), subscription.getNextBillingAt());
            this.addInfo("", this.valueProvider.getRecurringPayment(subscription));
        }
        this.sectionHeaderUi.initCollapsibility((Element)this.contentContainerUi.getElement(), false);
    }

    @UiHandler(value={"cancelControlUi"})
    void onCancelControlClicked(ClickEvent event) {
        this.nonRenewingCallback.run();
    }

    private void addInfo(String label, String value) {
        this.subscriptionInfoUi.appendChild((Node)new UserSubscriptionItemInfo(label, value).getElement());
    }

    private void addInfo(String label, DataResource value) {
        this.subscriptionInfoUi.appendChild((Node)new UserSubscriptionItemInfo(label, value).getElement());
    }

    private void addInfo(String label, TimePoint value) {
        this.addInfo(label, DateAndTimeFormatterUtil.formatDateAndTime((Date)value.asDate()));
    }
}

