/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details.statistics;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorWithIdDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileNumericStatisticType;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileStatisticDTO;
import com.sap.sailing.gwt.home.desktop.partials.desktopaccordion.DesktopAccordionResources;
import com.sap.sailing.gwt.home.desktop.places.user.profile.sailorprofiletab.details.statistic.SailorProfileNumericStatisticTypeFormatter;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.SailorProfileMobileResources;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details.statistics.SailorProfileStatisticEntry;
import com.sap.sailing.gwt.home.mobile.places.user.profile.sailorprofiles.details.statistics.SailorProfileStatisticTable;
import com.sap.sailing.gwt.home.shared.places.user.profile.sailorprofile.DataMiningQueryForSailorProfilesPersistor;
import com.sap.sailing.gwt.home.shared.places.user.profile.sailorprofile.SharedSailorProfileResources;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class SailorProfileStatisticTable
extends Composite {
    private static SailorProfileOverviewEntryUiBinder uiBinder = (SailorProfileOverviewEntryUiBinder)GWT.create(SailorProfileOverviewEntryUiBinder.class);
    @UiField
    DivElement sectionTitleUi;
    @UiField
    HTMLPanel sectionTitleContainerUi;
    @UiField
    HTMLPanel contentContainerStatistic;
    @UiField
    DivElement sectionTitleIconUi;
    private final UserService userService;

    public SailorProfileStatisticTable(SailorProfileNumericStatisticType type, SailorProfileStatisticDTO statistic, FlagImageResolver flagImageResolver, StringMessages stringMessages, UserService userService) {
        this.userService = userService;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        SailorProfileMobileResources.INSTANCE.css().ensureInjected();
        this.sectionTitleUi.setInnerText(SailorProfileNumericStatisticTypeFormatter.getDisplayName((SailorProfileNumericStatisticType)type, (StringMessages)stringMessages));
        Image icon = new Image();
        icon.setUrl(SailorProfileNumericStatisticTypeFormatter.getIcon((SailorProfileNumericStatisticType)type));
        icon.setSize("auto", "2em");
        this.sectionTitleIconUi.appendChild((Node)icon.getElement());
        Set entrySet = statistic.getResult().entrySet();
        ArrayList data = new ArrayList();
        data.addAll(entrySet);
        data.sort((o1, o2) -> Double.compare(((ArrayList)o1.getValue()).size() > 0 ? ((SailorProfileStatisticDTO.SingleEntry)((ArrayList)o1.getValue()).get(0)).getValue() : 0.0, ((ArrayList)o2.getValue()).size() > 0 ? ((SailorProfileStatisticDTO.SingleEntry)((ArrayList)o2.getValue()).get(0)).getValue() : 0.0));
        boolean hasData = false;
        for (Map.Entry entry : data) {
            hasData |= !((ArrayList)entry.getValue()).isEmpty();
            for (SailorProfileStatisticDTO.SingleEntry singleEntry : (ArrayList)entry.getValue()) {
                this.contentContainerStatistic.add((Widget)new SailorProfileStatisticEntry(type, (SimpleCompetitorWithIdDTO)entry.getKey(), singleEntry, flagImageResolver, stringMessages, statistic.getDataMiningQuery()));
            }
        }
        if (!hasData) {
            Label label = new Label(stringMessages.noStatisticsFoundForCompetitors());
            label.addStyleName(DesktopAccordionResources.INSTANCE.css().accordionEmptyMessage());
            this.contentContainerStatistic.add((Widget)label);
        }
        if (type.getAggregationType() == SailorProfileNumericStatisticType.StatisticType.AVERAGE && userService.hasServerPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.DATA_MINING)) {
            this.addDataminingButton(statistic);
        }
    }

    private void addDataminingButton(SailorProfileStatisticDTO statistic) {
        Button button = new Button();
        button.addStyleName(String.valueOf(SailorProfileMobileResources.INSTANCE.css().showLeaderboardButton()) + " " + SharedSailorProfileResources.INSTANCE.css().inverseButton());
        button.setText(StringMessages.INSTANCE.showInDataMining());
        button.addClickHandler(e -> this.handleLocalStorage(statistic));
        this.contentContainerStatistic.add((Widget)button);
    }

    private void handleLocalStorage(SailorProfileStatisticDTO dto) {
        String identifier = "sailing.ui.datamining.query." + UUID.randomUUID().toString();
        DataMiningQueryForSailorProfilesPersistor.writeDMQueriesToLocalStorageIfPossible((SailorProfileStatisticDTO)dto, (String)identifier, (CrossDomainStorage)this.userService.getStorage());
        Window.Location.assign((String)("DataMining.html?q=" + identifier));
    }
}

