/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.regattaStatus;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.gwt.home.communication.event.LiveRaceDTO;
import com.sap.sailing.gwt.home.communication.race.FlagStateDTO;
import com.sap.sailing.gwt.home.communication.race.FleetMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.RaceProgressDTO;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.desktop.partials.raceviewerlaunchpad.RaceviewerLaunchPadController;
import com.sap.sailing.gwt.home.mobile.partials.regattaStatus.RegattaStatusRace;
import com.sap.sailing.gwt.home.shared.utils.HomeSailingFlagsBuilder;
import com.sap.sailing.gwt.regattaoverview.client.FlagsMeaningExplanator;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import java.util.Date;
import java.util.function.BiFunction;
import java.util.function.Function;

public class RegattaStatusRace
extends Composite {
    private static final StringMessages I18N = StringMessages.INSTANCE;
    private static RegattaStatusRaceUiBinder uiBinder = (RegattaStatusRaceUiBinder)GWT.create(RegattaStatusRaceUiBinder.class);
    @UiField
    DivElement fleetCornerUi;
    @UiField
    DivElement raceTitleUi;
    @UiField
    DivElement raceFlagContainerUi;
    @UiField
    DivElement raceStateInfoUi;
    @UiField
    DivElement raceLegsInfoUi;
    @UiField
    DivElement raceLegsInfoLabelUi;
    @UiField
    DivElement raceLegsInfoProgressUi;
    @UiField
    DivElement actionArrowUi;
    private final RaceviewerLaunchPadController<LiveRaceDTO> launchPadController;
    private final LiveRaceDTO race;

    public RegattaStatusRace(LiveRaceDTO race, BiFunction<? super SimpleRaceMetadataDTO, String, String> raceboardUrlFactory, Function<? super SimpleRaceMetadataDTO, String> mapAndWindChartUrlFactory, PaywallResolver paywallResolver) {
        this.race = race;
        this.launchPadController = new RaceviewerLaunchPadController(raceboardUrlFactory, mapAndWindChartUrlFactory, paywallResolver);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initRaceFleetCorner(race.getFleet());
        this.raceTitleUi.setInnerText(race.getRaceName());
        this.initRaceFlagInfo(race.getFlagState());
        this.initRaceStateOrLegsInfo(race.getViewState(), race.getStart(), race.getProgress());
        if (race.hasValidTrackingData()) {
            this.sinkEvents(1);
            this.actionArrowUi.getStyle().clearDisplay();
        }
    }

    public void onBrowserEvent(Event event) {
        if (this.race.hasValidTrackingData() && event.getTypeInt() == 1) {
            if (this.launchPadController.renderAsDirectLink((SimpleRaceMetadataDTO)this.race)) {
                Window.open((String)this.launchPadController.getDirectLinkUrl((SimpleRaceMetadataDTO)this.race), (String)"_blank", (String)"");
            } else {
                this.launchPadController.showLaunchPad((Object)this.race, (Element)this.getElement());
            }
        }
    }

    private void initRaceFleetCorner(FleetMetadataDTO fleet) {
        if (fleet != null) {
            this.fleetCornerUi.getStyle().setBorderColor(String.valueOf(fleet.getFleetColor()) + " transparent");
        }
    }

    private void initRaceFlagInfo(FlagStateDTO value) {
        if (value != null) {
            this.raceFlagContainerUi.setInnerSafeHtml(HomeSailingFlagsBuilder.render((FlagStateDTO)value, (double)0.4, (String)FlagsMeaningExplanator.getFlagsMeaning((StringMessages)I18N, (Flags)value.getLastUpperFlag(), (Flags)value.getLastLowerFlag(), (boolean)value.isLastFlagsAreDisplayed())));
        }
    }

    private void initRaceStateOrLegsInfo(SimpleRaceMetadataDTO.RaceViewState state, Date start, RaceProgressDTO progress) {
        if (state == SimpleRaceMetadataDTO.RaceViewState.RUNNING && progress != null) {
            this.raceStateInfoUi.removeFromParent();
            this.raceLegsInfoLabelUi.setInnerText(I18N.currentOfTotalLegs(progress.getCurrentLeg().intValue(), progress.getTotalLegs().intValue()));
            this.raceLegsInfoProgressUi.getStyle().setWidth(progress.getPercentageProgress().doubleValue(), Style.Unit.PCT);
        } else {
            this.raceLegsInfoUi.removeFromParent();
            this.raceStateInfoUi.setInnerText(state.getLabel());
            if (state == SimpleRaceMetadataDTO.RaceViewState.SCHEDULED && start != null) {
                double min = MillisecondsTimePoint.now().until((TimePoint)new MillisecondsTimePoint(start)).asMinutes();
                this.raceStateInfoUi.setInnerText(I18N.startingInMinutes((int)min));
            }
        }
    }
}

