/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.imagegallery;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.mobile.partials.imagegallery.MobileGalleryPlayer;
import com.sap.sailing.gwt.ui.shared.SailingImageDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.common.CommonSharedResources;
import java.util.Collection;

public class MobileGalleryPlayer
extends ResizeComposite {
    private static MyBinder uiBinder = (MyBinder)GWT.create(MyBinder.class);
    @UiField
    DivElement mainSliderUi;
    private int selectedIdx;
    private boolean autoplay;

    public MobileGalleryPlayer(ImageDTO selected, Collection<SailingImageDTO> images, TakedownNoticeService takedownNoticeService) {
        CommonSharedResources.INSTANCE.mainCss().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.selectedIdx = Math.max(this.selectedIdx, Util.indexOf(images, (Object)selected));
        for (SailingImageDTO i : images) {
            this.mainSliderUi.appendChild((Node)this.createMainImgElement(i, takedownNoticeService));
        }
    }

    private DivElement createMainImgElement(SailingImageDTO i, TakedownNoticeService takedownNoticeService) {
        DivElement img = Document.get().createDivElement();
        img.getStyle().setBackgroundImage("url(\"" + i.getSourceRef() + "\")");
        img.getStyle().setProperty("backgroundSize", "contain");
        img.getStyle().setProperty("backgroundRepeat", "no-repeat");
        img.getStyle().setProperty("backgroundPosition", "center");
        img.addClassName(CommonSharedResources.INSTANCE.mainCss().media_wrapper());
        MediaMenuIcon mmi = new MediaMenuIcon(takedownNoticeService, "takedownRequestForEventGalleryImage");
        mmi.setFontSize("20px");
        RootPanel.get().add((Widget)mmi);
        mmi.setData(i.getEventLink().getDisplayName(), i.getSourceRef());
        img.appendChild((Node)mmi.getElement());
        return img;
    }

    protected void onLoad() {
        this._onLoad();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onResize() {
        this.refreshSlider();
    }

    native void gotoSlider(int var1);

    native void refreshSlider();

    native void _onLoad();

    private native void _slickPlay();

    private native void _slickPause();

    public void toggleAutoplay() {
        boolean bl = this.autoplay = !this.autoplay;
        if (this.autoplay) {
            this._slickPlay();
        } else {
            this._slickPause();
        }
    }

    public boolean isAutoplaying() {
        return this.autoplay;
    }

    static /* synthetic */ int access$0(MobileGalleryPlayer mobileGalleryPlayer) {
        return mobileGalleryPlayer.selectedIdx;
    }
}

