/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.eventsteps;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.BoatClassImageResolver;
import com.sap.sailing.gwt.home.communication.eventview.HasRegattaMetadata;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaProgressSeriesDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaWithProgressDTO;
import com.sap.sailing.gwt.home.mobile.partials.eventsteps.EventSteps;
import com.sap.sailing.gwt.home.mobile.partials.eventsteps.EventStepsPhase;
import com.sap.sailing.gwt.home.mobile.partials.eventsteps.EventStepsResources;
import com.sap.sailing.gwt.home.mobile.partials.section.MobileSection;
import com.sap.sailing.gwt.home.mobile.partials.sectionHeader.SectionHeaderContent;
import com.sap.sailing.gwt.home.mobile.partials.sectionHeader.SectionHeaderDataIndicators;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import java.util.function.Function;

public class EventSteps
extends Composite
implements RefreshableWidget<RegattaWithProgressDTO> {
    private static EventStepsUiBinder uiBinder = (EventStepsUiBinder)GWT.create(EventStepsUiBinder.class);
    @UiField
    EventStepsResources local_res;
    @UiField
    SectionHeaderContent sectionHeaderUi;
    private final MobileSection regattaProgessUi;
    private final Function<String, PlaceNavigation<?>> racesNavigationFactory;

    public EventSteps(RegattaMetadataDTO regatta, Function<String, PlaceNavigation<?>> racesNavigationFactory) {
        this.racesNavigationFactory = racesNavigationFactory;
        EventStepsResources.INSTANCE.css().ensureInjected();
        this.regattaProgessUi = (MobileSection)uiBinder.createAndBindUi((Object)this);
        this.initWidget((Widget)this.regattaProgessUi);
        ImageResource boatClassIcon = BoatClassImageResolver.getBoatClassIconResource((String)regatta.getBoatClass());
        this.sectionHeaderUi.setImageUrl(boatClassIcon.getSafeUri().asString());
        this.sectionHeaderUi.setSectionTitle(regatta.getDisplayName());
        this.regattaProgessUi.setEdgeToEdgeContent(true);
        this.sectionHeaderUi.initCollapsibility(this.regattaProgessUi.getContentContainerElement(), HasRegattaMetadata.RegattaState.FINISHED != regatta.getState());
        this.sectionHeaderUi.initBoatClassPopup(regatta.getBoatClass());
        this.sectionHeaderUi.initAdditionalWidget((Widget)new SectionHeaderDataIndicators(regatta.getRaceDataInfo()));
    }

    public void setData(RegattaWithProgressDTO data) {
        this.regattaProgessUi.clearContent();
        boolean showSeriesName = data.getProgress().getSeries().size() > 1;
        for (RegattaProgressSeriesDTO seriesProgress : data.getProgress().getSeries()) {
            PlaceNavigation navigation = (PlaceNavigation)this.racesNavigationFactory.apply(seriesProgress.getName());
            this.regattaProgessUi.addContent((Widget)new EventStepsPhase(seriesProgress, navigation, showSeriesName));
        }
    }
}

