/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.qrcode;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.home.desktop.places.qrcode.QRCodeView;
import com.sap.sailing.gwt.home.shared.partials.dialog.confirm.ConfirmDialogFactory;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.MarkDTO;
import com.sap.sailing.gwt.ui.shared.QRCodeEvent;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.logging.Logger;

public class QRCodeView
extends Composite {
    private static final Logger logger = Logger.getLogger(QRCodeView.class.getName());
    private static QRCodeViewUiBinder uiBinder = (QRCodeViewUiBinder)GWT.create(QRCodeViewUiBinder.class);
    @UiField
    DivElement errorDivUi;
    @UiField
    DivElement titleDivUi;
    @UiField
    DivElement subtitleDivUi;
    @UiField
    DivElement infoDivUi;
    @UiField
    DivElement qrCodeDivUi;
    @UiField
    DivElement eventImageUi;
    @UiField
    AnchorElement urlAnchor;

    public QRCodeView() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void showCompetitor(QRCodeEvent event, CompetitorDTO competitor, BoatDTO boat, MarkDTO mark, String leaderboardName, String branchIoUrl) {
        logger.info("Showing QR Code for competitor/boat/mark tracking");
        if (boat != null) {
            logger.info("Showing message for boat");
            this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeBoatInviteTitle(boat.getDisplayName(), leaderboardName));
        } else if (mark != null) {
            logger.info("Showing message for mark");
            this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeMarkInviteTitle(mark.getName(), leaderboardName));
        } else if (competitor != null) {
            logger.info("Showing message for competitor");
            this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeCompetitorInviteTitle(competitor.getName(), leaderboardName));
        } else {
            logger.info("Showing unspecific message");
            this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeTitle(leaderboardName));
        }
        if (event != null) {
            logger.info("Showing event");
            this.subtitleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeSubtitle(event.getDisplayName(), event.getLocationAndVenue()));
        } else {
            logger.info("No event available");
        }
        this.showQrCodeForURL(branchIoUrl);
        this.showEventImageIfPossible(event);
    }

    public void showPublic(String publicRegattaName, String publicInviteBranchIOUrl) {
        logger.info("Showing QR Code for public regatta invite");
        if (publicInviteBranchIOUrl != null) {
            this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeTitleOpenRegatta(publicRegattaName));
            this.showQrCodeForURL(publicInviteBranchIOUrl);
        } else {
            this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeTitleErrorCreatingQrCode());
        }
    }

    public void showRaceManagerApp(String raceManagerAppBranchIOUrl) {
        logger.info("Showing QR Code for race manager app");
        this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeTitleOpenRaceManagerApp());
        if (raceManagerAppBranchIOUrl != null) {
            this.subtitleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeSubTitleOpenRaceManagerApp());
            this.showQrCodeForURL(raceManagerAppBranchIOUrl);
        } else {
            this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeTitleErrorCreatingQrCode());
        }
    }

    public void showBouyTender(QRCodeEvent event, String leaderboardName, String branchIoUrl) {
        logger.info("Showing QR Code for buoy tender");
        this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeTitleBouy(leaderboardName));
        if (event != null) {
            logger.info("Showing event");
            this.subtitleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeSubtitle(event.getDisplayName(), event.getLocationAndVenue()));
        } else {
            logger.info("No event available");
        }
        if (branchIoUrl != null) {
            this.showQrCodeForURL(branchIoUrl);
        } else {
            this.titleDivUi.setInnerText(StringMessages.INSTANCE.qrCodeTitleErrorCreatingQrCode());
        }
        this.showEventImageIfPossible(event);
    }

    private void showEventImageIfPossible(QRCodeEvent event) {
        if (event != null && event.getLogoImage() != null) {
            logger.info("Showing event logo");
            this.eventImageUi.getStyle().setBackgroundImage("url('" + event.getLogoImage().getSourceRef() + "')");
            this.eventImageUi.getStyle().setWidth((double)event.getLogoImage().getWidthInPx().intValue(), Style.Unit.PX);
            this.eventImageUi.getStyle().setHeight((double)event.getLogoImage().getHeightInPx().intValue(), Style.Unit.PX);
        } else {
            logger.info("No event logo found");
        }
    }

    private void showQrCodeForURL(String url) {
        logger.info("Rendering QR code for url: " + url);
        this.urlAnchor.setHref(url);
        ScriptInjector.fromUrl((String)"qrcode/qrcode.min.js").setWindow(ScriptInjector.TOP_WINDOW).setCallback((Callback)new /* Unavailable Anonymous Inner Class!! */).inject();
    }

    public void setError() {
        logger.info("QR Code error");
        this.errorDivUi.setInnerText(StringMessages.INSTANCE.qrCodeErrorMessage());
        this.infoDivUi.removeFromParent();
    }

    public void showRedirectionDialog(Util.Triple<String, String, Integer> correctServerHost, Runnable runnable) {
        ConfirmDialogFactory.showConfirmDialog((String)StringMessages.INSTANCE.qrCodeUnsecureServerRedirect((String)correctServerHost.getB()), (String)StringMessages.INSTANCE.qrCodeUnsecureServerRedirectTitle((String)correctServerHost.getB()), (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }
}

