/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.qrcode;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.gwt.home.desktop.places.qrcode.QRCodeClientFactory;
import com.sap.sailing.gwt.home.desktop.places.qrcode.QRCodePlace;
import com.sap.sailing.gwt.home.desktop.places.qrcode.QRCodePresenter;
import com.sap.sailing.gwt.home.desktop.places.qrcode.QRCodeView;
import com.sap.sse.common.Util;
import java.util.UUID;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class QRCodePresenter {
    private static final Logger logger = Logger.getLogger(QRCodePresenter.class.getName());
    private final QRCodeClientFactory clientFactory;
    private DataCollector dataCollector;
    private QRCodePlace place;

    public QRCodePresenter(QRCodeClientFactory clientFactory, QRCodePlace place) {
        this.clientFactory = clientFactory;
        this.place = place;
        logger.info("Creating QRCodePresenter with place: " + place);
    }

    public void setView(QRCodeView view) {
        String rawTargetServer = this.place.getTargetServer();
        logger.info("Target server for QR Code: " + rawTargetServer);
        Util.Triple correctServerHost = this.getServerAndPort(rawTargetServer);
        if (this.isCorrectServer(correctServerHost)) {
            logger.info("Already the right server for QR Code");
            this.showQrCode(view);
        } else {
            logger.info("Not the right server for QR Code");
            if (this.isSecureServer(correctServerHost)) {
                logger.info("Redirecting to the right server for QR Code");
                String url = this.getCorrectUrl(correctServerHost);
                Window.Location.assign((String)url);
            } else {
                logger.info("Unsafe target server for QR Code -> ask the user");
                view.showRedirectionDialog(correctServerHost, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private boolean isSecureServer(Util.Triple<String, String, Integer> correctServerHost) {
        String host = (String)correctServerHost.getB();
        if (host.endsWith("sapsailing.com")) {
            return true;
        }
        return host.equals("127.0.0.1");
    }

    private Util.Triple<String, String, Integer> getServerAndPort(String rawTargetServer) {
        Integer port;
        String host;
        String[] protocolAndHostPort = rawTargetServer.split("://");
        String protocol = String.valueOf(protocolAndHostPort[0]) + ":";
        if (protocolAndHostPort[1].contains(":")) {
            String[] parts = protocolAndHostPort[1].split(":");
            host = parts[0];
            port = Integer.parseInt(parts[1]);
        } else {
            port = null;
            host = protocolAndHostPort[1];
        }
        Util.Triple answer = new Util.Triple((Object)protocol, (Object)host, port);
        return answer;
    }

    private String getCorrectUrl(Util.Triple<String, String, Integer> correctServerHost) {
        String newUrl = Window.Location.createUrlBuilder().setHost((String)correctServerHost.getB()).setProtocol((String)correctServerHost.getA()).setPort(correctServerHost.getC() == null ? Integer.MIN_VALUE : (Integer)correctServerHost.getC()).buildString();
        return newUrl;
    }

    private boolean isCorrectServer(Util.Triple<String, String, Integer> correctServerHost) {
        String targetProtocol = (String)correctServerHost.getA();
        String currentProtocol = Window.Location.getProtocol();
        boolean protocolSame = Util.equalsWithNull((Object)targetProtocol, (Object)currentProtocol);
        logger.info("Checking Protocol: current=" + currentProtocol + "; target=" + targetProtocol + "; same=" + protocolSame);
        String targetHost = (String)correctServerHost.getB();
        String currentHost = Window.Location.getHostName();
        boolean hostSame = Util.equalsWithNull((Object)targetHost, (Object)currentHost);
        logger.info("Checking Host: current=" + currentHost + "; target=" + targetHost + "; same=" + hostSame);
        Integer targetPort = (Integer)correctServerHost.getC();
        String targetPortAsString = correctServerHost.getC() == null ? "" : Integer.toString(targetPort);
        String currentPort = Window.Location.getPort();
        boolean portSame = Util.equalsWithNull((Object)targetPortAsString, (Object)currentPort);
        logger.info("Checking Port: current=" + currentPort + "; target=" + targetPortAsString + "; same=" + portSame);
        return protocolSame && hostSame && portSame;
    }

    private void showQrCode(QRCodeView view) {
        if (this.place.getMode() == QRCodePlace.InvitationMode.BOUY_TENDER) {
            logger.info("QR Code for buoy tender to be shown");
            if (this.place.getEncodedCheckInUrl() == null || this.place.getEncodedCheckInUrl().isEmpty()) {
                view.setError();
            } else {
                this.dataCollector = new DataCollector(this, view);
                this.retrieveEvent(this.place.getEventId());
            }
        } else if (QRCodePlace.isCompetitorOrBoatRequest()) {
            logger.info("QR Code for competitor/boat/buoy tracking to be shown");
            if (this.place.getEncodedCheckInUrl() == null || this.place.getEncodedCheckInUrl().isEmpty()) {
                view.setError();
            } else {
                this.dataCollector = new DataCollector(this, view);
                if (this.place.getCompetitorId() != null) {
                    this.retrieveCompetitor(this.place.getCompetitorId());
                } else if (this.place.getBoatId() != null) {
                    this.retrieveBoat(this.place.getBoatId());
                } else if (this.place.getMarkId() != null) {
                    this.retrieveMark(this.place.getMarkId());
                } else {
                    this.dataCollector.setCompetitor(null);
                }
                this.retrieveEvent(this.place.getEventId());
            }
        } else if (QRCodePlace.isPublicInviteRequest()) {
            logger.info("QR Code for public regatta invite to be shown");
            this.dataCollector = new DataCollector(this, view);
            DataCollector.access$0((DataCollector)this.dataCollector);
        } else if (QRCodePlace.isRaceManagerAppRequest()) {
            logger.info("QR Code for race manager app to be shown");
            this.dataCollector = new DataCollector(this, view);
            DataCollector.access$0((DataCollector)this.dataCollector);
        } else {
            logger.severe("QR Code cannot be created. Request type cannot be identified.");
        }
    }

    private void retrieveMark(UUID markId) {
        logger.info("retrieving mark: " + markId);
        this.clientFactory.getSailingService().getMark(markId, this.place.getLeaderboardName(), this.place.getRegattaRegistrationLinkSecret(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void retrieveBoat(UUID boatId) {
        logger.info("retrieving boat: " + boatId);
        this.clientFactory.getSailingService().getBoat(boatId, this.place.getLeaderboardName(), this.place.getRegattaRegistrationLinkSecret(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void retrieveEvent(UUID eventId) {
        logger.info("retrieving event: " + eventId);
        this.clientFactory.getSailingService().getEvent(eventId, this.place.getLeaderboardName(), this.place.getRegattaRegistrationLinkSecret(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void retrieveCompetitor(UUID competitorId) {
        logger.info("retrieving competitor: " + competitorId);
        this.clientFactory.getSailingService().getCompetitor(competitorId, this.place.getLeaderboardName(), this.place.getRegattaRegistrationLinkSecret(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ QRCodePlace access$1(QRCodePresenter qRCodePresenter) {
        return qRCodePresenter.place;
    }

    static /* synthetic */ String access$2(QRCodePresenter qRCodePresenter, Util.Triple triple) {
        return qRCodePresenter.getCorrectUrl(triple);
    }

    static /* synthetic */ DataCollector access$3(QRCodePresenter qRCodePresenter) {
        return qRCodePresenter.dataCollector;
    }
}

