/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.qrcode;

import com.google.gwt.user.client.Window;
import com.sap.sailing.domain.common.MailInvitationType;
import com.sap.sailing.gwt.home.desktop.places.qrcode.QRCodePlace;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.AbstractBasePlace;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class QRCodePlace
extends AbstractBasePlace {
    private static final Logger logger = Logger.getLogger(QRCodePlace.class.getName());
    private static final String PARAM_REGATTA_NAME = "regatta_name";
    private static final String PARAM_REGATTA_SECRET = "secret";
    private static final String PARAM_MODE = "mode";
    private static final String PARAM_SERVER = "server";
    private static final String PARAM_SERVER_URL = "server_url";
    private static final String PARAM_DEVICE_CONFIG_ID = "device_config_identifier";
    private static final String PARAM_DEVICE_CONFIG_UUID = "device_config_uuid";
    private static final String PARAM_TOKEN = "token";
    private UUID eventId;
    private UUID competitorId;
    private UUID boatId;
    private UUID markId;
    private String leaderboardName;
    private String publicRegattaName;
    private String regattaRegistrationLinkSecret;
    private InvitationMode mode;
    private String rawCheckInUrl;
    private String targetServer;
    private String serverUrl;
    private String deviceConfigIdentifier;
    private String deviceConfigUuid;
    private String token;

    public QRCodePlace(String token) {
        super(token);
        try {
            this.mode = InvitationMode.valueOf((String)this.getParameter("mode"));
            this.targetServer = Window.Location.getParameter((String)"server");
            if (QRCodePlace.isPublicInviteRequest()) {
                this.publicRegattaName = Window.Location.getParameter((String)"regatta_name");
                this.regattaRegistrationLinkSecret = Window.Location.getParameter((String)"secret");
                if (this.publicRegattaName == null || this.regattaRegistrationLinkSecret == null || this.targetServer == null) {
                    logger.severe("Missing parameter for regatta, secret or server");
                }
            } else if (QRCodePlace.isRaceManagerAppRequest()) {
                this.targetServer = this.serverUrl = Window.Location.getParameter((String)"server_url");
                this.deviceConfigIdentifier = Window.Location.getParameter((String)"device_config_identifier");
                this.deviceConfigUuid = Window.Location.getParameter((String)"device_config_uuid");
                token = Window.Location.getParameter((String)"token");
            } else {
                this.rawCheckInUrl = Window.Location.getParameter((String)"checkinUrl");
                if (this.rawCheckInUrl != null) {
                    this.parseUrl(this.rawCheckInUrl);
                    if (this.leaderboardName == null) {
                        logger.severe("No parameter leaderboard_name found!");
                    }
                    if (this.competitorId == null && (this.mode == InvitationMode.COMPETITOR || this.mode == InvitationMode.COMPETITOR_2)) {
                        logger.severe("No parameter competitor_id found!");
                    }
                    if (this.boatId == null && (this.mode == InvitationMode.COMPETITOR || this.mode == InvitationMode.COMPETITOR_2)) {
                        logger.severe("No parameter boat_id found!");
                    }
                    if (this.markId == null && (this.mode == InvitationMode.COMPETITOR || this.mode == InvitationMode.COMPETITOR_2)) {
                        logger.severe("No parameter mark_id found!");
                    }
                    if ((this.competitorId != null || this.boatId != null || this.markId != null) && this.mode == InvitationMode.BOUY_TENDER) {
                        logger.warning("Found parameter competitor_id will be ignored in bouy tender mode!");
                    }
                    if (this.eventId == null) {
                        logger.severe("No parameter event_id found!");
                    }
                } else {
                    logger.severe("No parameter checkinUrl found!");
                }
            }
        }
        catch (Exception e) {
            logger.severe("No parameter mode found, or value not valid");
        }
    }

    private native String decodeUrl(String var1);

    private native String encodeUrl(String var1);

    private void parseUrl(String checkInUrl) {
        Iterable parameters = this.parseServerNameAndReturnUrlParameters(checkInUrl);
        for (Util.Pair parameter : parameters) {
            if ("event_id".equals(parameter.getA())) {
                try {
                    this.eventId = UUID.fromString((String)parameter.getB());
                }
                catch (IllegalArgumentException e) {
                    logger.severe("Invalid event_id");
                    this.eventId = null;
                }
                continue;
            }
            if ("competitor_id".equals(parameter.getA())) {
                try {
                    this.competitorId = UUID.fromString((String)parameter.getB());
                }
                catch (IllegalArgumentException e) {
                    logger.severe("Invalid competitor_id");
                    this.competitorId = null;
                }
                continue;
            }
            if ("boat_id".equals(parameter.getA())) {
                try {
                    this.boatId = UUID.fromString((String)parameter.getB());
                }
                catch (IllegalArgumentException e) {
                    logger.severe("Invalid boat_id");
                    this.boatId = null;
                }
                continue;
            }
            if ("mark_id".equals(parameter.getA())) {
                try {
                    this.markId = UUID.fromString((String)parameter.getB());
                }
                catch (IllegalArgumentException e) {
                    logger.severe("Invalid mark_id");
                    this.boatId = null;
                }
                continue;
            }
            if ("leaderboard_name".equals(parameter.getA())) {
                this.leaderboardName = (String)parameter.getB();
                continue;
            }
            if (!"secret".equals(parameter.getA())) continue;
            this.regattaRegistrationLinkSecret = (String)parameter.getB();
        }
    }

    private Iterable<Util.Pair<String, String>> parseServerNameAndReturnUrlParameters(String checkInUrl) {
        String[] urlArguments = checkInUrl.split("\\?");
        String targetServerWithPath = urlArguments[0];
        this.targetServer = targetServerWithPath.replace("/tracking/checkin", "");
        this.targetServer = this.targetServer.replace("/buoy-tender/checkin", "");
        ArrayList<Util.Pair<String, String>> pairs = new ArrayList<Util.Pair<String, String>>();
        if (urlArguments.length < 2) {
            logger.severe("No parameters found!");
        } else {
            String[] urlParams;
            String[] stringArray = urlParams = urlArguments[1].split("&");
            int n = urlParams.length;
            int n2 = 0;
            while (n2 < n) {
                String urlParam = stringArray[n2];
                String[] param = urlParam.split("=");
                Util.Pair pair = new Util.Pair((Object)param[0], (Object)this.decodeUrl(param[1].replace("+", "%20")));
                pairs.add((Util.Pair<String, String>)pair);
                ++n2;
            }
        }
        return pairs;
    }

    public String getPublicInviteBranchIOUrl(MailInvitationType mailInvitationType) {
        return String.valueOf(mailInvitationType.getBranchIOopenRegattaURL()) + "?" + "regatta_name" + "=" + this.encodeUrl(this.publicRegattaName) + "&" + "secret" + "=" + this.encodeUrl(this.regattaRegistrationLinkSecret) + "&" + "server" + "=" + this.encodeUrl(this.targetServer);
    }

    public String getRaceManagerAppUrl() {
        String url;
        if (this.serverUrl != null && this.deviceConfigIdentifier != null && this.deviceConfigUuid != null) {
            url = "https://racemanager-app.sapsailing.com/invite?server_url=" + this.encodeUrl(this.serverUrl) + "&" + "device_config_identifier" + "=" + this.encodeUrl(this.deviceConfigIdentifier) + "&" + "device_config_uuid" + "=" + this.encodeUrl(this.deviceConfigUuid);
            if (this.token != null) {
                url = String.valueOf(url) + "&token=" + this.encodeUrl(this.token);
            }
        } else {
            url = null;
        }
        return url;
    }

    public InvitationMode getMode() {
        return this.mode;
    }

    public String getEncodedCheckInUrl() {
        return this.encodeUrl(this.rawCheckInUrl);
    }

    public UUID getEventId() {
        return this.eventId;
    }

    public UUID getCompetitorId() {
        return this.competitorId;
    }

    public UUID getBoatId() {
        return this.boatId;
    }

    public String getLeaderboardName() {
        return this.leaderboardName;
    }

    public String getPublicRegattaName() {
        return this.publicRegattaName;
    }

    public UUID getMarkId() {
        return this.markId;
    }

    public String getRegattaRegistrationLinkSecret() {
        return this.regattaRegistrationLinkSecret;
    }

    public String getTargetServer() {
        return this.targetServer;
    }

    public String toString() {
        return "QRCodePlace [eventId=" + this.eventId + ", competitorId=" + this.competitorId + ", boatId=" + this.boatId + ", markId=" + this.markId + ", leaderboardName=" + this.leaderboardName + ", publicRegattaName=" + this.publicRegattaName + ", regattaRegistrationLinkSecret=" + this.regattaRegistrationLinkSecret + ", mode=" + this.mode + ", rawCheckInUrl=" + this.rawCheckInUrl + ", targetServer=" + this.targetServer + ", serverUrl=" + this.serverUrl + ", deviceConfigIdentifier=" + this.deviceConfigIdentifier + ", deviceConfigUuid=" + this.deviceConfigUuid + ", token=" + this.token + "]";
    }

    static boolean isCompetitorOrBoatRequest() {
        return Window.Location.getParameter((String)"checkinUrl") != null;
    }

    static boolean isPublicInviteRequest() {
        return Window.Location.getParameter((String)"regatta_name") != null && Window.Location.getParameter((String)"secret") != null && Window.Location.getParameter((String)"server") != null;
    }

    static boolean isRaceManagerAppRequest() {
        return Window.Location.getParameter((String)"server_url") != null && Window.Location.getParameter((String)"device_config_identifier") != null && Window.Location.getParameter((String)"device_config_uuid") != null;
    }
}

