/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.places.event;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.place.shared.Place;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.common.client.controls.tabbar.TabView;
import com.sap.sailing.gwt.home.communication.SailingDispatchSystem;
import com.sap.sailing.gwt.home.communication.event.EventSeriesReferenceDTO;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.eventview.EventViewDTO;
import com.sap.sailing.gwt.home.communication.eventview.HasRegattaMetadata;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.communication.eventview.SeriesReferenceWithEventsDTO;
import com.sap.sailing.gwt.home.communication.media.GetMediaForEventAction;
import com.sap.sailing.gwt.home.communication.media.MediaDTO;
import com.sap.sailing.gwt.home.communication.race.RaceMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.desktop.app.DesktopPlacesNavigator;
import com.sap.sailing.gwt.home.desktop.partials.racelist.RaceListDataUtil;
import com.sap.sailing.gwt.home.desktop.places.event.EventClientFactory;
import com.sap.sailing.gwt.home.desktop.places.event.EventView;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.AbstractEventRegattaPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.leaderboardtab.RegattaLeaderboardPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.overviewtab.RegattaOverviewPlace;
import com.sap.sailing.gwt.home.desktop.places.event.regatta.racestab.RegattaRacesPlace;
import com.sap.sailing.gwt.home.shared.app.ApplicationHistoryMapper;
import com.sap.sailing.gwt.home.shared.app.NavigationPathDisplay;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.places.event.AbstractEventPlace;
import com.sap.sailing.gwt.home.shared.places.event.EventContext;
import com.sap.sailing.gwt.home.shared.places.event.EventDefaultPlace;
import com.sap.sailing.gwt.home.shared.places.events.EventsPlace;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesContext;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesDefaultPlace;
import com.sap.sailing.gwt.home.shared.places.start.StartPlace;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.settings.client.regattaoverview.RegattaOverviewContextDefinition;
import com.sap.sailing.gwt.settings.client.regattaoverview.RegattaRaceStatesSettings;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.refresh.ErrorAndBusyClientFactory;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.subscription.SubscriptionServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public abstract class AbstractEventActivity<PLACE extends AbstractEventPlace>
extends AbstractActivity
implements EventView.Presenter {
    protected final PLACE currentPlace;
    protected final EventContext ctx;
    protected final EventClientFactory clientFactory;
    private final Timer timerForClientServerOffset;
    protected final DesktopPlacesNavigator homePlacesNavigator;
    private static final ApplicationHistoryMapper historyMapper = (ApplicationHistoryMapper)GWT.create(ApplicationHistoryMapper.class);
    protected final EventViewDTO eventDTO;

    public AbstractEventActivity(PLACE place, EventViewDTO eventDTO, EventClientFactory clientFactory, DesktopPlacesNavigator homePlacesNavigator) {
        this.currentPlace = place;
        this.eventDTO = eventDTO;
        this.homePlacesNavigator = homePlacesNavigator;
        this.ctx = new EventContext(place.getCtx());
        this.timerForClientServerOffset = new Timer(Timer.PlayModes.Replay);
        this.clientFactory = clientFactory;
    }

    protected final List<NavigationPathDisplay.NavigationItem> getNavigationPathToEventLevel() {
        ArrayList<NavigationPathDisplay.NavigationItem> navItems = new ArrayList<NavigationPathDisplay.NavigationItem>();
        navItems.add(new NavigationPathDisplay.NavigationItem(StringMessages.INSTANCE.home(), this.getHomeNavigation()));
        navItems.add(new NavigationPathDisplay.NavigationItem(StringMessages.INSTANCE.events(), this.getEventsNavigation()));
        SeriesReferenceWithEventsDTO seriesData = this.getEventDTO().getSeriesData();
        if (seriesData != null) {
            navItems.add(new NavigationPathDisplay.NavigationItem(seriesData.getSeriesDisplayName(), this.getCurrentEventSeriesNavigation()));
        }
        navItems.add(new NavigationPathDisplay.NavigationItem(this.getEventDTO().getLocationOrDisplayName(), this.getCurrentEventNavigation()));
        return navItems;
    }

    public SailingDispatchSystem getDispatch() {
        return this.clientFactory.getDispatch();
    }

    public ErrorAndBusyClientFactory getErrorAndBusyClientFactory() {
        return this.clientFactory;
    }

    public EventContext getCtx() {
        return this.ctx;
    }

    public void handleTabPlaceSelection(TabView<?, ? extends EventView.Presenter> selectedActivity) {
        Place tabPlaceToGo = selectedActivity.placeToFire();
        this.clientFactory.getPlaceController().goTo(tabPlaceToGo);
    }

    public void navigateTo(Place place) {
        this.clientFactory.getPlaceController().goTo(place);
    }

    public SafeUri getUrl(AbstractEventPlace place) {
        String token = historyMapper.getToken((Place)place);
        return UriUtils.fromString((String)("#" + token));
    }

    public HasRegattaMetadata getRegattaMetadata() {
        return null;
    }

    public Timer getTimerForClientServerOffset() {
        return this.timerForClientServerOffset;
    }

    public AbstractEventRegattaPlace getPlaceForRegatta(String regattaId) {
        return new RegattaOverviewPlace(this.contextForRegatta(regattaId));
    }

    public RegattaRacesPlace getPlaceForRegattaRaces(String regattaId) {
        return new RegattaRacesPlace(this.contextForRegatta(regattaId));
    }

    public RegattaLeaderboardPlace getPlaceForRegattaLeaderboard(String regattaId) {
        return new RegattaLeaderboardPlace(this.contextForRegatta(regattaId));
    }

    protected EventContext contextForRegatta(String regattaId) {
        return new EventContext(this.ctx).withRegattaId(regattaId).withRegattaAnalyticsManager(null);
    }

    public String getRaceViewerURL(SimpleRaceMetadataDTO raceMetadata, String mode) {
        return this.getRaceViewerURL(raceMetadata.getLeaderboardName(), raceMetadata.getLeaderboardGroupName(), raceMetadata.getLeaderboardGroupId(), raceMetadata.getRegattaAndRaceIdentifier(), mode);
    }

    public String getRaceViewerURL(String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId, RegattaAndRaceIdentifier raceIdentifier) {
        return this.getRaceViewerURL(leaderboardName, leaderboardGroupName, leaderboardGroupId, raceIdentifier, null);
    }

    private String getRaceViewerURL(String leaderboardName, String leaderboardGroupName, UUID leaderboardGroupId, RegattaAndRaceIdentifier raceIdentifier, String mode) {
        RaceboardContextDefinition raceboardContext = new RaceboardContextDefinition(raceIdentifier.getRegattaName(), raceIdentifier.getRaceName(), leaderboardName, leaderboardGroupName, leaderboardGroupId, UUID.fromString(this.ctx.getEventId()), mode);
        RaceBoardPerspectiveOwnSettings perspectiveOwnSettings = new RaceBoardPerspectiveOwnSettings();
        HashMap<String, RaceMapSettings> innerSettings = new HashMap<String, RaceMapSettings>();
        innerSettings.put("rm", RaceMapSettings.getDefaultWithShowMapControls((boolean)true));
        PerspectiveCompositeSettings settings = new PerspectiveCompositeSettings((Settings)perspectiveOwnSettings, innerSettings);
        return EntryPointWithSettingsLinkFactory.createRaceBoardLink((RaceboardContextDefinition)raceboardContext, (PerspectiveCompositeSettings)settings);
    }

    public String getMapAndWindChartUrl(String leaderboardName, String raceName, String fleetName) {
        return EntryPointWithSettingsLinkFactory.createEmbeddedMapAndWindChartLink((String)leaderboardName, (String)raceName, (String)fleetName);
    }

    public String getMapAndWindChartUrl(RaceMetadataDTO<?> metadata) {
        return EntryPointWithSettingsLinkFactory.createEmbeddedMapAndWindChartLink((String)metadata.getLeaderboardName(), (String)metadata.getRaceName(), (String)RaceListDataUtil.getFleetName(metadata));
    }

    public PlaceNavigation<StartPlace> getHomeNavigation() {
        return this.homePlacesNavigator.getHomeNavigation();
    }

    public PlaceNavigation<EventsPlace> getEventsNavigation() {
        return this.homePlacesNavigator.getEventsNavigation();
    }

    public PlaceNavigation<EventDefaultPlace> getCurrentEventNavigation() {
        return this.homePlacesNavigator.getEventNavigation(this.ctx.getEventId(), null, false);
    }

    protected PlaceNavigation<SeriesDefaultPlace> getEventSeriesNavigation(EventSeriesReferenceDTO seriesReference) {
        if (seriesReference != null) {
            UUID seriesLeaderboardGroupId = seriesReference.getSeriesLeaderboardGroupId();
            return this.homePlacesNavigator.getEventSeriesNavigation(SeriesContext.createWithLeaderboardGroupId((UUID)seriesLeaderboardGroupId), null, false);
        }
        return null;
    }

    public PlaceNavigation<RegattaRacesPlace> getRegattaRacesNavigation(String regattaId) {
        return this.homePlacesNavigator.getEventNavigation((AbstractEventPlace)this.getPlaceForRegattaRaces(regattaId), null, false);
    }

    public PlaceNavigation<AbstractEventRegattaPlace> getRegattaNavigation(String regattaId) {
        return this.homePlacesNavigator.getEventNavigation((AbstractEventPlace)this.getPlaceForRegatta(regattaId), null, false);
    }

    public PlaceNavigation<RegattaLeaderboardPlace> getRegattaLeaderboardNavigation(String regattaId) {
        return this.homePlacesNavigator.getEventNavigation((AbstractEventPlace)this.getPlaceForRegattaLeaderboard(regattaId), null, false);
    }

    public UserService getUserService() {
        return this.clientFactory.getUserService();
    }

    public SubscriptionServiceFactory getSubscriptionServiceFactory() {
        return this.clientFactory.getSubscriptionServiceFactory();
    }

    public void ensureMedia(AsyncCallback<MediaDTO> callback) {
        this.getDispatch().execute((Action)new GetMediaForEventAction(this.eventDTO.getId()), callback);
    }

    public boolean hasMedia() {
        if (this.showRegattaMetadata()) {
            return false;
        }
        return this.eventDTO.isHasMedia();
    }

    public String getRegattaOverviewLink() {
        RegattaRaceStatesSettings regattaRaceStatesSettings = new RegattaRaceStatesSettings();
        regattaRaceStatesSettings.setShowOnlyCurrentlyRunningRaces(false);
        regattaRaceStatesSettings.setShowOnlyRaceOfSameDay(this.eventDTO.isRunning());
        if (this.showRegattaMetadata()) {
            if (this.getRegattaMetadata().isFlexibleLeaderboard()) {
                for (String defaultCourseAreaId : this.getRegattaMetadata().getCourseAreaIdsAsStrings()) {
                    regattaRaceStatesSettings.getVisibleCourseAreaSettings().addValue((Object)UUID.fromString(defaultCourseAreaId));
                }
            } else {
                regattaRaceStatesSettings.getVisibleRegattaSettings().addValue((Object)this.getRegattaId());
            }
        }
        return EntryPointWithSettingsLinkFactory.createRegattaOverviewLink((RegattaOverviewContextDefinition)new RegattaOverviewContextDefinition(this.getCtx().getEventId()), (RegattaRaceStatesSettings)regattaRaceStatesSettings, (boolean)false);
    }

    public boolean isEventOrRegattaLive() {
        return this.eventDTO.getState() == EventState.RUNNING;
    }

    public String getRegattaId() {
        String regattaId = this.currentPlace.getRegattaId();
        if (regattaId != null) {
            return regattaId;
        }
        if (!this.eventDTO.getRegattas().isEmpty() && !this.eventDTO.isMultiRegatta()) {
            return ((RegattaMetadataDTO)this.eventDTO.getRegattas().iterator().next()).getId();
        }
        return null;
    }

    public EventViewDTO getEventDTO() {
        return this.eventDTO;
    }

    protected abstract EventView<PLACE, ?> getView();
}

