/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.subscription;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.desktop.partials.subscription.SubscriptionCard;
import com.sap.sailing.gwt.home.desktop.partials.subscription.SubscriptionCardContainer;
import com.sap.sailing.gwt.home.desktop.partials.subscription.SubscriptionCardResources;
import com.sap.sailing.gwt.home.desktop.resources.SharedDesktopResources;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.security.shared.subscription.SubscriptionPlan;
import com.sap.sse.security.ui.client.i18n.subscription.SubscriptionStringConstants;
import java.util.ArrayList;
import java.util.MissingResourceException;

public class SubscriptionCardContainer
extends Composite {
    private static final String SUPPORT_EMAIL = "support@sapsailing.com";
    private static SubscriptionContainerUiBinder uiBinder = (SubscriptionContainerUiBinder)GWT.create(SubscriptionContainerUiBinder.class);
    private static final SubscriptionStringConstants i18n = SubscriptionStringConstants.INSTANCE;
    private static final int TITLE_DESCRIPTION_ROW = 0;
    @UiField
    Button businessModelInfoButton;
    @UiField
    Button emailContact;
    @UiField
    FlowPanel container;
    @UiField
    FlowPanel features;
    final Grid featureGrid;

    public SubscriptionCardContainer() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.featureGrid = new Grid(2, 5);
        int rowIndex = 0;
        for (SubscriptionPlan.PlanCategory category : SubscriptionPlan.PlanCategory.getCategoriesWithFeature()) {
            Label title = new Label(i18n.getString(String.valueOf(category.getId()) + "_name"));
            this.featureGrid.setWidget(0, ++rowIndex, (Widget)title);
            this.featureGrid.getCellFormatter().addStyleName(0, rowIndex, SubscriptionCardResources.INSTANCE.css().featureHeader());
        }
        for (String featureId : SubscriptionPlan.PlanCategory.getAllFeatureIds()) {
            this.addFeature(featureId);
        }
        this.features.add((Widget)this.featureGrid);
        this.emailContact.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addFeature(String featureId) {
        int currentRowIndex = this.featureGrid.getRowCount();
        this.featureGrid.resizeRows(currentRowIndex + 1);
        VerticalPanel line = new VerticalPanel();
        String titleString = i18n.getString(String.valueOf(featureId) + "_title");
        String descriptionString = i18n.getString(String.valueOf(featureId) + "_description");
        Label title = new Label(titleString);
        title.addStyleName(SubscriptionCardResources.INSTANCE.css().featureTitle());
        line.add((Widget)title);
        try {
            String urlString = i18n.getString(String.valueOf(featureId) + "_url");
            SimplePanel descriptionWithLink = new SimplePanel();
            HTML exampleLink = new HTML(String.valueOf(descriptionString) + "&nbsp;<a href=\"" + new SafeHtmlBuilder().appendEscaped(urlString).toSafeHtml().asString() + "\" title=\"" + StringMessages.INSTANCE.moreInfo() + "\"" + " class=\"" + SubscriptionCardResources.INSTANCE.css().featureLink() + "\"" + "target=\"_blank\">" + new SafeHtmlBuilder().appendEscaped("\u24d8").toSafeHtml().asString() + "</a>");
            descriptionWithLink.addStyleName(SubscriptionCardResources.INSTANCE.css().featureDescription());
            descriptionWithLink.add((Widget)exampleLink);
            line.add((Widget)descriptionWithLink);
        }
        catch (MissingResourceException e) {
            Label description = new Label(descriptionString);
            description.addStyleName(SubscriptionCardResources.INSTANCE.css().featureDescription());
            line.add((Widget)description);
        }
        this.featureGrid.setWidget(currentRowIndex, 0, (Widget)line);
        int columnIndex = 0;
        for (SubscriptionPlan.PlanCategory category : SubscriptionPlan.PlanCategory.getCategoriesWithFeature()) {
            this.createCheckMark(currentRowIndex, ++columnIndex, category.containsFeature(featureId));
        }
    }

    private void createCheckMark(int currentRowIndex, int column, boolean checkState) {
        FlowPanel check = new FlowPanel();
        if (checkState) {
            check.add((Widget)new Image(SharedDesktopResources.INSTANCE.dropdownCheck().getSafeUri()));
            check.addStyleName(SubscriptionCardResources.INSTANCE.css().featureCheck());
        } else {
            check.add((Widget)new Label("-"));
            check.addStyleName(SubscriptionCardResources.INSTANCE.css().featureNone());
        }
        this.featureGrid.setWidget(currentRowIndex, column, (Widget)check);
    }

    public void addSubscription(SubscriptionCard subscription) {
        if (!this.isSubscriptionPlanExisting(subscription.getSubscriptionGroupDTO().getSubscriptionGroupId())) {
            this.container.add((Widget)subscription);
        }
    }

    private boolean isSubscriptionPlanExisting(String planId) {
        boolean isExisting = false;
        int i = 0;
        while (i < this.container.getWidgetCount()) {
            SubscriptionCard card;
            if (this.container.getWidget(i) instanceof SubscriptionCard && (card = (SubscriptionCard)this.container.getWidget(i)).getSubscriptionGroupDTO().getSubscriptionGroupId().equals(planId)) {
                isExisting = true;
                break;
            }
            ++i;
        }
        return isExisting;
    }

    public void resetSubscriptions() {
        ArrayList<SubscriptionCard> subscriptionCardsToRemove = new ArrayList<SubscriptionCard>();
        int i = 0;
        while (i < this.container.getWidgetCount()) {
            if (this.container.getWidget(i) instanceof SubscriptionCard) {
                subscriptionCardsToRemove.add((SubscriptionCard)this.container.getWidget(i));
            }
            ++i;
        }
        for (SubscriptionCard card : subscriptionCardsToRemove) {
            this.container.remove((Widget)card);
        }
    }

    @UiHandler(value={"businessModelInfoButton"})
    void onClick(ClickEvent e) {
        VerticalPanel content = new VerticalPanel();
        HTMLPanel title = new HTMLPanel("h1", i18n.businessModelTitle());
        content.add((Widget)title);
        Label body = new Label(i18n.businessModelDescription());
        content.add((Widget)body);
        PopupPanel popup = new PopupPanel();
        popup.setWidget((Widget)content);
        popup.addStyleName(SubscriptionCardResources.INSTANCE.css().popupContent());
        popup.setGlassStyleName(SubscriptionCardResources.INSTANCE.css().popupGlass());
        popup.setAnimationEnabled(true);
        popup.setAnimationType(PopupPanel.AnimationType.CENTER);
        popup.setGlassEnabled(true);
        popup.setModal(true);
        popup.setAutoHideEnabled(true);
        popup.addAutoHidePartner((Element)this.businessModelInfoButton.getElement());
        popup.center();
    }

    static /* synthetic */ SubscriptionStringConstants access$0() {
        return i18n;
    }
}

