/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.seriesheader;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.event.HasLogo;
import com.sap.sailing.gwt.home.communication.event.LabelType;
import com.sap.sailing.gwt.home.communication.fakeseries.EventSeriesViewDTO;
import com.sap.sailing.gwt.home.desktop.partials.seriesheader.SeriesHeader;
import com.sap.sailing.gwt.home.desktop.partials.seriesheader.SeriesHeaderResources;
import com.sap.sailing.gwt.home.desktop.partials.sharing.EventHeaderSharingButtons;
import com.sap.sailing.gwt.home.desktop.places.fakeseries.SeriesView;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.partials.shared.SharingMetadataProvider;
import com.sap.sailing.gwt.home.shared.utils.LabelTypeUtil;
import com.sap.sailing.gwt.home.shared.utils.LogoUtil;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.LinkUtil;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;

public class SeriesHeader
extends Composite {
    private static SeriesHeaderUiBinder uiBinder = (SeriesHeaderUiBinder)GWT.create(SeriesHeaderUiBinder.class);
    @UiField
    StringMessages i18n;
    @UiField
    DivElement eventLogo;
    @UiField(provided=true)
    MediaMenuIcon seriesLogoMenuButton;
    @UiField
    SpanElement eventName;
    @UiField
    DivElement eventState;
    @UiField
    FlowPanel venues;
    @UiField
    EventHeaderSharingButtons sharing;
    private EventSeriesViewDTO series;
    private SeriesView.Presenter presenter;
    boolean dropdownShown = false;

    public SeriesHeader(SeriesView.Presenter presenter) {
        this.series = presenter.getSeriesDTO();
        this.presenter = presenter;
        SeriesHeaderResources.INSTANCE.css().ensureInjected();
        this.seriesLogoMenuButton = new MediaMenuIcon((TakedownNoticeService)presenter.getUserService(), "takedownRequestForLogoImage");
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initFields();
        this.initSharing();
    }

    private void initSharing() {
        this.sharing.setUp((SharingMetadataProvider)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initFields() {
        LogoUtil.setEventLogo((Element)this.eventLogo, (HasLogo)this.series, (MediaMenuIcon)this.seriesLogoMenuButton);
        this.eventName.setInnerText(this.series.getDisplayName());
        LabelTypeUtil.renderLabelType((Element)this.eventState, (LabelType)this.series.getState().getStateMarker());
        for (EventAndLeaderboardReferenceWithStateDTO eventOfSeries : this.series.getEventsAndRegattasOfSeriesAscending()) {
            if (eventOfSeries.getState() == EventState.PLANNED) {
                InlineLabel eventLabel = new InlineLabel(eventOfSeries.getDisplayName());
                eventLabel.addStyleName(SeriesHeaderResources.INSTANCE.css().eventheader_intro_details_item());
                eventLabel.addStyleName(SeriesHeaderResources.INSTANCE.css().eventheader_intro_details_item_inactive());
                this.venues.add((Widget)eventLabel);
                continue;
            }
            Anchor eventAnchor = new Anchor(eventOfSeries.getDisplayName());
            eventAnchor.addStyleName(SeriesHeaderResources.INSTANCE.css().eventheader_intro_details_item());
            PlaceNavigation regattaNavigation = this.presenter.getRegattaNavigation(eventOfSeries.getId(), eventOfSeries.getLeaderboardName());
            eventAnchor.setHref(regattaNavigation.getTargetUrl());
            this.venues.add((Widget)eventAnchor);
            eventAnchor.addClickHandler(event -> {
                if (LinkUtil.handleLinkClick((Event)Event.as((NativeEvent)event.getNativeEvent()))) {
                    event.preventDefault();
                    regattaNavigation.goToPlace();
                }
            });
        }
    }

    static /* synthetic */ EventSeriesViewDTO access$0(SeriesHeader seriesHeader) {
        return seriesHeader.series;
    }

    static /* synthetic */ SeriesView.Presenter access$1(SeriesHeader seriesHeader) {
        return seriesHeader.presenter;
    }
}

