/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.racelist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.race.RaceMetadataDTO;
import com.sap.sailing.gwt.home.desktop.partials.racelist.AbstractRaceList;
import com.sap.sailing.gwt.home.desktop.partials.racelist.RaceListContainer;
import com.sap.sailing.gwt.home.desktop.partials.racelist.RaceListResources;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sse.gwt.dispatch.shared.commands.CollectionResult;
import java.util.Collection;

public class RaceListContainer<T extends RaceMetadataDTO<?>>
extends Composite
implements RefreshableWidget<CollectionResult<T>> {
    private static RaceListContainerUiBinder uiBinder = (RaceListContainerUiBinder)GWT.create(RaceListContainerUiBinder.class);
    @UiField
    HeadingElement titleUi;
    @UiField
    DivElement infoUi;
    @UiField
    DivElement noContentPlaceholderUi;
    @UiField(provided=true)
    AbstractRaceList<T> raceListUi;
    @UiField
    DivElement iconWind;
    @UiField
    DivElement iconVideo;
    @UiField
    DivElement iconAudio;
    private String noContentPlaceholderText;

    public RaceListContainer(String title, AbstractRaceList<T> raceList) {
        this(title, null, raceList);
    }

    public RaceListContainer(String title, String noContentPlaceholderText, AbstractRaceList<T> raceList) {
        this.noContentPlaceholderText = noContentPlaceholderText;
        RaceListResources.INSTANCE.css().ensureInjected();
        this.raceListUi = raceList;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.titleUi.setInnerText(title);
        this.raceListUi.setVisible(false);
    }

    public void setData(CollectionResult<T> data) {
        this.setRaceListData(data == null ? null : data.getValues());
    }

    public void setRaceListData(Collection<T> data) {
        if (data == null || data.isEmpty()) {
            if (this.noContentPlaceholderText == null) {
                this.getElement().getStyle().setDisplay(Style.Display.NONE);
            } else {
                this.noContentPlaceholderUi.setInnerText(this.noContentPlaceholderText);
                this.noContentPlaceholderUi.getStyle().clearDisplay();
                this.raceListUi.setVisible(false);
            }
            this.iconWind.getStyle().setDisplay(Style.Display.NONE);
            this.iconVideo.getStyle().setDisplay(Style.Display.NONE);
            this.iconAudio.getStyle().setDisplay(Style.Display.NONE);
        } else {
            this.noContentPlaceholderUi.getStyle().setDisplay(Style.Display.NONE);
            this.getElement().getStyle().clearDisplay();
            this.raceListUi.setVisible(true);
            this.raceListUi.setTableData(data);
            this.iconWind.getStyle().setDisplay(this.raceListUi.hasWind() ? Style.Display.INLINE_BLOCK : Style.Display.NONE);
            this.iconVideo.getStyle().setDisplay(this.raceListUi.hasVideos() ? Style.Display.INLINE_BLOCK : Style.Display.NONE);
            this.iconAudio.getStyle().setDisplay(this.raceListUi.hasAudios() ? Style.Display.INLINE_BLOCK : Style.Display.NONE);
        }
    }

    public void setInfoText(String infoText) {
        this.infoUi.setInnerText(infoText);
        this.infoUi.getStyle().clearDisplay();
    }
}

