/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.racelist;

import com.sap.sailing.gwt.home.communication.race.RaceMetadataDTO;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.InvertibleComparatorAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RaceListColumnComparator<R extends RaceMetadataDTO<?>, S extends Comparable<S>>
extends InvertibleComparatorAdapter<R> {
    private List<R> racesInNaturalOrder = null;
    private final Map<R, Integer> positionInNaturalOrder = new HashMap();

    public int compare(R o1, R o2) {
        int compareResult;
        if (this.getValue(o1) == this.getValue(o2)) {
            compareResult = 0;
        } else {
            if (this.getValue(o1) == null) {
                return this.isAscending() ? 1 : -1;
            }
            if (this.getValue(o2) == null) {
                return this.isAscending() ? -1 : 1;
            }
            compareResult = this.getValue(o1).compareTo(this.getValue(o2));
        }
        if (compareResult == 0) {
            compareResult = this.compareByNaturalOrder(o1, o2);
        }
        if (compareResult == 0) {
            compareResult = o1.compareTo(o2);
        }
        return compareResult;
    }

    protected int compareByNaturalOrder(R o1, R o2) {
        int compareResult;
        if (this.racesInNaturalOrder != null) {
            this.getAndCacheIndexInNaturalOrder(o1);
            compareResult = Util.compareToWithNull((Comparable)this.getAndCacheIndexInNaturalOrder(o1), (Comparable)this.getAndCacheIndexInNaturalOrder(o2), (!this.isAscending() ? 1 : 0) != 0);
        } else {
            compareResult = 0;
        }
        return compareResult;
    }

    private Integer getAndCacheIndexInNaturalOrder(R o) {
        Integer i = (Integer)this.positionInNaturalOrder.get(o);
        if (i == null) {
            i = this.racesInNaturalOrder.indexOf(o);
            this.positionInNaturalOrder.put(o, i);
        }
        return i;
    }

    public abstract S getValue(R var1);

    public void setRacesInNaturalOrder(List<R> racesInNaturalOrder) {
        this.racesInNaturalOrder = racesInNaturalOrder;
        this.positionInNaturalOrder.clear();
    }
}

