/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.racelist;

import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.HeaderBuilder;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.theme.component.celltable.CleanCellTableResources;
import com.sap.sailing.gwt.common.theme.component.celltable.StyledHeaderOrFooterBuilder;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.race.RaceMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.wind.AbstractWindDTO;
import com.sap.sailing.gwt.home.desktop.partials.racelist.RaceListColumnFactory;
import com.sap.sailing.gwt.home.desktop.partials.racelist.RaceListColumnSet;
import com.sap.sailing.gwt.home.desktop.partials.racelist.RaceListResources;
import com.sap.sailing.gwt.home.desktop.partials.racelist.SortableRaceListColumn;
import com.sap.sailing.gwt.home.desktop.places.event.EventView;
import com.sap.sailing.gwt.home.shared.partials.filter.FilterValueChangeHandler;
import com.sap.sailing.gwt.home.shared.partials.filter.FilterValueProvider;
import com.sap.sse.common.InvertibleComparator;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.gwt.client.celltable.SortedCellTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractRaceList<T extends RaceMetadataDTO<? extends AbstractWindDTO>>
extends Composite
implements FilterValueProvider<SimpleCompetitorDTO>,
FilterValueChangeHandler<SimpleRaceMetadataDTO> {
    private static final RaceListResources.LocalCss CSS = RaceListResources.INSTANCE.css();
    private final SimplePanel cellTableContainer = new SimplePanel();
    protected final SortableRaceListColumn<T, ?> fleetCornerColumn = RaceListColumnFactory.getFleetCornerColumn();
    protected final SortableRaceListColumn<T, ?> raceNameColumn = RaceListColumnFactory.getRaceNameColumn();
    protected final SortableRaceListColumn<T, ?> fleetNameColumn = RaceListColumnFactory.getFleetNameColumn();
    protected final RaceListColumnFactory.SortableRaceListStartTimeColumn<T> startTimeColumn = RaceListColumnFactory.getStartTimeColumn();
    protected final SortableRaceListColumn<T, ?> windDirectionColumn = RaceListColumnFactory.getWindDirectionColumn();
    protected final SortableRaceListColumn<T, ?> raceViewerButtonColumn;
    protected final RaceListColumnSet columnSet;
    private final SortedCellTable<T> cellTable = new SortedCellTable(0, (CellTable.Resources)CleanCellTableResources.INSTANCE);
    private boolean tableColumnsInitialized = false;

    protected AbstractRaceList(EventView.Presenter presenter, RaceListColumnSet columnSet, boolean showNotTracked) {
        CSS.ensureInjected();
        this.raceViewerButtonColumn = RaceListColumnFactory.getRaceViewerButtonColumn((EventView.Presenter)presenter, (boolean)showNotTracked);
        this.columnSet = columnSet;
        this.cellTableContainer.setWidget((Widget)this.cellTable);
        this.initTableStyle();
        this.initWidget((Widget)this.cellTableContainer);
    }

    protected void setTableData(Collection<T> data) {
        this.ensureInitTableColumns();
        this.columnSet.updateColumnVisibilities();
        ArrayList<T> dataList = new ArrayList<T>(data);
        int i = 0;
        while (i < this.cellTable.getColumnCount()) {
            SortableRaceListColumn column = (SortableRaceListColumn)this.cellTable.getColumn(i);
            column.updateHeaderAndCellStyles();
            column.setRacesInNaturalOrder(dataList);
            ++i;
        }
        this.cellTable.setPageSize(data.size());
        this.cellTable.setList(data);
        this.restoreColumnSortInfos();
    }

    private void initTableStyle() {
        this.cellTable.addStyleName(CSS.raceslist());
        this.cellTable.setHeaderBuilder((HeaderBuilder)new StyledHeaderOrFooterBuilder((AbstractCellTable)this.cellTable, false, new String[]{CSS.raceslist_head()}));
        this.cellTable.setRowStyles((RowStyles)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void ensureInitTableColumns() {
        if (this.tableColumnsInitialized) {
            return;
        }
        this.tableColumnsInitialized = true;
        this.initTableColumns();
    }

    protected abstract void initTableColumns();

    /*
     * WARNING - void declaration
     */
    private void restoreColumnSortInfos() {
        List<Object> oldSortInfos;
        ColumnSortList sortList = this.cellTable.getColumnSortList();
        if (sortList.size() == 0) {
            boolean bl = this.getDefaultSortColumn().getPreferredSortingOrder().isAscending();
            oldSortInfos = Collections.singletonList(new ColumnSortList.ColumnSortInfo((Column)this.getDefaultSortColumn(), bl));
        } else {
            void var3_4;
            oldSortInfos = new ArrayList(sortList.size());
            int n = sortList.size() - 1;
            while (var3_4 >= 0) {
                oldSortInfos.add(sortList.get((int)var3_4));
                --var3_4;
            }
        }
        for (ColumnSortList.ColumnSortInfo columnSortInfo : oldSortInfos) {
            Column column = columnSortInfo.getColumn();
            this.cellTable.sortColumn(column);
        }
    }

    protected SortableRaceListColumn<T, ?> getDefaultSortColumn() {
        return this.raceNameColumn;
    }

    protected void add(SortableRaceListColumn<T, ?> column) {
        Header header = column.getHeader();
        boolean ascending = column.getPreferredSortingOrder().isAscending();
        InvertibleComparator comperator = column.getComparator();
        if (comperator != null) {
            comperator.setAscending(ascending);
        }
        this.cellTable.addColumn(column, header, comperator, ascending);
    }

    public void onFilterValueChanged(Filter<SimpleRaceMetadataDTO> filter) {
        this.cellTable.setRowStyles((RowStyles)new /* Unavailable Anonymous Inner Class!! */);
        this.cellTable.redraw();
    }

    public Collection<SimpleCompetitorDTO> getFilterableValues() {
        HashSet<SimpleCompetitorDTO> filterableValues = new HashSet<SimpleCompetitorDTO>();
        for (RaceMetadataDTO entry : this.cellTable.getDataProvider().getList()) {
            filterableValues.addAll(entry.getCompetitors());
        }
        return filterableValues;
    }

    public abstract boolean hasWind();

    public abstract boolean hasVideos();

    public abstract boolean hasAudios();

    static /* synthetic */ RaceListResources.LocalCss access$0() {
        return CSS;
    }
}

