/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.multiregattalist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.UIObject;
import com.sap.sailing.gwt.home.communication.race.FleetMetadataDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaProgressFleetDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaProgressSeriesDTO;
import com.sap.sailing.gwt.home.desktop.partials.multiregattalist.MultiRegattaListStepsBody;
import com.sap.sailing.gwt.home.desktop.partials.multiregattalist.MultiRegattaListStepsBodyFleet;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import java.util.Map;

public class MultiRegattaListStepsBody
extends UIObject
implements RequiresResize {
    private static final StringMessages I18N = StringMessages.INSTANCE;
    private static MultiRegattaListStepsBodyUiBinder uiBinder = (MultiRegattaListStepsBodyUiBinder)GWT.create(MultiRegattaListStepsBodyUiBinder.class);
    @UiField
    DivElement longNameDummyUi;
    @UiField
    DivElement mediumNameDummyUi;
    @UiField
    DivElement nameUi;
    @UiField
    DivElement checkUi;
    @UiField
    DivElement progressUi;
    @UiField
    DivElement fleetsContainerUi;
    @UiField
    DivElement textContainerUi;
    private final String seriesName;
    private final String seriesNameMedium;
    private final String seriesNameShort;
    private int seriesNameLength;
    private int seriesNameMediumLength;

    MultiRegattaListStepsBody(RegattaProgressSeriesDTO seriesProgress, boolean showName) {
        this.setElement((Element)uiBinder.createAndBindUi((Object)this));
        this.textContainerUi.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.seriesName = this.caculateSeriesName(seriesProgress, showName);
        this.longNameDummyUi.setInnerText(this.seriesName);
        this.seriesNameMedium = this.caculateSeriesNameMedium();
        this.mediumNameDummyUi.setInnerText(this.seriesNameMedium);
        this.seriesNameShort = this.caculateSeriesNameShort();
        if (seriesProgress.isCompleted()) {
            this.progressUi.setInnerText(I18N.racesCount(seriesProgress.getTotalRaceCount()));
        } else {
            this.checkUi.getStyle().setDisplay(Style.Display.NONE);
            this.progressUi.setInnerText(I18N.currentOfTotalRaces(seriesProgress.getProgressRaceCount(), seriesProgress.getTotalRaceCount()));
        }
        this.addFleetProgresses(seriesProgress.getFleetState(), seriesProgress.getMaxRacesPerFleet());
        this.setFleetsTooltip(seriesProgress.getFleetNames());
    }

    void init() {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addFleetProgresses(Map<FleetMetadataDTO, RegattaProgressFleetDTO> fleetStates, int totalRaceCount) {
        double height = fleetStates.isEmpty() ? 100.0 : 100.0 / (double)fleetStates.size();
        for (Map.Entry<FleetMetadataDTO, RegattaProgressFleetDTO> fleetState : fleetStates.entrySet()) {
            double finishedWidth = (double)fleetState.getValue().getFinishedRaceCount() * 100.0 / (double)totalRaceCount;
            double liveWidth = (double)fleetState.getValue().getFinishedAndLiveRaceCount() * 100.0 / (double)totalRaceCount;
            String fleetColor = fleetState.getKey().getFleetColor();
            MultiRegattaListStepsBodyFleet fleet = new MultiRegattaListStepsBodyFleet(finishedWidth, liveWidth, height, fleetColor);
            this.fleetsContainerUi.appendChild((Node)fleet.getElement());
        }
    }

    private void setFleetsTooltip(String[] fleetNames) {
        if (fleetNames.length > 1) {
            String fleetCount = String.valueOf(fleetNames.length);
            String fleetNameList = "(" + Util.join((String)", ", (String[])fleetNames) + ")";
            this.fleetsContainerUi.setTitle(Util.join((String)" ", (String[])new String[]{fleetCount, I18N.fleets(), fleetNameList}));
        }
    }

    private String caculateSeriesName(RegattaProgressSeriesDTO seriesProgress, boolean showName) {
        if (!showName || seriesProgress.getName() == null || seriesProgress.getName().isEmpty()) {
            this.nameUi.getStyle().setDisplay(Style.Display.NONE);
            return I18N.races();
        }
        return seriesProgress.getName();
    }

    private String caculateSeriesNameMedium() {
        String[] tokens = this.seriesName.split(" ");
        StringBuilder initials = new StringBuilder();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].isEmpty()) {
                initials.append('R');
            } else {
                initials.append(tokens[i].charAt(0));
            }
            ++i;
        }
        return initials.toString();
    }

    private String caculateSeriesNameShort() {
        return this.seriesName.substring(0, 1);
    }

    private void renderNames() {
        if (this.fleetsContainerUi.getOffsetWidth() >= this.seriesNameLength) {
            this.nameUi.setInnerText(this.seriesName);
        } else if (this.fleetsContainerUi.getOffsetWidth() >= this.seriesNameMediumLength) {
            this.nameUi.setInnerText(this.seriesNameMedium);
        } else {
            this.nameUi.setInnerText(this.seriesNameShort);
        }
    }

    public void onResize() {
        this.renderNames();
    }

    static /* synthetic */ void access$0(MultiRegattaListStepsBody multiRegattaListStepsBody, int n) {
        multiRegattaListStepsBody.seriesNameLength = n;
    }

    static /* synthetic */ void access$1(MultiRegattaListStepsBody multiRegattaListStepsBody, int n) {
        multiRegattaListStepsBody.seriesNameMediumLength = n;
    }

    static /* synthetic */ void access$2(MultiRegattaListStepsBody multiRegattaListStepsBody) {
        multiRegattaListStepsBody.renderNames();
    }
}

