/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.race;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.shared.DTO;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;

public class SimpleRaceMetadataDTO
implements DTO,
SecuredDTO,
Comparable<SimpleRaceMetadataDTO> {
    private static final long serialVersionUID = 4572985165272271996L;
    private String leaderboardName;
    private String leaderboardGroupName;
    private UUID leaderboardGroupId;
    private RegattaAndRaceIdentifier regattaAndRaceIdentifier;
    private String raceName;
    private Date start;
    private RaceViewState state;
    private RaceTrackingState trackingState;
    private SecurityInformationDTO securityInformation = new SecurityInformationDTO();
    private HashSet<SimpleCompetitorDTO> competitors = new HashSet();

    protected SimpleRaceMetadataDTO() {
    }

    public SimpleRaceMetadataDTO(String leaderboardName, RegattaAndRaceIdentifier regattaAndRaceIdentifier, String raceName) {
        this.leaderboardName = leaderboardName;
        this.regattaAndRaceIdentifier = regattaAndRaceIdentifier;
        this.raceName = raceName;
    }

    public String getLeaderboardName() {
        return this.leaderboardName;
    }

    public RegattaAndRaceIdentifier getRegattaAndRaceIdentifier() {
        return this.regattaAndRaceIdentifier;
    }

    public String getRaceName() {
        return this.raceName;
    }

    public String getLeaderboardGroupName() {
        return this.leaderboardGroupName;
    }

    public void setLeaderboardGroupName(String leaderboardGroupName) {
        this.leaderboardGroupName = leaderboardGroupName;
    }

    public UUID getLeaderboardGroupId() {
        return this.leaderboardGroupId;
    }

    public void setLeaderboardGroupId(UUID leaderboardGroupId) {
        this.leaderboardGroupId = leaderboardGroupId;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public RaceViewState getViewState() {
        return this.state;
    }

    public void setViewState(RaceViewState state) {
        this.state = state;
    }

    public RaceTrackingState getTrackingState() {
        return this.trackingState;
    }

    public void setTrackingState(RaceTrackingState trackingState) {
        this.trackingState = trackingState;
    }

    public void setCompetitors(Collection<SimpleCompetitorDTO> competitors) {
        this.competitors.addAll(competitors);
    }

    public Collection<SimpleCompetitorDTO> getCompetitors() {
        return this.competitors;
    }

    @Override
    public int compareTo(SimpleRaceMetadataDTO o) {
        int compareByRaceName = new NaturalComparator().compare(this.getRaceName(), o.getRaceName());
        return compareByRaceName != 0 ? compareByRaceName : Util.compareToWithNull((Comparable)this.getStart(), (Comparable)o.getStart(), (boolean)true);
    }

    public boolean hasValidTrackingData() {
        return this.getTrackingState() == RaceTrackingState.TRACKED_VALID_DATA;
    }

    public boolean isFinished() {
        return this.getViewState() == RaceViewState.FINISHED;
    }

    public boolean isRunning() {
        return this.getViewState() == RaceViewState.RUNNING || this.getViewState() == RaceViewState.FINISHING;
    }

    public boolean isScheduled() {
        return this.getViewState() == RaceViewState.SCHEDULED;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.regattaAndRaceIdentifier.getIdentifier();
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.TRACKED_RACE;
    }

    public String getName() {
        return this.raceName;
    }

    public final AccessControlListDTO getAccessControlList() {
        return this.securityInformation.getAccessControlList();
    }

    public final OwnershipDTO getOwnership() {
        return this.securityInformation.getOwnership();
    }

    public final void setAccessControlList(AccessControlListDTO accessControlList) {
        this.securityInformation.setAccessControlList(accessControlList);
    }

    public final void setOwnership(OwnershipDTO ownership) {
        this.securityInformation.setOwnership(ownership);
    }
}

