/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event;

import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventSeriesDTO;
import com.sap.sailing.gwt.ui.shared.EventReferenceDTO;
import java.util.Date;

public class EventMetadataDTO
extends EventReferenceDTO {
    private EventState state;
    private String venue;
    private String location;
    private Date startDate;
    private Date endDate;
    private String thumbnailImageURL;
    private Date currentServerTime;

    public EventMetadataDTO() {
        this.initCurrentServerTime();
    }

    public boolean isRunning() {
        return this.state == EventState.RUNNING;
    }

    public boolean isStarted() {
        return this.state.compareTo((Enum)EventState.RUNNING) >= 0;
    }

    public boolean isFinished() {
        return this.state == EventState.FINISHED;
    }

    private void initCurrentServerTime() {
        this.currentServerTime = new Date();
    }

    public Date getCurrentServerTime() {
        return this.currentServerTime;
    }

    public EventState getState() {
        return this.state;
    }

    public void setState(EventState state) {
        this.state = state;
    }

    public String getVenue() {
        return this.venue;
    }

    public void setVenue(String venue) {
        this.venue = venue;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getThumbnailImageURL() {
        return this.thumbnailImageURL;
    }

    public void setThumbnailImageURL(String thumbnailImageURL) {
        this.thumbnailImageURL = thumbnailImageURL;
    }

    public String getLocationOrVenue() {
        if (this.location != null && !this.location.isEmpty()) {
            return this.location;
        }
        return this.venue;
    }

    public String getLocationOrDisplayName() {
        if (this.location != null && !this.location.isEmpty()) {
            return this.location;
        }
        return this.getDisplayName();
    }

    public String getLocationAndVenue() {
        if (this.location != null && !this.location.isEmpty()) {
            return String.valueOf(this.location) + ", " + this.venue;
        }
        return this.venue;
    }

    public EventListEventSeriesDTO getEventSeries() {
        return null;
    }
}

