/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.anniversary;

import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.domain.common.dto.EventType;
import com.sap.sse.gwt.shared.DTO;
import java.util.UUID;

public class AnniversaryDTO
implements DTO {
    private int target;
    private int currentRaceCount;
    private EventType eventType;
    private AnniversaryType type;
    private UUID eventID;
    private String leaderboardName;
    private String remoteUrl;
    private String regattaName;
    private String raceName;
    private String leaderboardDisplayName;
    private String eventName;

    protected AnniversaryDTO() {
    }

    AnniversaryDTO(int target, int currentRaceCount, AnniversaryType type) {
        this.target = target;
        this.currentRaceCount = currentRaceCount;
        this.type = type;
    }

    AnniversaryDTO(int target, int currentRaceCount, AnniversaryType type, UUID eventID, String leaderboardName, String remoteUrl, String raceName, String regattaName, String eventName, String leaderboardDisplayName, EventType eventType) {
        this(target, currentRaceCount, type);
        this.eventID = eventID;
        this.leaderboardName = leaderboardName;
        this.remoteUrl = remoteUrl;
        this.raceName = raceName;
        this.regattaName = regattaName;
        this.eventName = eventName;
        this.leaderboardDisplayName = leaderboardDisplayName;
        this.eventType = eventType;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public int getTarget() {
        return this.target;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getLeaderboardDisplayName() {
        return this.leaderboardDisplayName;
    }

    public int getCurrentRaceCount() {
        return this.currentRaceCount;
    }

    public int getCountdown() {
        return this.target - this.currentRaceCount;
    }

    public AnniversaryType getType() {
        return this.type;
    }

    public UUID getEventID() {
        return this.eventID;
    }

    public String getLeaderboardName() {
        return this.leaderboardName;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public String getRegattaName() {
        return this.regattaName;
    }

    public String getRaceName() {
        return this.raceName;
    }

    public boolean isAnnouncement() {
        return this.eventID != null && this.leaderboardName != null && this.regattaName != null && this.raceName != null;
    }

    public String toString() {
        return "AnniversaryInformation [target=" + this.target + ", countdown=" + this.currentRaceCount + ", type=" + this.type + ", eventID=" + this.eventID + ", leaderboardName=" + this.leaderboardName + ", remoteUrl=" + this.remoteUrl + ", regattaName=" + this.regattaName + ", raceName=" + this.raceName + "]";
    }
}

