/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.leaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.leaderboard.PreLeaderboardWithImageView;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.leaderboard.PreLiveRaceLeaderboardWithImageViewImpl;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sse.gwt.client.ImageOnFlowPanelHelper;
import com.sap.sse.gwt.client.media.MediaMenuIcon;
import com.sap.sse.gwt.client.media.TakedownNoticeService;
import com.sap.sse.gwt.client.panels.ResizableFlowPanel;
import com.sap.sse.gwt.common.CommonSharedResources;

public class PreLiveRaceLeaderboardWithImageViewImpl
extends ResizeComposite
implements PreLeaderboardWithImageView {
    private static IdleLeaderBoardWithFlagsViewImplUiBinder uiBinder = (IdleLeaderBoardWithFlagsViewImplUiBinder)GWT.create(IdleLeaderBoardWithFlagsViewImplUiBinder.class);
    @UiField
    ResizableFlowPanel leaderBoardHolder;
    @UiField
    ResizableFlowPanel infoHolder;
    @UiField
    Label bottomInfoPanel;
    @UiField
    FlowPanel image;
    @UiField
    Label subline1;
    @UiField
    Label subline2;
    @UiField
    Label subline3;
    @UiField(provided=true)
    MediaMenuIcon takedownButton;
    private ImageProvider provider;

    public PreLiveRaceLeaderboardWithImageViewImpl(ImageProvider provider, TakedownNoticeService takedownNoticeService) {
        CommonSharedResources.INSTANCE.mainCss().ensureInjected();
        this.takedownButton = new MediaMenuIcon(takedownNoticeService, provider.getTakedownNoticeContextKey());
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.provider = provider;
    }

    public void startingWith(PreLeaderboardWithImageView.Slide1Presenter p, AcceptsOneWidget panel) {
        panel.setWidget((IsWidget)this);
    }

    public void setLeaderBoard(SingleRaceLeaderboardPanel leaderboardPanel) {
        this.leaderBoardHolder.add((Widget)leaderboardPanel);
    }

    public void onCompetitorSelect(CompetitorDTO selected) {
        String boatName;
        String imageUrl = this.provider.getImageUrl(selected);
        ImageOnFlowPanelHelper.setImage((FlowPanel)this.image, (String)imageUrl);
        this.takedownButton.setData(selected.getName(), imageUrl);
        if (selected.hasBoat() && (boatName = ((CompetitorWithBoatDTO)selected).getBoat().getName()) != null) {
            this.subline1.setText(boatName);
        } else {
            this.subline1.setText("");
        }
        if (selected.getName() != null) {
            this.subline2.setText(selected.getName());
        } else {
            this.subline2.setText("");
        }
        this.subline3.setText("");
    }

    public void scrollLeaderBoardToTop() {
        this.leaderBoardHolder.getElement().setScrollTop(0);
    }

    public void onStop() {
    }

    public void nextRace(RegattaAndRaceIdentifier race) {
        this.bottomInfoPanel.setText(String.valueOf(StringMessages.INSTANCE.next()) + " " + race.getRegattaName() + " " + race.getRaceName());
    }
}

