/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.nodes.base;

import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.ResettableEventBus;
import com.sap.sailing.gwt.autoplay.client.nodes.base.AutoPlayNode;
import com.sap.sailing.gwt.autoplay.client.nodes.base.AutoPlaySequenceNode;
import java.util.logging.Logger;

public abstract class AutoPlayNodeBase
implements AutoPlayNode {
    private static final Logger LOG = Logger.getLogger(AutoPlaySequenceNode.class.getName());
    private ResettableEventBus bus;
    private boolean isStopped;
    private String name;

    public AutoPlayNodeBase(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final void start(EventBus bus) {
        this.isStopped = false;
        this.bus = new ResettableEventBus(bus);
        this.onStart();
    }

    public final void stop() {
        this.isStopped = true;
        this.onStop();
        if (this.bus != null) {
            this.bus.removeHandlers();
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    protected EventBus getBus() {
        return this.bus;
    }

    public void log(String logMessage) {
        StringBuilder msg = new StringBuilder();
        msg.append(">> AUTOPLAY ");
        msg.append(this.getName());
        msg.append(" >> ");
        msg.append(logMessage);
        LOG.info(msg.toString());
    }
}

