/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.nodes.base;

import com.google.gwt.user.client.Timer;
import com.sap.sailing.gwt.autoplay.client.nodes.base.AutoPlayNode;
import com.sap.sailing.gwt.autoplay.client.nodes.base.BaseCompositeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class AutoPlayLoopNode
extends BaseCompositeNode {
    private List<AutoPlayNode> nodes = new ArrayList();
    private int loopTimePerNodeInSeconds;
    private int currentPos = -1;
    private Timer transitionTimer = new /* Unavailable Anonymous Inner Class!! */;

    public AutoPlayLoopNode(String name, int loopTimePerNodeInSeconds, AutoPlayNode ... nodes) {
        super(name);
        this.loopTimePerNodeInSeconds = loopTimePerNodeInSeconds;
        this.nodes.addAll(Arrays.asList(nodes));
    }

    private void gotoNext() {
        ++this.currentPos;
        if (this.currentPos > this.nodes.size() - 1) {
            this.currentPos = 0;
        }
        this.transitionTo((AutoPlayNode)this.nodes.get(this.currentPos));
    }

    protected void transitionTo(AutoPlayNode nextNode) {
        if (!this.isStopped()) {
            this.transitionTimer.schedule(this.loopTimePerNodeInSeconds * 1000);
            nextNode.customDurationHook((Consumer)new /* Unavailable Anonymous Inner Class!! */);
            super.transitionTo(nextNode);
        }
    }

    public void onStart() {
        this.log("Start sequence " + this.getName());
        this.currentPos = -1;
        this.gotoNext();
    }

    public void onStop() {
        this.log("Stop sequence " + this.getName());
        super.onStop();
        for (AutoPlayNode autoPlayNode : this.nodes) {
            autoPlayNode.stop();
        }
        this.transitionTimer.cancel();
    }

    static /* synthetic */ void access$0(AutoPlayLoopNode autoPlayLoopNode) {
        autoPlayLoopNode.gotoNext();
    }

    static /* synthetic */ Timer access$1(AutoPlayLoopNode autoPlayLoopNode) {
        return autoPlayLoopNode.transitionTimer;
    }
}

