/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.nodes;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.place.shared.Place;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayClientFactory;
import com.sap.sailing.gwt.autoplay.client.nodes.base.FiresPlaceNode;
import com.sap.sailing.gwt.autoplay.client.places.screens.idleloop.video.VideoPlace;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.client.media.VideoDTO;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class VideoNode
extends FiresPlaceNode {
    private final AutoPlayClientFactory cf;
    private int lastPlayed = -1;
    private VideoDTO currentVideo = null;
    private Consumer<Integer> durationConsumer;

    public VideoNode(AutoPlayClientFactory cf) {
        super(VideoNode.class.getName());
        this.cf = cf;
    }

    public void onStart() {
        EventDTO event = this.cf.getAutoPlayCtxSignalError().getEvent();
        List videos = event.getVideos().stream().filter(v -> v.hasTag(MediaTagConstants.BIGSCREEN.getName())).collect(Collectors.toList());
        if (videos.size() == 0) {
            this.lastPlayed = -1;
            this.currentVideo = null;
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
            return;
        }
        int nextVideo = this.lastPlayed + 1;
        if (nextVideo > videos.size() - 1) {
            nextVideo = 0;
        }
        this.currentVideo = (VideoDTO)videos.get(nextVideo);
        this.lastPlayed = nextVideo;
        this.setPlaceToGo((Place)new VideoPlace(this.currentVideo, this.durationConsumer));
        this.firePlaceChangeAndStartTimer();
    }

    public void customDurationHook(Consumer<Integer> consumer) {
        this.durationConsumer = consumer;
    }

    static /* synthetic */ Consumer access$0(VideoNode videoNode) {
        return videoNode.durationConsumer;
    }
}

