/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.nodes;

import com.google.gwt.place.shared.Place;
import com.google.web.bindery.event.shared.Event;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayClientFactory;
import com.sap.sailing.gwt.autoplay.client.app.AutoplayPerspectiveLifecycle;
import com.sap.sailing.gwt.autoplay.client.app.AutoplayPerspectiveOwnSettings;
import com.sap.sailing.gwt.autoplay.client.events.AutoPlayHeaderEvent;
import com.sap.sailing.gwt.autoplay.client.nodes.base.FiresPlaceNode;
import com.sap.sailing.gwt.autoplay.client.places.screens.idleloop.leaderboard.LeaderboardPlace;
import com.sap.sailing.gwt.autoplay.client.shared.header.SAPHeaderComponentLifecycle;
import com.sap.sailing.gwt.autoplay.client.shared.header.SAPHeaderComponentSettings;
import com.sap.sailing.gwt.autoplay.client.shared.leaderboard.MultiRaceLeaderboardWithZoomingPerspective;
import com.sap.sailing.gwt.autoplay.client.utils.AutoplayHelper;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.security.ui.client.WithSecurity;
import java.util.Arrays;

public class IdleRaceLeaderboard
extends FiresPlaceNode {
    private static final int REFRESH_INTERVAL_IN_MILLIS_LEADERBOARD = 10000;
    private final AutoPlayClientFactory cf;
    private final Timer leaderboardTimer;

    public IdleRaceLeaderboard(AutoPlayClientFactory cf) {
        super(IdleRaceLeaderboard.class.getName());
        this.cf = cf;
        this.leaderboardTimer = new Timer(Timer.PlayModes.Live, 3000L);
        this.leaderboardTimer.setRefreshInterval(10000L);
    }

    public void onStart() {
        this.leaderboardTimer.setTime(MillisecondsTimePoint.now().asMillis());
        this.leaderboardTimer.play();
        PerspectiveCompositeSettings settings = this.cf.getAutoPlayCtxSignalError().getAutoplaySettings();
        AutoplayPerspectiveLifecycle autoplayLifecycle = this.cf.getAutoPlayCtxSignalError().getAutoplayLifecycle();
        boolean withFullscreenButton = ((AutoplayPerspectiveOwnSettings)settings.getPerspectiveOwnSettings()).isFullscreen();
        PerspectiveCompositeSettings leaderboardSettings = (PerspectiveCompositeSettings)settings.findSettingsByComponentId(autoplayLifecycle.getLeaderboardLifecycle().getComponentId());
        StringMessages stringMessages = StringMessages.INSTANCE;
        SAPHeaderComponentLifecycle sapHeaderLifecycle = autoplayLifecycle.getLeaderboardLifecycle().getSapHeaderLifecycle();
        SAPHeaderComponentSettings headerSettings = (SAPHeaderComponentSettings)leaderboardSettings.findSettingsByComponentId(sapHeaderLifecycle.getComponentId());
        MultiRaceLeaderboardWithZoomingPerspective leaderboardPerspective = new MultiRaceLeaderboardWithZoomingPerspective(null, null, autoplayLifecycle.getLeaderboardLifecycle(), leaderboardSettings, this.cf.getSailingService(), this.cf.getUserService(), AutoplayHelper.asyncActionsExecutor, (CompetitorSelectionProvider)new CompetitorSelectionModel(true), this.leaderboardTimer, this.cf.getAutoPlayCtxSignalError().getContextDefinition().getLeaderboardName(), this.cf.getErrorReporter(), stringMessages, withFullscreenButton, Arrays.asList(DetailType.values()), (WithSecurity)this.cf);
        this.setPlaceToGo((Place)new LeaderboardPlace(leaderboardPerspective));
        this.getBus().fireEvent((Event)new AutoPlayHeaderEvent(headerSettings.getTitle(), ""));
        this.firePlaceChangeAndStartTimer();
    }

    public void onStop() {
        this.leaderboardTimer.pause();
        this.leaderboardTimer.reset();
    }
}

